/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.ContinuousOutputModel;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.HighamHall54Integrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolatorTestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class HighamHall54StepInterpolatorTest {
    @Test
    public void derivativesConsistency() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double scalAbsoluteTolerance;
        TestProblem3 pb = new TestProblem3(0.1);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalRelativeTolerance = scalAbsoluteTolerance = 1.0E-8;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        StepInterpolatorTestUtils.checkDerivativesConsistency((FirstOrderIntegrator)integ, pb, 0.01, 4.8E-12);
    }

    @Test
    public void serialization() throws IOException, ClassNotFoundException, DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double scalAbsoluteTolerance;
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalRelativeTolerance = scalAbsoluteTolerance = 1.0E-8;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        integ.addStepHandler((StepHandler)new ContinuousOutputModel());
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        for (StepHandler handler : integ.getStepHandlers()) {
            oos.writeObject(handler);
        }
        Assert.assertTrue((bos.size() > 185000 ? 1 : 0) != 0);
        Assert.assertTrue((bos.size() < 195000 ? 1 : 0) != 0);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ContinuousOutputModel cm = (ContinuousOutputModel)ois.readObject();
        Random random = new Random(347588535632L);
        double maxError = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double r = random.nextDouble();
            double time = r * pb.getInitialTime() + (1.0 - r) * pb.getFinalTime();
            cm.setInterpolatedTime(time);
            double[] interpolatedY = cm.getInterpolatedState();
            double[] theoreticalY = pb.computeTheoreticalState(time);
            double dx = interpolatedY[0] - theoreticalY[0];
            double dy = interpolatedY[1] - theoreticalY[1];
            double error = dx * dx + dy * dy;
            if (!(error > maxError)) continue;
            maxError = error;
        }
        Assert.assertTrue((maxError < 1.6E-10 ? 1 : 0) != 0);
    }

    @Test
    public void checkClone() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double scalAbsoluteTolerance;
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalRelativeTolerance = scalAbsoluteTolerance = 1.0E-8;
        HighamHall54Integrator integ = new HighamHall54Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        integ.addStepHandler(new StepHandler(){

            public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
                StepInterpolator cloned = interpolator.copy();
                double tA = cloned.getPreviousTime();
                double tB = cloned.getCurrentTime();
                double halfStep = FastMath.abs((double)(tB - tA)) / 2.0;
                Assert.assertEquals((double)interpolator.getPreviousTime(), (double)tA, (double)1.0E-12);
                Assert.assertEquals((double)interpolator.getCurrentTime(), (double)tB, (double)1.0E-12);
                for (int i = 0; i < 10; ++i) {
                    double t = ((double)i * tB + (double)(9 - i) * tA) / 9.0;
                    interpolator.setInterpolatedTime(t);
                    Assert.assertTrue((FastMath.abs((double)(cloned.getInterpolatedTime() - t)) > halfStep / 10.0 ? 1 : 0) != 0);
                    cloned.setInterpolatedTime(t);
                    Assert.assertEquals((double)t, (double)cloned.getInterpolatedTime(), (double)1.0E-12);
                    double[] referenceState = interpolator.getInterpolatedState();
                    double[] cloneState = cloned.getInterpolatedState();
                    for (int j = 0; j < referenceState.length; ++j) {
                        Assert.assertEquals((double)referenceState[j], (double)cloneState[j], (double)1.0E-12);
                    }
                }
            }

            public void init(double t0, double[] y0, double t) {
            }
        });
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }
}

