/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.util;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.sofm.util.ExponentialDecayFunction;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialDecayFunctionTest {
    @Test(expected=NotStrictlyPositiveException.class)
    public void testPrecondition1() {
        new ExponentialDecayFunction(0.0, 0.0, 2L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPrecondition2() {
        new ExponentialDecayFunction(1.0, 0.0, 2L);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPrecondition3() {
        new ExponentialDecayFunction(1.0, 1.0, 100L);
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPrecondition4() {
        new ExponentialDecayFunction(1.0, 0.2, 0L);
    }

    @Test
    public void testTrivial() {
        int n = 65;
        double init = 4.0;
        double valueAtN = 3.0;
        ExponentialDecayFunction f = new ExponentialDecayFunction(4.0, 3.0, 65L);
        Assert.assertEquals((double)4.0, (double)f.value(0L), (double)0.0);
        Assert.assertEquals((double)3.0, (double)f.value(65L), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(Long.MAX_VALUE), (double)0.0);
    }
}

