/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet;

import com.hazelcast.shaded.org.apache.commons.math3.ml.neuralnet.Neuron;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class NeuronTest {
    @Test
    public void testGetIdentifier() {
        long id = 1234567L;
        Neuron n = new Neuron(1234567L, new double[]{0.0});
        Assert.assertEquals((long)1234567L, (long)n.getIdentifier());
    }

    @Test
    public void testGetSize() {
        double[] features = new double[]{-1.0, -1.0E-97, 0.0, 23.456, 9.01E203};
        Neuron n = new Neuron(1L, features);
        Assert.assertEquals((long)features.length, (long)n.getSize());
    }

    @Test
    public void testGetFeatures() {
        double[] features = new double[]{-1.0, -1.0E-97, 0.0, 23.456, 9.01E203};
        Neuron n = new Neuron(1L, features);
        double[] f = n.getFeatures();
        Assert.assertFalse((f == features ? 1 : 0) != 0);
        Assert.assertEquals((long)features.length, (long)f.length);
        for (int i = 0; i < features.length; ++i) {
            Assert.assertEquals((double)features[i], (double)f[i], (double)0.0);
        }
    }

    @Test
    public void testCompareAndSetFeatures() {
        Neuron n = new Neuron(1L, new double[]{0.0});
        double[] expect = n.getFeatures();
        double[] update = new double[]{expect[0] + 1.23};
        boolean ok = n.compareAndSetFeatures(expect, update);
        Assert.assertTrue((boolean)ok);
        Assert.assertEquals((double)update[0], (double)n.getFeatures()[0], (double)0.0);
        double[] update1 = new double[]{update[0] + 4.56};
        ok = n.compareAndSetFeatures(expect, update1);
        Assert.assertFalse((boolean)ok);
        Assert.assertEquals((double)update[0], (double)n.getFeatures()[0], (double)0.0);
    }

    @Test
    public void testCopy() {
        Neuron n = new Neuron(1L, new double[]{9.87});
        double[] update = new double[]{n.getFeatures()[0] + 2.34};
        n.compareAndSetFeatures(n.getFeatures(), update);
        Neuron copy = n.copy();
        Assert.assertTrue((n.getFeatures()[0] == copy.getFeatures()[0] ? 1 : 0) != 0);
        Assert.assertEquals((long)n.getNumberOfAttemptedUpdates(), (long)copy.getNumberOfAttemptedUpdates());
        update = new double[]{1.23 * n.getFeatures()[0]};
        n.compareAndSetFeatures(n.getFeatures(), update);
        Assert.assertFalse((n.getFeatures()[0] == copy.getFeatures()[0] ? 1 : 0) != 0);
        Assert.assertNotEquals((long)n.getNumberOfSuccessfulUpdates(), (long)copy.getNumberOfSuccessfulUpdates());
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        Neuron out = new Neuron(123L, new double[]{-98.76, -1.0, 0.0, 1.0E-23, 543.21, 1.0E234});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(out);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        Neuron in = (Neuron)ois.readObject();
        Assert.assertEquals((long)out.getIdentifier(), (long)in.getIdentifier());
        double[] outF = out.getFeatures();
        double[] inF = in.getFeatures();
        Assert.assertEquals((long)outF.length, (long)inF.length);
        for (int i = 0; i < outF.length; ++i) {
            Assert.assertEquals((double)outF[i], (double)inF[i], (double)0.0);
        }
    }
}

