/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.TriDiagonalTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class TriDiagonalTransformerTest {
    private double[][] testSquare5 = new double[][]{{1.0, 2.0, 3.0, 1.0, 1.0}, {2.0, 1.0, 1.0, 3.0, 1.0}, {3.0, 1.0, 1.0, 1.0, 2.0}, {1.0, 3.0, 1.0, 2.0, 1.0}, {1.0, 1.0, 2.0, 1.0, 3.0}};
    private double[][] testSquare3 = new double[][]{{1.0, 3.0, 4.0}, {3.0, 2.0, 2.0}, {4.0, 2.0, 0.0}};

    @Test
    public void testNonSquare() {
        try {
            new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])new double[3][2]));
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testAEqualQTQt() {
        this.checkAEqualQTQt(MatrixUtils.createRealMatrix((double[][])this.testSquare5));
        this.checkAEqualQTQt(MatrixUtils.createRealMatrix((double[][])this.testSquare3));
    }

    private void checkAEqualQTQt(RealMatrix matrix) {
        TriDiagonalTransformer transformer = new TriDiagonalTransformer(matrix);
        RealMatrix q = transformer.getQ();
        RealMatrix qT = transformer.getQT();
        RealMatrix t = transformer.getT();
        double norm = q.multiply(t).multiply(qT).subtract(matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)4.0E-15);
    }

    @Test
    public void testNoAccessBelowDiagonal() {
        this.checkNoAccessBelowDiagonal(this.testSquare5);
        this.checkNoAccessBelowDiagonal(this.testSquare3);
    }

    private void checkNoAccessBelowDiagonal(double[][] data) {
        double[][] modifiedData = new double[data.length][];
        for (int i = 0; i < data.length; ++i) {
            modifiedData[i] = (double[])data[i].clone();
            Arrays.fill(modifiedData[i], 0, i, Double.NaN);
        }
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])modifiedData);
        TriDiagonalTransformer transformer = new TriDiagonalTransformer(matrix);
        RealMatrix q = transformer.getQ();
        RealMatrix qT = transformer.getQT();
        RealMatrix t = transformer.getT();
        double norm = q.multiply(t).multiply(qT).subtract(MatrixUtils.createRealMatrix((double[][])data)).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)4.0E-15);
    }

    @Test
    public void testQOrthogonal() {
        this.checkOrthogonal(new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getQ());
        this.checkOrthogonal(new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getQ());
    }

    @Test
    public void testQTOrthogonal() {
        this.checkOrthogonal(new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getQT());
        this.checkOrthogonal(new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getQT());
    }

    private void checkOrthogonal(RealMatrix m) {
        RealMatrix mTm = m.transpose().multiply(m);
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)mTm.getRowDimension());
        Assert.assertEquals((double)0.0, (double)mTm.subtract(id).getNorm(), (double)1.0E-15);
    }

    @Test
    public void testTTriDiagonal() {
        this.checkTriDiagonal(new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare5)).getT());
        this.checkTriDiagonal(new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])this.testSquare3)).getT());
    }

    private void checkTriDiagonal(RealMatrix m) {
        int rows = m.getRowDimension();
        int cols = m.getColumnDimension();
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                if (i >= j - 1 && i <= j + 1) continue;
                Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)1.0E-16);
            }
        }
    }

    @Test
    public void testMatricesValues5() {
        this.checkMatricesValues(this.testSquare5, new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0}, {0.0, -0.5163977794943222, 0.016748280772542083, 0.839800693771262, 0.16669620021405473}, {0.0, -0.7745966692414833, -0.4354553000860955, -0.44989322880603355, -0.08930153582895772}, {0.0, -0.2581988897471611, 0.6364346693566014, -0.30263204032131164, 0.6608313651342882}, {0.0, -0.2581988897471611, 0.6364346693566009, -0.027289660803112598, -0.7263191580755246}}, new double[]{1.0, 4.4, 1.433099579242636, -0.89537362758743, 2.062274048344794}, new double[]{-FastMath.sqrt((double)15.0), -3.0832882879592476, 0.6082710842351517, 1.1786086405912128});
    }

    @Test
    public void testMatricesValues3() {
        this.checkMatricesValues(this.testSquare3, new double[][]{{1.0, 0.0, 0.0}, {0.0, -0.6, 0.8}, {0.0, -0.8, -0.6}}, new double[]{1.0, 2.64, -0.64}, new double[]{-5.0, -1.52});
    }

    private void checkMatricesValues(double[][] matrix, double[][] qRef, double[] mainDiagnonal, double[] secondaryDiagonal) {
        TriDiagonalTransformer transformer = new TriDiagonalTransformer(MatrixUtils.createRealMatrix((double[][])matrix));
        RealMatrix q = transformer.getQ();
        Assert.assertEquals((double)0.0, (double)q.subtract(MatrixUtils.createRealMatrix((double[][])qRef)).getNorm(), (double)1.0E-14);
        RealMatrix t = transformer.getT();
        double[][] tData = new double[mainDiagnonal.length][mainDiagnonal.length];
        for (int i = 0; i < mainDiagnonal.length; ++i) {
            tData[i][i] = mainDiagnonal[i];
            if (i > 0) {
                tData[i][i - 1] = secondaryDiagonal[i - 1];
            }
            if (i >= secondaryDiagonal.length) continue;
            tData[i][i + 1] = secondaryDiagonal[i];
        }
        Assert.assertEquals((double)0.0, (double)t.subtract(MatrixUtils.createRealMatrix((double[][])tData)).getNorm(), (double)1.0E-14);
        Assert.assertTrue((q == transformer.getQ() ? 1 : 0) != 0);
        Assert.assertTrue((t == transformer.getT() ? 1 : 0) != 0);
    }
}

