/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.NormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathUnsupportedOperationException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.EigenDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.LUDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.TriDiagonalTransformer;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import java.util.Arrays;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class EigenDecompositionTest {
    private double[] refValues;
    private RealMatrix matrix;

    @Test
    public void testDimension1() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.5}});
        EigenDecomposition ed = new EigenDecomposition(matrix);
        Assert.assertEquals((double)1.5, (double)ed.getRealEigenvalue(0), (double)1.0E-15);
    }

    @Test
    public void testDimension2() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{59.0, 12.0}, {12.0, 66.0}});
        EigenDecomposition ed = new EigenDecomposition(matrix);
        Assert.assertEquals((double)75.0, (double)ed.getRealEigenvalue(0), (double)1.0E-15);
        Assert.assertEquals((double)50.0, (double)ed.getRealEigenvalue(1), (double)1.0E-15);
    }

    @Test
    public void testDimension3() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{39632.0, -4824.0, -16560.0}, {-4824.0, 8693.0, 7920.0}, {-16560.0, 7920.0, 17300.0}});
        EigenDecomposition ed = new EigenDecomposition(matrix);
        Assert.assertEquals((double)50000.0, (double)ed.getRealEigenvalue(0), (double)3.0E-11);
        Assert.assertEquals((double)12500.0, (double)ed.getRealEigenvalue(1), (double)3.0E-11);
        Assert.assertEquals((double)3125.0, (double)ed.getRealEigenvalue(2), (double)3.0E-11);
    }

    @Test
    public void testDimension3MultipleRoot() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{5.0, 10.0, 15.0}, {10.0, 20.0, 30.0}, {15.0, 30.0, 45.0}});
        EigenDecomposition ed = new EigenDecomposition(matrix);
        Assert.assertEquals((double)70.0, (double)ed.getRealEigenvalue(0), (double)3.0E-11);
        Assert.assertEquals((double)0.0, (double)ed.getRealEigenvalue(1), (double)3.0E-11);
        Assert.assertEquals((double)0.0, (double)ed.getRealEigenvalue(2), (double)3.0E-11);
    }

    @Test
    public void testDimension4WithSplit() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.784, -0.288, 0.0, 0.0}, {-0.288, 0.616, 0.0, 0.0}, {0.0, 0.0, 0.164, -0.048}, {0.0, 0.0, -0.048, 0.136}});
        EigenDecomposition ed = new EigenDecomposition(matrix);
        Assert.assertEquals((double)1.0, (double)ed.getRealEigenvalue(0), (double)1.0E-15);
        Assert.assertEquals((double)0.4, (double)ed.getRealEigenvalue(1), (double)1.0E-15);
        Assert.assertEquals((double)0.2, (double)ed.getRealEigenvalue(2), (double)1.0E-15);
        Assert.assertEquals((double)0.1, (double)ed.getRealEigenvalue(3), (double)1.0E-15);
    }

    @Test
    public void testDimension4WithoutSplit() {
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.5608, -0.2016, 0.1152, -0.2976}, {-0.2016, 0.4432, -0.2304, 0.1152}, {0.1152, -0.2304, 0.3088, -0.1344}, {-0.2976, 0.1152, -0.1344, 0.3872}});
        EigenDecomposition ed = new EigenDecomposition(matrix);
        Assert.assertEquals((double)1.0, (double)ed.getRealEigenvalue(0), (double)1.0E-15);
        Assert.assertEquals((double)0.4, (double)ed.getRealEigenvalue(1), (double)1.0E-15);
        Assert.assertEquals((double)0.2, (double)ed.getRealEigenvalue(2), (double)1.0E-15);
        Assert.assertEquals((double)0.1, (double)ed.getRealEigenvalue(3), (double)1.0E-15);
    }

    @Test
    public void testMath308() {
        double[] mainTridiagonal = new double[]{22.330154644539597, 46.65485522478641, 17.393672330044705, 54.46687435351116, 80.17800767709437};
        double[] secondaryTridiagonal = new double[]{13.04450406501361, -5.977590941539671, 2.9040909856707517, 7.1570352792841225};
        double[] refEigenValues = new double[]{82.044413207204, 53.45669769989451, 52.53627852011388, 18.84796973375426, 14.138204224043099};
        RealVector[] refEigenVectors = new RealVector[]{new ArrayRealVector(new double[]{-4.62690386766E-4, -0.002118073109055, 0.011530080757413, 0.252322434584915, 0.967572088232592}), new ArrayRealVector(new double[]{0.314647769490148, 0.750806415553905, -0.16770031202576, -0.537092972407375, 0.14385496812778}), new ArrayRealVector(new double[]{0.222368839324646, 0.514921891363332, -0.021377019336614, 0.801196801016305, -0.20744699124774}), new ArrayRealVector(new double[]{-0.713933751051495, 0.19058211355393, -0.671410443368332, 0.05605605595505, -0.006541576993581}), new ArrayRealVector(new double[]{-0.584677060845929, 0.367177264979103, 0.721453187784497, -0.052971054621812, 0.005740715188257})};
        EigenDecomposition decomposition = new EigenDecomposition(mainTridiagonal, secondaryTridiagonal);
        double[] eigenValues = decomposition.getRealEigenvalues();
        for (int i = 0; i < refEigenValues.length; ++i) {
            Assert.assertEquals((double)refEigenValues[i], (double)eigenValues[i], (double)1.0E-5);
            Assert.assertEquals((double)0.0, (double)refEigenVectors[i].subtract(decomposition.getEigenvector(i)).getNorm(), (double)2.0E-7);
        }
    }

    @Test
    public void testMathpbx02() {
        double[] mainTridiagonal = new double[]{7484.860960227216, 18405.28129035345, 13855.225609560746, 10016.708722343366, 559.8117399576674, 6750.190788301587, 71.21428769782159};
        double[] secondaryTridiagonal = new double[]{-4175.088570476366, 1975.7955858241994, 5193.178422374075, 1995.286659169179, 75.34535882933804, -234.0808002076056};
        double[] refEigenValues = new double[]{20654.744890306974, 16828.208208485466, 6893.155912634995, 6757.08301667534, 5887.799885688559, 64.30908992324038, 57.99262879273634};
        RealVector[] refEigenVectors = new RealVector[]{new ArrayRealVector(new double[]{-0.270356342026904, 0.852811091326997, 0.399639490702077, 0.19879465781399, 0.019739323307666, 1.06983022327E-4, -1.216636321E-6}), new ArrayRealVector(new double[]{0.179995273578326, -0.402807848153042, 0.701870993525734, 0.555058211014888, 0.068079148898236, 5.09139115227E-4, -7.112235617E-6}), new ArrayRealVector(new double[]{-0.399582721284727, -0.056629954519333, -0.514406488522827, 0.71116816451858, 0.225548081276367, 0.125943999652923, -0.004321507456014}), new ArrayRealVector(new double[]{0.058515721572821, 0.010200130057739, 0.063516274916536, -0.090696087449378, -0.017148420432597, 0.991318870265707, -0.034707338554096}), new ArrayRealVector(new double[]{0.855205995537564, 0.327134656629775, -0.265382397060548, 0.282690729026706, 0.105736068025572, -0.009138126622039, 3.67751821196E-4}), new ArrayRealVector(new double[]{-0.002913069901144, -0.005177515777101, 0.041906334478672, -0.109315918416258, 0.436192305456741, 0.026307315639535, 0.891797507436344}), new ArrayRealVector(new double[]{-0.005738311176435, -0.010207611670378, 0.082662420517928, -0.215733886094368, 0.861606487840411, -0.025478530652759, -0.451080697503958})};
        EigenDecomposition decomposition = new EigenDecomposition(mainTridiagonal, secondaryTridiagonal);
        double[] eigenValues = decomposition.getRealEigenvalues();
        for (int i = 0; i < refEigenValues.length; ++i) {
            Assert.assertEquals((double)refEigenValues[i], (double)eigenValues[i], (double)0.001);
            if (refEigenVectors[i].dotProduct(decomposition.getEigenvector(i)) < 0.0) {
                Assert.assertEquals((double)0.0, (double)refEigenVectors[i].add(decomposition.getEigenvector(i)).getNorm(), (double)1.0E-5);
                continue;
            }
            Assert.assertEquals((double)0.0, (double)refEigenVectors[i].subtract(decomposition.getEigenvector(i)).getNorm(), (double)1.0E-5);
        }
    }

    @Test
    public void testMathpbx03() {
        double[] mainTridiagonal = new double[]{1809.0978259647177, 3395.4763425956166, 1832.1894584712693, 3804.364873592377, 806.0482458637571, 2403.656427234185, 28.48691431556015};
        double[] secondaryTridiagonal = new double[]{-656.8932064545833, -469.30804108920734, -1021.7714889369421, -1152.540497328983, -939.9765163817368, -12.885877015422391};
        double[] refEigenValues = new double[]{4603.121913685183, 3691.195818048971, 2743.442955402465, 1657.5964421073218, 1336.7978190953313, 30.12986520967752, 17.035352085224986};
        RealVector[] refEigenVectors = new RealVector[]{new ArrayRealVector(new double[]{-0.036249830202337, 0.154184732411519, -0.346016328392363, 0.867540105133093, -0.294483395433451, 0.125854235969548, -3.54507444044E-4}), new ArrayRealVector(new double[]{-0.318654191697157, 0.912992309960507, -0.129270874079777, -0.184150038178035, 0.096521712579439, -0.070468788536461, 2.47918177736E-4}), new ArrayRealVector(new double[]{-0.051394668681147, 0.073102235876933, 0.173502042943743, -0.188311980310942, -0.327158794289386, 0.905206581432676, -0.004296342252659}), new ArrayRealVector(new double[]{0.838150199198361, 0.193305209055716, -0.457341242126146, -0.166933875895419, 0.094512811358535, 0.119062381338757, -9.41755685226E-4}), new ArrayRealVector(new double[]{0.438071395458547, 0.314969169786246, 0.768480630802146, 0.227919171600705, -0.193317045298647, -0.170305467485594, 0.001677380536009}), new ArrayRealVector(new double[]{-0.003726503878741, -0.010091946369146, -0.067152015137611, -0.113798146542187, -0.313123000097908, -0.118940107954918, 0.932862311396062}), new ArrayRealVector(new double[]{0.009373003194332, 0.0255703775594, 0.170955836081348, 0.29195451980575, 0.807824267665706, 0.320108347088646, 0.360202112392266})};
        EigenDecomposition decomposition = new EigenDecomposition(mainTridiagonal, secondaryTridiagonal);
        double[] eigenValues = decomposition.getRealEigenvalues();
        for (int i = 0; i < refEigenValues.length; ++i) {
            Assert.assertEquals((double)refEigenValues[i], (double)eigenValues[i], (double)1.0E-4);
            if (refEigenVectors[i].dotProduct(decomposition.getEigenvector(i)) < 0.0) {
                Assert.assertEquals((double)0.0, (double)refEigenVectors[i].add(decomposition.getEigenvector(i)).getNorm(), (double)1.0E-5);
                continue;
            }
            Assert.assertEquals((double)0.0, (double)refEigenVectors[i].subtract(decomposition.getEigenvector(i)).getNorm(), (double)1.0E-5);
        }
    }

    @Test
    public void testTridiagonal() {
        Random r = new Random(4366663527842L);
        double[] ref = new double[30];
        for (int i = 0; i < ref.length; ++i) {
            ref[i] = i < 5 ? 2.0 * r.nextDouble() - 1.0 : 1.0E-4 * r.nextDouble() + 6.0;
        }
        Arrays.sort(ref);
        TriDiagonalTransformer t = new TriDiagonalTransformer(EigenDecompositionTest.createTestMatrix(r, ref));
        EigenDecomposition ed = new EigenDecomposition(t.getMainDiagonalRef(), t.getSecondaryDiagonalRef());
        double[] eigenValues = ed.getRealEigenvalues();
        Assert.assertEquals((long)ref.length, (long)eigenValues.length);
        for (int i = 0; i < ref.length; ++i) {
            Assert.assertEquals((double)ref[ref.length - i - 1], (double)eigenValues[i], (double)2.0E-14);
        }
    }

    @Test
    public void testDimensions() {
        int m = this.matrix.getRowDimension();
        EigenDecomposition ed = new EigenDecomposition(this.matrix);
        Assert.assertEquals((long)m, (long)ed.getV().getRowDimension());
        Assert.assertEquals((long)m, (long)ed.getV().getColumnDimension());
        Assert.assertEquals((long)m, (long)ed.getD().getColumnDimension());
        Assert.assertEquals((long)m, (long)ed.getD().getColumnDimension());
        Assert.assertEquals((long)m, (long)ed.getVT().getRowDimension());
        Assert.assertEquals((long)m, (long)ed.getVT().getColumnDimension());
    }

    @Test
    public void testEigenvalues() {
        EigenDecomposition ed = new EigenDecomposition(this.matrix);
        double[] eigenValues = ed.getRealEigenvalues();
        Assert.assertEquals((long)this.refValues.length, (long)eigenValues.length);
        for (int i = 0; i < this.refValues.length; ++i) {
            Assert.assertEquals((double)this.refValues[i], (double)eigenValues[i], (double)3.0E-15);
        }
    }

    @Test
    public void testBigMatrix() {
        Random r = new Random(17748333525117L);
        double[] bigValues = new double[200];
        for (int i = 0; i < bigValues.length; ++i) {
            bigValues[i] = 2.0 * r.nextDouble() - 1.0;
        }
        Arrays.sort(bigValues);
        EigenDecomposition ed = new EigenDecomposition(EigenDecompositionTest.createTestMatrix(r, bigValues));
        double[] eigenValues = ed.getRealEigenvalues();
        Assert.assertEquals((long)bigValues.length, (long)eigenValues.length);
        for (int i = 0; i < bigValues.length; ++i) {
            Assert.assertEquals((double)bigValues[bigValues.length - i - 1], (double)eigenValues[i], (double)2.0E-14);
        }
    }

    @Test
    public void testSymmetric() {
        RealMatrix symmetric = MatrixUtils.createRealMatrix((double[][])new double[][]{{4.0, 1.0, 1.0}, {1.0, 2.0, 3.0}, {1.0, 3.0, 6.0}});
        EigenDecomposition ed = new EigenDecomposition(symmetric);
        RealMatrix d = ed.getD();
        RealMatrix v = ed.getV();
        RealMatrix vT = ed.getVT();
        double norm = v.multiply(d).multiply(vT).subtract(symmetric).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)6.0E-13);
    }

    @Test
    public void testSquareRoot() {
        double[][] data = new double[][]{{33.0, 24.0, 7.0}, {24.0, 57.0, 11.0}, {7.0, 11.0, 9.0}};
        EigenDecomposition dec = new EigenDecomposition(MatrixUtils.createRealMatrix((double[][])data));
        RealMatrix sqrtM = dec.getSquareRoot();
        RealMatrix m = sqrtM.multiply(sqrtM);
        int dim = data.length;
        for (int r = 0; r < dim; ++r) {
            for (int c = 0; c < dim; ++c) {
                Assert.assertEquals((String)("m[" + r + "][" + c + "]"), (double)data[r][c], (double)m.getEntry(r, c), (double)1.0E-13);
            }
        }
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testSquareRootNonSymmetric() {
        double[][] data = new double[][]{{1.0, 2.0, 4.0}, {2.0, 3.0, 5.0}, {11.0, 5.0, 9.0}};
        EigenDecomposition dec = new EigenDecomposition(MatrixUtils.createRealMatrix((double[][])data));
        RealMatrix sqrtM = dec.getSquareRoot();
    }

    @Test(expected=MathUnsupportedOperationException.class)
    public void testSquareRootNonPositiveDefinite() {
        double[][] data = new double[][]{{1.0, 2.0, 4.0}, {2.0, 3.0, 5.0}, {4.0, 5.0, -9.0}};
        EigenDecomposition dec = new EigenDecomposition(MatrixUtils.createRealMatrix((double[][])data));
        RealMatrix sqrtM = dec.getSquareRoot();
    }

    @Test
    public void testUnsymmetric() {
        double[][] vData = new double[][]{{-1.0, 1.0, -1.0, 1.0}, {-8.0, 4.0, -2.0, 1.0}, {27.0, 9.0, 3.0, 1.0}, {64.0, 16.0, 4.0, 1.0}};
        this.checkUnsymmetricMatrix(MatrixUtils.createRealMatrix((double[][])vData));
        RealMatrix randMatrix = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 1.0, 0.0, 0.0}, {1.0, 0.0, 2.0E-7, 0.0}, {0.0, -2.0E-7, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0}});
        this.checkUnsymmetricMatrix(randMatrix);
        double[][] randData2 = new double[][]{{0.68, -0.33, -0.27, -0.717, -0.687, 0.0259}, {-0.211, 0.536, 0.0268, 0.214, -0.198, 0.678}, {0.566, -0.444, 0.904, -0.967, -0.74, 0.225}, {0.597, 0.108, 0.832, -0.514, -0.782, -0.408}, {0.823, -0.0452, 0.271, -0.726, 0.998, 0.275}, {-0.605, 0.258, 0.435, 0.608, -0.563, 0.0486}};
        this.checkUnsymmetricMatrix(MatrixUtils.createRealMatrix((double[][])randData2));
    }

    @Test
    @Ignore
    public void testRandomUnsymmetricMatrix() {
        for (int run = 0; run < 100; ++run) {
            Random r = new Random(System.currentTimeMillis());
            int size = r.nextInt(20) + 4;
            double[][] data = new double[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    data[i][j] = r.nextInt(100);
                }
            }
            RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
            this.checkUnsymmetricMatrix(m);
        }
    }

    @Test
    public void testMath1051() {
        double[][] data = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 0.0, 1.0}};
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
        this.checkUnsymmetricMatrix(m);
    }

    @Test
    @Ignore
    public void testNormalDistributionUnsymmetricMatrix() {
        for (int run = 0; run < 100; ++run) {
            Random r = new Random(System.currentTimeMillis());
            NormalDistribution dist = new NormalDistribution(0.0, r.nextDouble() * 5.0);
            int size = r.nextInt(20) + 4;
            double[][] data = new double[size][size];
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < size; ++j) {
                    data[i][j] = dist.sample();
                }
            }
            RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
            this.checkUnsymmetricMatrix(m);
        }
    }

    @Test
    public void testMath848() {
        double[][] data = new double[][]{{0.184944928, -0.0646971046, 0.0774755812, -0.0969651755, -0.0692648806, 0.3282344352, -0.0177423074, 0.206313634}, {-0.0742700134, -0.028906303, -0.001726946, -0.0375550146, -0.0487737922, -0.2616837868, -0.0821201295, -0.2530000167}, {0.2549910127, 0.0995733692, -9.718388E-4, 0.0149282808, 0.1791878897, -0.0823182816, 0.0582629256, 0.3219545182}, {-0.0694747557, -0.1880649148, -0.2740630911, 0.0720096468, -0.1800836914, -0.3518996425, 0.2486747833, 0.6257938167}, {0.0536360918, -0.1339297778, 0.2241579764, -0.0195327484, -0.0054103808, 0.0347564518, 0.5120802482, -0.0329902864}, {-0.5933332356, -0.2488721082, 0.2357173629, 0.0177285473, 0.0856630593, -0.35671263, -0.1600668126, -0.1010899621}, {-0.0514349819, -0.0854319435, 0.1125050061, 0.006345356, -0.2250000688, -0.220934309, 0.1964623477, -0.1512329924}, {0.0197395947, -0.1997170581, -0.1425959019, -0.274947791, -0.0969467073, 0.060368852, -0.2826905192, 0.1794315473}};
        RealMatrix m = MatrixUtils.createRealMatrix((double[][])data);
        this.checkUnsymmetricMatrix(m);
    }

    private void checkUnsymmetricMatrix(RealMatrix m) {
        try {
            EigenDecomposition ed = new EigenDecomposition(m);
            RealMatrix d = ed.getD();
            RealMatrix v = ed.getV();
            RealMatrix x = m.multiply(v);
            RealMatrix y = v.multiply(d);
            double diffNorm = x.subtract(y).getNorm();
            Assert.assertTrue((String)("The norm of (X-Y) is too large: " + diffNorm + ", matrix=" + m.toString()), (x.subtract(y).getNorm() < 1000.0 * Precision.EPSILON * FastMath.max((double)x.getNorm(), (double)y.getNorm()) ? 1 : 0) != 0);
            RealMatrix invV = new LUDecomposition(v).getSolver().getInverse();
            double norm = v.multiply(d).multiply(invV).subtract(m).getNorm();
            Assert.assertEquals((double)0.0, (double)norm, (double)1.0E-10);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to create EigenDecomposition for matrix " + m.toString() + ", ex=" + e.toString()));
        }
    }

    @Test
    public void testEigenvectors() {
        EigenDecomposition ed = new EigenDecomposition(this.matrix);
        for (int i = 0; i < this.matrix.getRowDimension(); ++i) {
            double lambda = ed.getRealEigenvalue(i);
            RealVector v = ed.getEigenvector(i);
            RealVector mV = this.matrix.operate(v);
            Assert.assertEquals((double)0.0, (double)mV.subtract(v.mapMultiplyToSelf(lambda)).getNorm(), (double)1.0E-13);
        }
    }

    @Test
    public void testAEqualVDVt() {
        EigenDecomposition ed = new EigenDecomposition(this.matrix);
        RealMatrix v = ed.getV();
        RealMatrix d = ed.getD();
        RealMatrix vT = ed.getVT();
        double norm = v.multiply(d).multiply(vT).subtract(this.matrix).getNorm();
        Assert.assertEquals((double)0.0, (double)norm, (double)6.0E-13);
    }

    @Test
    public void testVOrthogonal() {
        RealMatrix v = new EigenDecomposition(this.matrix).getV();
        RealMatrix vTv = v.transpose().multiply(v);
        RealMatrix id = MatrixUtils.createRealIdentityMatrix((int)vTv.getRowDimension());
        Assert.assertEquals((double)0.0, (double)vTv.subtract(id).getNorm(), (double)2.0E-13);
    }

    @Test
    public void testDiagonal() {
        double[] diagonal = new double[]{-3.0, -2.0, 2.0, 5.0};
        RealMatrix m = MatrixUtils.createRealDiagonalMatrix((double[])diagonal);
        EigenDecomposition ed = new EigenDecomposition(m);
        Assert.assertEquals((double)diagonal[0], (double)ed.getRealEigenvalue(3), (double)2.0E-15);
        Assert.assertEquals((double)diagonal[1], (double)ed.getRealEigenvalue(2), (double)2.0E-15);
        Assert.assertEquals((double)diagonal[2], (double)ed.getRealEigenvalue(1), (double)2.0E-15);
        Assert.assertEquals((double)diagonal[3], (double)ed.getRealEigenvalue(0), (double)2.0E-15);
    }

    @Test
    public void testRepeatedEigenvalue() {
        RealMatrix repeated = MatrixUtils.createRealMatrix((double[][])new double[][]{{3.0, 2.0, 4.0}, {2.0, 0.0, 2.0}, {4.0, 2.0, 3.0}});
        EigenDecomposition ed = new EigenDecomposition(repeated);
        this.checkEigenValues(new double[]{8.0, -1.0, -1.0}, ed, 1.0E-12);
        this.checkEigenVector(new double[]{2.0, 1.0, 2.0}, ed, 1.0E-12);
    }

    @Test
    public void testDistinctEigenvalues() {
        RealMatrix distinct = MatrixUtils.createRealMatrix((double[][])new double[][]{{3.0, 1.0, -4.0}, {1.0, 3.0, -4.0}, {-4.0, -4.0, 8.0}});
        EigenDecomposition ed = new EigenDecomposition(distinct);
        this.checkEigenValues(new double[]{2.0, 0.0, 12.0}, ed, 1.0E-12);
        this.checkEigenVector(new double[]{1.0, -1.0, 0.0}, ed, 1.0E-12);
        this.checkEigenVector(new double[]{1.0, 1.0, 1.0}, ed, 1.0E-12);
        this.checkEigenVector(new double[]{-1.0, -1.0, 2.0}, ed, 1.0E-12);
    }

    @Test
    public void testZeroDivide() {
        RealMatrix indefinite = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 1.0, -1.0}, {1.0, 1.0, 0.0}, {-1.0, 0.0, 1.0}});
        EigenDecomposition ed = new EigenDecomposition(indefinite);
        this.checkEigenValues(new double[]{2.0, 1.0, -1.0}, ed, 1.0E-12);
        double isqrt3 = 1.0 / FastMath.sqrt((double)3.0);
        this.checkEigenVector(new double[]{isqrt3, isqrt3, -isqrt3}, ed, 1.0E-12);
        double isqrt2 = 1.0 / FastMath.sqrt((double)2.0);
        this.checkEigenVector(new double[]{0.0, -isqrt2, -isqrt2}, ed, 1.0E-12);
        double isqrt6 = 1.0 / FastMath.sqrt((double)6.0);
        this.checkEigenVector(new double[]{2.0 * isqrt6, -isqrt6, isqrt6}, ed, 1.0E-12);
    }

    @Test
    public void testTinyValues() {
        double tiny = 1.0E-100;
        RealMatrix distinct = MatrixUtils.createRealMatrix((double[][])new double[][]{{3.0, 1.0, -4.0}, {1.0, 3.0, -4.0}, {-4.0, -4.0, 8.0}});
        distinct = distinct.scalarMultiply(1.0E-100);
        EigenDecomposition ed = new EigenDecomposition(distinct);
        this.checkEigenValues(MathArrays.scale((double)1.0E-100, (double[])new double[]{2.0, 0.0, 12.0}), ed, 1.0E-112);
        this.checkEigenVector(new double[]{1.0, -1.0, 0.0}, ed, 1.0E-12);
        this.checkEigenVector(new double[]{1.0, 1.0, 1.0}, ed, 1.0E-12);
        this.checkEigenVector(new double[]{-1.0, -1.0, 2.0}, ed, 1.0E-12);
    }

    protected void checkEigenValues(double[] targetValues, EigenDecomposition ed, double tolerance) {
        double[] observed = ed.getRealEigenvalues();
        for (int i = 0; i < observed.length; ++i) {
            Assert.assertTrue((boolean)this.isIncludedValue(observed[i], targetValues, tolerance));
            Assert.assertTrue((boolean)this.isIncludedValue(targetValues[i], observed, tolerance));
        }
    }

    private boolean isIncludedValue(double value, double[] searchArray, double tolerance) {
        boolean found = false;
        for (int i = 0; !found && i < searchArray.length; ++i) {
            if (!(FastMath.abs((double)(value - searchArray[i])) < tolerance)) continue;
            found = true;
        }
        return found;
    }

    protected void checkEigenVector(double[] eigenVector, EigenDecomposition ed, double tolerance) {
        Assert.assertTrue((boolean)this.isIncludedColumn(eigenVector, ed.getV(), tolerance));
    }

    private boolean isIncludedColumn(double[] column, RealMatrix searchMatrix, double tolerance) {
        boolean found = false;
        for (int i = 0; !found && i < searchMatrix.getColumnDimension(); ++i) {
            double multiplier = 1.0;
            boolean matching = true;
            for (int j = 0; matching && j < searchMatrix.getRowDimension(); ++j) {
                double colEntry = searchMatrix.getEntry(j, i);
                if (FastMath.abs((double)(multiplier - 1.0)) <= FastMath.ulp((double)1.0) && FastMath.abs((double)colEntry) > 1.0E-14 && FastMath.abs((double)column[j]) > 1.0E-14) {
                    multiplier = colEntry / column[j];
                }
                if (!(FastMath.abs((double)(column[j] * multiplier - colEntry)) > tolerance)) continue;
                matching = false;
            }
            found = matching;
        }
        return found;
    }

    @Before
    public void setUp() {
        this.refValues = new double[]{2.003, 2.002, 2.001, 1.001, 1.0, 0.001};
        this.matrix = EigenDecompositionTest.createTestMatrix(new Random(35992629946426L), this.refValues);
    }

    @After
    public void tearDown() {
        this.refValues = null;
        this.matrix = null;
    }

    static RealMatrix createTestMatrix(Random r, double[] eigenValues) {
        int n = eigenValues.length;
        RealMatrix v = EigenDecompositionTest.createOrthogonalMatrix(r, n);
        RealMatrix d = MatrixUtils.createRealDiagonalMatrix((double[])eigenValues);
        return v.multiply(d).multiply(v.transpose());
    }

    public static RealMatrix createOrthogonalMatrix(Random r, int size) {
        double[][] data = new double[size][size];
        for (int i = 0; i < size; ++i) {
            double[] dataI = data[i];
            double norm2 = 0.0;
            do {
                for (int j = 0; j < size; ++j) {
                    dataI[j] = 2.0 * r.nextDouble() - 1.0;
                }
                for (int k = 0; k < i; ++k) {
                    int j;
                    double[] dataK = data[k];
                    double dotProduct = 0.0;
                    for (j = 0; j < size; ++j) {
                        dotProduct += dataI[j] * dataK[j];
                    }
                    for (j = 0; j < size; ++j) {
                        int n = j;
                        dataI[n] = dataI[n] - dotProduct * dataK[j];
                    }
                }
                norm2 = 0.0;
                for (double dataIJ : dataI) {
                    norm2 += dataIJ * dataIJ;
                }
                double inv = 1.0 / FastMath.sqrt((double)norm2);
                int j = 0;
                while (j < size) {
                    int n = j++;
                    dataI[n] = dataI[n] * inv;
                }
            } while (norm2 * (double)size < 0.01);
        }
        return MatrixUtils.createRealMatrix((double[][])data);
    }
}

