/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.FieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.Fraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionField;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayFieldVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVectorChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.FieldVectorPreservingVisitor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFieldVectorTest {
    protected Fraction[][] ma1 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(4), new Fraction(5), new Fraction(6)}, {new Fraction(7), new Fraction(8), new Fraction(9)}};
    protected Fraction[] vec1 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3)};
    protected Fraction[] vec2 = new Fraction[]{new Fraction(4), new Fraction(5), new Fraction(6)};
    protected Fraction[] vec3 = new Fraction[]{new Fraction(7), new Fraction(8), new Fraction(9)};
    protected Fraction[] vec4 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8), new Fraction(9)};
    protected Fraction[] vec_null = new Fraction[]{Fraction.ZERO, Fraction.ZERO, Fraction.ZERO};
    protected Fraction[] dvec1 = new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(3), new Fraction(4), new Fraction(5), new Fraction(6), new Fraction(7), new Fraction(8), new Fraction(9)};
    protected Fraction[][] mat1 = new Fraction[][]{{new Fraction(1), new Fraction(2), new Fraction(3)}, {new Fraction(4), new Fraction(5), new Fraction(6)}, {new Fraction(7), new Fraction(8), new Fraction(9)}};

    @Test
    public void testConstructors() {
        ArrayFieldVector v0 = new ArrayFieldVector((Field)FractionField.getInstance());
        Assert.assertEquals((long)0L, (long)v0.getDimension());
        ArrayFieldVector v1 = new ArrayFieldVector((Field)FractionField.getInstance(), 7);
        Assert.assertEquals((long)7L, (long)v1.getDimension());
        Assert.assertEquals((Object)Fraction.ZERO, (Object)v1.getEntry(6));
        ArrayFieldVector v2 = new ArrayFieldVector(5, (FieldElement)new Fraction(123, 100));
        Assert.assertEquals((long)5L, (long)v2.getDimension());
        Assert.assertEquals((Object)new Fraction(123, 100), (Object)v2.getEntry(4));
        ArrayFieldVector v3 = new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])this.vec1);
        Assert.assertEquals((long)3L, (long)v3.getDimension());
        Assert.assertEquals((Object)new Fraction(2), (Object)v3.getEntry(1));
        ArrayFieldVector v4 = new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])this.vec4, 3, 2);
        Assert.assertEquals((long)2L, (long)v4.getDimension());
        Assert.assertEquals((Object)new Fraction(4), (Object)v4.getEntry(0));
        try {
            new ArrayFieldVector((FieldElement[])this.vec4, 8, 3);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ArrayFieldVector v5_i = new ArrayFieldVector((FieldElement[])this.dvec1);
        Assert.assertEquals((long)9L, (long)v5_i.getDimension());
        Assert.assertEquals((Object)new Fraction(9), (Object)v5_i.getEntry(8));
        ArrayFieldVector v5 = new ArrayFieldVector((FieldElement[])this.dvec1);
        Assert.assertEquals((long)9L, (long)v5.getDimension());
        Assert.assertEquals((Object)new Fraction(9), (Object)v5.getEntry(8));
        ArrayFieldVector v6 = new ArrayFieldVector((FieldElement[])this.dvec1, 3, 2);
        Assert.assertEquals((long)2L, (long)v6.getDimension());
        Assert.assertEquals((Object)new Fraction(4), (Object)v6.getEntry(0));
        try {
            new ArrayFieldVector((FieldElement[])this.dvec1, 8, 3);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        ArrayFieldVector v7 = new ArrayFieldVector(v1);
        Assert.assertEquals((long)7L, (long)v7.getDimension());
        Assert.assertEquals((Object)Fraction.ZERO, (Object)v7.getEntry(6));
        FieldVectorTestImpl v7_i = new FieldVectorTestImpl((FieldElement[])this.vec1);
        ArrayFieldVector v7_2 = new ArrayFieldVector((FieldVector)v7_i);
        Assert.assertEquals((long)3L, (long)v7_2.getDimension());
        Assert.assertEquals((Object)new Fraction(2), (Object)v7_2.getEntry(1));
        ArrayFieldVector v8 = new ArrayFieldVector(v1, true);
        Assert.assertEquals((long)7L, (long)v8.getDimension());
        Assert.assertEquals((Object)Fraction.ZERO, (Object)v8.getEntry(6));
        Assert.assertNotSame((String)"testData not same object ", (Object)v1.getDataRef(), (Object)v8.getDataRef());
        ArrayFieldVector v8_2 = new ArrayFieldVector(v1, false);
        Assert.assertEquals((long)7L, (long)v8_2.getDimension());
        Assert.assertEquals((Object)Fraction.ZERO, (Object)v8_2.getEntry(6));
        Assert.assertArrayEquals((Object[])v1.getDataRef(), (Object[])v8_2.getDataRef());
        ArrayFieldVector v9 = new ArrayFieldVector((FieldVector)v1, (FieldVector)v3);
        Assert.assertEquals((long)10L, (long)v9.getDimension());
        Assert.assertEquals((Object)new Fraction(1), (Object)v9.getEntry(7));
    }

    @Test
    public void testDataInOut() {
        ArrayFieldVector v1 = new ArrayFieldVector((FieldElement[])this.vec1);
        ArrayFieldVector v2 = new ArrayFieldVector((FieldElement[])this.vec2);
        ArrayFieldVector v4 = new ArrayFieldVector((FieldElement[])this.vec4);
        FieldVectorTestImpl v2_t = new FieldVectorTestImpl((FieldElement[])this.vec2);
        ArrayFieldVector v_append_1 = v1.append(v2);
        Assert.assertEquals((long)6L, (long)v_append_1.getDimension());
        Assert.assertEquals((Object)new Fraction(4), (Object)v_append_1.getEntry(3));
        FieldVector v_append_2 = v1.append((FieldElement)new Fraction(2));
        Assert.assertEquals((long)4L, (long)v_append_2.getDimension());
        Assert.assertEquals((Object)new Fraction(2), (Object)v_append_2.getEntry(3));
        FieldVector v_append_4 = v1.append((FieldVector)v2_t);
        Assert.assertEquals((long)6L, (long)v_append_4.getDimension());
        Assert.assertEquals((Object)new Fraction(4), (Object)v_append_4.getEntry(3));
        FieldVector v_copy = v1.copy();
        Assert.assertEquals((long)3L, (long)v_copy.getDimension());
        Assert.assertNotSame((String)"testData not same object ", (Object)v1.getDataRef(), (Object)v_copy.toArray());
        Fraction[] a_frac = (Fraction[])v1.toArray();
        Assert.assertEquals((long)3L, (long)a_frac.length);
        Assert.assertNotSame((String)"testData not same object ", (Object)v1.getDataRef(), (Object)a_frac);
        FieldVector vout5 = v4.getSubVector(3, 3);
        Assert.assertEquals((long)3L, (long)vout5.getDimension());
        Assert.assertEquals((Object)new Fraction(5), (Object)vout5.getEntry(1));
        try {
            v4.getSubVector(3, 7);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        ArrayFieldVector v_set1 = (ArrayFieldVector)v1.copy();
        v_set1.setEntry(1, (FieldElement)new Fraction(11));
        Assert.assertEquals((Object)new Fraction(11), (Object)v_set1.getEntry(1));
        try {
            v_set1.setEntry(3, (FieldElement)new Fraction(11));
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        ArrayFieldVector v_set2 = (ArrayFieldVector)v4.copy();
        v_set2.set(3, v1);
        Assert.assertEquals((Object)new Fraction(1), (Object)v_set2.getEntry(3));
        Assert.assertEquals((Object)new Fraction(7), (Object)v_set2.getEntry(6));
        try {
            v_set2.set(7, v1);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        ArrayFieldVector v_set3 = (ArrayFieldVector)v1.copy();
        v_set3.set((FieldElement)new Fraction(13));
        Assert.assertEquals((Object)new Fraction(13), (Object)v_set3.getEntry(2));
        try {
            v_set3.getEntry(23);
            Assert.fail((String)"ArrayIndexOutOfBoundsException expected");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        ArrayFieldVector v_set4 = (ArrayFieldVector)v4.copy();
        v_set4.setSubVector(3, (FieldVector)v2_t);
        Assert.assertEquals((Object)new Fraction(4), (Object)v_set4.getEntry(3));
        Assert.assertEquals((Object)new Fraction(7), (Object)v_set4.getEntry(6));
        try {
            v_set4.setSubVector(7, (FieldVector)v2_t);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        ArrayFieldVector vout10 = (ArrayFieldVector)v1.copy();
        ArrayFieldVector vout10_2 = (ArrayFieldVector)v1.copy();
        Assert.assertEquals((Object)vout10, (Object)vout10_2);
        vout10_2.setEntry(0, (FieldElement)new Fraction(11, 10));
        Assert.assertNotSame((Object)vout10, (Object)vout10_2);
    }

    @Test
    public void testMapFunctions() {
        ArrayFieldVector v1 = new ArrayFieldVector((FieldElement[])this.vec1);
        FieldVector v_mapAdd = v1.mapAdd((FieldElement)new Fraction(2));
        Fraction[] result_mapAdd = new Fraction[]{new Fraction(3), new Fraction(4), new Fraction(5)};
        this.checkArray("compare vectors", result_mapAdd, (Fraction[])v_mapAdd.toArray());
        FieldVector v_mapAddToSelf = v1.copy();
        v_mapAddToSelf.mapAddToSelf((FieldElement)new Fraction(2));
        Fraction[] result_mapAddToSelf = new Fraction[]{new Fraction(3), new Fraction(4), new Fraction(5)};
        this.checkArray("compare vectors", result_mapAddToSelf, (Fraction[])v_mapAddToSelf.toArray());
        FieldVector v_mapSubtract = v1.mapSubtract((FieldElement)new Fraction(2));
        Fraction[] result_mapSubtract = new Fraction[]{new Fraction(-1), Fraction.ZERO, new Fraction(1)};
        this.checkArray("compare vectors", result_mapSubtract, (Fraction[])v_mapSubtract.toArray());
        FieldVector v_mapSubtractToSelf = v1.copy();
        v_mapSubtractToSelf.mapSubtractToSelf((FieldElement)new Fraction(2));
        Fraction[] result_mapSubtractToSelf = new Fraction[]{new Fraction(-1), Fraction.ZERO, new Fraction(1)};
        this.checkArray("compare vectors", result_mapSubtractToSelf, (Fraction[])v_mapSubtractToSelf.toArray());
        FieldVector v_mapMultiply = v1.mapMultiply((FieldElement)new Fraction(2));
        Fraction[] result_mapMultiply = new Fraction[]{new Fraction(2), new Fraction(4), new Fraction(6)};
        this.checkArray("compare vectors", result_mapMultiply, (Fraction[])v_mapMultiply.toArray());
        FieldVector v_mapMultiplyToSelf = v1.copy();
        v_mapMultiplyToSelf.mapMultiplyToSelf((FieldElement)new Fraction(2));
        Fraction[] result_mapMultiplyToSelf = new Fraction[]{new Fraction(2), new Fraction(4), new Fraction(6)};
        this.checkArray("compare vectors", result_mapMultiplyToSelf, (Fraction[])v_mapMultiplyToSelf.toArray());
        FieldVector v_mapDivide = v1.mapDivide((FieldElement)new Fraction(2));
        Fraction[] result_mapDivide = new Fraction[]{new Fraction(1, 2), new Fraction(1), new Fraction(3, 2)};
        this.checkArray("compare vectors", result_mapDivide, (Fraction[])v_mapDivide.toArray());
        FieldVector v_mapDivideToSelf = v1.copy();
        v_mapDivideToSelf.mapDivideToSelf((FieldElement)new Fraction(2));
        Fraction[] result_mapDivideToSelf = new Fraction[]{new Fraction(1, 2), new Fraction(1), new Fraction(3, 2)};
        this.checkArray("compare vectors", result_mapDivideToSelf, (Fraction[])v_mapDivideToSelf.toArray());
        FieldVector v_mapInv = v1.mapInv();
        Fraction[] result_mapInv = new Fraction[]{new Fraction(1), new Fraction(1, 2), new Fraction(1, 3)};
        this.checkArray("compare vectors", result_mapInv, (Fraction[])v_mapInv.toArray());
        FieldVector v_mapInvToSelf = v1.copy();
        v_mapInvToSelf.mapInvToSelf();
        Fraction[] result_mapInvToSelf = new Fraction[]{new Fraction(1), new Fraction(1, 2), new Fraction(1, 3)};
        this.checkArray("compare vectors", result_mapInvToSelf, (Fraction[])v_mapInvToSelf.toArray());
    }

    @Test
    public void testBasicFunctions() {
        ArrayFieldVector v1 = new ArrayFieldVector((FieldElement[])this.vec1);
        ArrayFieldVector v2 = new ArrayFieldVector((FieldElement[])this.vec2);
        new ArrayFieldVector((FieldElement[])this.vec_null);
        FieldVectorTestImpl v2_t = new FieldVectorTestImpl((FieldElement[])this.vec2);
        ArrayFieldVector v_add = v1.add(v2);
        Fraction[] result_add = new Fraction[]{new Fraction(5), new Fraction(7), new Fraction(9)};
        this.checkArray("compare vect", (Fraction[])v_add.getData(), result_add);
        FieldVectorTestImpl vt2 = new FieldVectorTestImpl((FieldElement[])this.vec2);
        FieldVector v_add_i = v1.add((FieldVector)vt2);
        Fraction[] result_add_i = new Fraction[]{new Fraction(5), new Fraction(7), new Fraction(9)};
        this.checkArray("compare vect", (Fraction[])v_add_i.toArray(), result_add_i);
        ArrayFieldVector v_subtract = v1.subtract(v2);
        Fraction[] result_subtract = new Fraction[]{new Fraction(-3), new Fraction(-3), new Fraction(-3)};
        this.checkArray("compare vect", (Fraction[])v_subtract.getData(), result_subtract);
        FieldVector v_subtract_i = v1.subtract((FieldVector)vt2);
        Fraction[] result_subtract_i = new Fraction[]{new Fraction(-3), new Fraction(-3), new Fraction(-3)};
        this.checkArray("compare vect", (Fraction[])v_subtract_i.toArray(), result_subtract_i);
        ArrayFieldVector v_ebeMultiply = v1.ebeMultiply(v2);
        Fraction[] result_ebeMultiply = new Fraction[]{new Fraction(4), new Fraction(10), new Fraction(18)};
        this.checkArray("compare vect", (Fraction[])v_ebeMultiply.getData(), result_ebeMultiply);
        FieldVector v_ebeMultiply_2 = v1.ebeMultiply((FieldVector)v2_t);
        Fraction[] result_ebeMultiply_2 = new Fraction[]{new Fraction(4), new Fraction(10), new Fraction(18)};
        this.checkArray("compare vect", (Fraction[])v_ebeMultiply_2.toArray(), result_ebeMultiply_2);
        ArrayFieldVector v_ebeDivide = v1.ebeDivide(v2);
        Fraction[] result_ebeDivide = new Fraction[]{new Fraction(1, 4), new Fraction(2, 5), new Fraction(1, 2)};
        this.checkArray("compare vect", (Fraction[])v_ebeDivide.getData(), result_ebeDivide);
        FieldVector v_ebeDivide_2 = v1.ebeDivide((FieldVector)v2_t);
        Fraction[] result_ebeDivide_2 = new Fraction[]{new Fraction(1, 4), new Fraction(2, 5), new Fraction(1, 2)};
        this.checkArray("compare vect", (Fraction[])v_ebeDivide_2.toArray(), result_ebeDivide_2);
        Fraction dot = (Fraction)v1.dotProduct(v2);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(32), (Object)dot);
        Fraction dot_2 = (Fraction)v1.dotProduct((FieldVector)v2_t);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(32), (Object)dot_2);
        FieldMatrix m_outerProduct = v1.outerProduct(v2);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(4), (Object)m_outerProduct.getEntry(0, 0));
        FieldMatrix m_outerProduct_2 = v1.outerProduct((FieldVector)v2_t);
        Assert.assertEquals((String)"compare val ", (Object)new Fraction(4), (Object)m_outerProduct_2.getEntry(0, 0));
        ArrayFieldVector v_projection = v1.projection(v2);
        Fraction[] result_projection = new Fraction[]{new Fraction(128, 77), new Fraction(160, 77), new Fraction(192, 77)};
        this.checkArray("compare vect", (Fraction[])v_projection.getData(), result_projection);
        FieldVector v_projection_2 = v1.projection((FieldVector)v2_t);
        Fraction[] result_projection_2 = new Fraction[]{new Fraction(128, 77), new Fraction(160, 77), new Fraction(192, 77)};
        this.checkArray("compare vect", (Fraction[])v_projection_2.toArray(), result_projection_2);
    }

    @Test
    public void testMisc() {
        ArrayFieldVector v1 = new ArrayFieldVector((FieldElement[])this.vec1);
        ArrayFieldVector v4 = new ArrayFieldVector((FieldElement[])this.vec4);
        ArrayFieldVector v4_2 = new ArrayFieldVector((FieldElement[])this.vec4);
        String out1 = v1.toString();
        Assert.assertTrue((String)"some output ", (out1.length() != 0 ? 1 : 0) != 0);
        try {
            v1.checkVectorDimensions(2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            v1.checkVectorDimensions((FieldVector)v4);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            v1.checkVectorDimensions((FieldVector)v4_2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSerial() {
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])this.vec1);
        Assert.assertEquals((Object)v, (Object)TestUtils.serializeAndRecover(v));
    }

    @Test
    public void testZeroVectors() {
        try {
            new ArrayFieldVector((FieldElement[])new Fraction[0]);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new ArrayFieldVector((FieldElement[])new Fraction[0], true);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            new ArrayFieldVector((FieldElement[])new Fraction[0], false);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[0]).getDimension());
        Assert.assertEquals((long)0L, (long)new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[0], true).getDimension());
        Assert.assertEquals((long)0L, (long)new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[0], false).getDimension());
    }

    @Test
    public void testOuterProduct() {
        ArrayFieldVector u = new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[]{new Fraction(1), new Fraction(2), new Fraction(-3)});
        ArrayFieldVector v = new ArrayFieldVector((Field)FractionField.getInstance(), (FieldElement[])new Fraction[]{new Fraction(4), new Fraction(-2)});
        FieldMatrix uv = u.outerProduct(v);
        double tol = Math.ulp(1.0);
        Assert.assertEquals((double)new Fraction(4).doubleValue(), (double)((Fraction)uv.getEntry(0, 0)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(-2).doubleValue(), (double)((Fraction)uv.getEntry(0, 1)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(8).doubleValue(), (double)((Fraction)uv.getEntry(1, 0)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(-4).doubleValue(), (double)((Fraction)uv.getEntry(1, 1)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(-12).doubleValue(), (double)((Fraction)uv.getEntry(2, 0)).doubleValue(), (double)tol);
        Assert.assertEquals((double)new Fraction(6).doubleValue(), (double)((Fraction)uv.getEntry(2, 1)).doubleValue(), (double)tol);
    }

    protected void checkArray(String msg, Fraction[] m, Fraction[] n) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors have different lengths");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((String)(msg + " " + i + " elements differ"), (Object)m[i], (Object)n[i]);
        }
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private int expectedIndex;

            public void visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                this.expectedIndex = 0;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor);
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor2() {
        ArrayFieldVector<Fraction> v = this.create(5);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){

            public void visit(int index, Fraction value) {
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInDefaultOrderPreservingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private int expectedIndex;

            public void visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                this.expectedIndex = 2;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorPreservingVisitor)visitor, 2, 7);
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public void visit(int actualIndex, Fraction actualValue) {
                this.visited[actualIndex] = true;
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                Arrays.fill(this.visited, false);
            }

            public Fraction end() {
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor);
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor2() {
        ArrayFieldVector<Fraction> v = this.create(5);
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){

            public void visit(int index, Fraction value) {
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInOptimizedOrderPreservingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorPreservingVisitor<Fraction> visitor = new FieldVectorPreservingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public void visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                this.visited[actualIndex] = true;
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                Arrays.fill(this.visited, true);
            }

            public Fraction end() {
                for (int i = 2; i <= 7; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorPreservingVisitor)visitor, 2, 7);
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private int expectedIndex;

            public Fraction visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                this.expectedIndex = 0;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor2() {
        ArrayFieldVector<Fraction> v = this.create(5);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){

            public Fraction visit(int index, Fraction value) {
                return Fraction.ZERO;
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInDefaultOrderChangingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private int expectedIndex;

            public Fraction visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((long)this.expectedIndex, (long)actualIndex);
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                ++this.expectedIndex;
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                this.expectedIndex = 2;
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        v.walkInDefaultOrder((FieldVectorChangingVisitor)visitor, 2, 7);
        for (int i = 2; i <= 7; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor1() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public Fraction visit(int actualIndex, Fraction actualValue) {
                this.visited[actualIndex] = true;
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)0L, (long)actualStart);
                Assert.assertEquals((long)(data.length - 1), (long)actualEnd);
                Arrays.fill(this.visited, false);
            }

            public Fraction end() {
                for (int i = 0; i < data.length; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor);
        for (int i = 0; i < data.length; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor2() {
        ArrayFieldVector<Fraction> v = this.create(5);
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){

            public Fraction visit(int index, Fraction value) {
                return Fraction.ZERO;
            }

            public void start(int dimension, int start, int end) {
            }

            public Fraction end() {
                return Fraction.ZERO;
            }
        };
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, -1, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 5, 4);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 0, -1);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 0, 5);
            Assert.fail();
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 4, 0);
            Assert.fail();
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
    }

    @Test
    public void testWalkInOptimizedOrderChangingVisitor3() {
        final Fraction[] data = new Fraction[]{Fraction.ZERO, Fraction.ONE, Fraction.ZERO, Fraction.ZERO, Fraction.TWO, Fraction.ZERO, Fraction.ZERO, Fraction.ZERO, new Fraction(3)};
        ArrayFieldVector v = new ArrayFieldVector((FieldElement[])data);
        int expectedStart = 2;
        int expectedEnd = 7;
        FieldVectorChangingVisitor<Fraction> visitor = new FieldVectorChangingVisitor<Fraction>(){
            private final boolean[] visited;
            {
                this.visited = new boolean[data.length];
            }

            public Fraction visit(int actualIndex, Fraction actualValue) {
                Assert.assertEquals((String)Integer.toString(actualIndex), (Object)data[actualIndex], (Object)actualValue);
                this.visited[actualIndex] = true;
                return actualValue.add(actualIndex);
            }

            public void start(int actualSize, int actualStart, int actualEnd) {
                Assert.assertEquals((long)data.length, (long)actualSize);
                Assert.assertEquals((long)2L, (long)actualStart);
                Assert.assertEquals((long)7L, (long)actualEnd);
                Arrays.fill(this.visited, true);
            }

            public Fraction end() {
                for (int i = 2; i <= 7; ++i) {
                    Assert.assertTrue((String)("entry " + i + "has not been visited"), (boolean)this.visited[i]);
                }
                return Fraction.ZERO;
            }
        };
        v.walkInOptimizedOrder((FieldVectorChangingVisitor)visitor, 2, 7);
        for (int i = 2; i <= 7; ++i) {
            Assert.assertEquals((String)("entry " + i), (Object)data[i].add(i), (Object)v.getEntry(i));
        }
    }

    private ArrayFieldVector<Fraction> create(int n) {
        Fraction[] t = new Fraction[n];
        for (int i = 0; i < n; ++i) {
            t[i] = Fraction.ZERO;
        }
        return new ArrayFieldVector((FieldElement[])t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FieldVectorTestImpl<T extends FieldElement<T>>
    implements FieldVector<T>,
    Serializable {
        private static final long serialVersionUID = 3970959016014158539L;
        private final Field<T> field;
        protected T[] data;

        private T[] buildArray(int length) {
            return (FieldElement[])Array.newInstance(this.field.getRuntimeClass(), length);
        }

        public FieldVectorTestImpl(T[] d) {
            this.field = d[0].getField();
            this.data = (FieldElement[])d.clone();
        }

        public Field<T> getField() {
            return this.field;
        }

        private UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("Not supported, unneeded for test purposes");
        }

        public FieldVector<T> copy() {
            throw this.unsupported();
        }

        public FieldVector<T> add(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldVector<T> add(T[] v) {
            throw this.unsupported();
        }

        public FieldVector<T> subtract(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldVector<T> subtract(T[] v) {
            throw this.unsupported();
        }

        public FieldVector<T> mapAdd(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapAddToSelf(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapSubtract(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapSubtractToSelf(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapMultiply(T d) {
            FieldElement[] out = this.buildArray(this.data.length);
            for (int i = 0; i < this.data.length; ++i) {
                out[i] = (FieldElement)this.data[i].multiply(d);
            }
            return new FieldVectorTestImpl(out);
        }

        public FieldVector<T> mapMultiplyToSelf(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapDivide(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapDivideToSelf(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> mapInv() {
            throw this.unsupported();
        }

        public FieldVector<T> mapInvToSelf() {
            throw this.unsupported();
        }

        public FieldVector<T> ebeMultiply(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldVector<T> ebeMultiply(T[] v) {
            throw this.unsupported();
        }

        public FieldVector<T> ebeDivide(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldVector<T> ebeDivide(T[] v) {
            throw this.unsupported();
        }

        public T[] getData() {
            return (FieldElement[])this.data.clone();
        }

        public T dotProduct(FieldVector<T> v) {
            FieldElement dot = (FieldElement)this.field.getZero();
            for (int i = 0; i < this.data.length; ++i) {
                dot = (FieldElement)dot.add(this.data[i].multiply((Object)v.getEntry(i)));
            }
            return (T)dot;
        }

        public T dotProduct(T[] v) {
            FieldElement dot = (FieldElement)this.field.getZero();
            for (int i = 0; i < this.data.length; ++i) {
                dot = (FieldElement)dot.add(this.data[i].multiply(v[i]));
            }
            return (T)dot;
        }

        public FieldVector<T> projection(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldVector<T> projection(T[] v) {
            throw this.unsupported();
        }

        public FieldMatrix<T> outerProduct(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldMatrix<T> outerProduct(T[] v) {
            throw this.unsupported();
        }

        public T getEntry(int index) {
            return this.data[index];
        }

        public int getDimension() {
            return this.data.length;
        }

        public FieldVector<T> append(FieldVector<T> v) {
            throw this.unsupported();
        }

        public FieldVector<T> append(T d) {
            throw this.unsupported();
        }

        public FieldVector<T> append(T[] a) {
            throw this.unsupported();
        }

        public FieldVector<T> getSubVector(int index, int n) {
            throw this.unsupported();
        }

        public void setEntry(int index, T value) {
            throw this.unsupported();
        }

        public void setSubVector(int index, FieldVector<T> v) {
            throw this.unsupported();
        }

        public void setSubVector(int index, T[] v) {
            throw this.unsupported();
        }

        public void set(T value) {
            throw this.unsupported();
        }

        public T[] toArray() {
            return (FieldElement[])this.data.clone();
        }
    }
}

