/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.geometry.Point;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.enclosing.EnclosingBall;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.SphereGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.UnitSphereRandomVectorGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well1024a;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SphereGeneratorTest {
    @Test
    public void testSupport0Point() {
        List<Vector3D> support = Arrays.asList(new Vector3D[0]);
        EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
        Assert.assertTrue((sphere.getRadius() < 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)sphere.getSupportSize());
        Assert.assertEquals((long)0L, (long)((Vector3D[])sphere.getSupport()).length);
    }

    @Test
    public void testSupport1Point() {
        List<Vector3D> support = Arrays.asList(new Vector3D(1.0, 2.0, 3.0));
        EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
        Assert.assertEquals((double)0.0, (double)sphere.getRadius(), (double)1.0E-10);
        Assert.assertTrue((boolean)sphere.contains((Point)support.get(0)));
        Assert.assertTrue((boolean)sphere.contains((Point)support.get(0), 0.5));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(support.get(0).getX() + 0.1, support.get(0).getY() + 0.1, support.get(0).getZ() + 0.1), 0.001));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(support.get(0).getX() + 0.1, support.get(0).getY() + 0.1, support.get(0).getZ() + 0.1), 0.5));
        Assert.assertEquals((double)0.0, (double)support.get(0).distance((Vector)sphere.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)sphere.getSupportSize());
        Assert.assertTrue((support.get(0) == ((Vector3D[])sphere.getSupport())[0] ? 1 : 0) != 0);
    }

    @Test
    public void testSupport2Points() {
        List<Vector3D> support = Arrays.asList(new Vector3D(1.0, 0.0, 0.0), new Vector3D(3.0, 0.0, 0.0));
        EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
        Assert.assertEquals((double)1.0, (double)sphere.getRadius(), (double)1.0E-10);
        int i = 0;
        for (Vector3D v : support) {
            Assert.assertTrue((boolean)sphere.contains((Point)v));
            Assert.assertEquals((double)1.0, (double)v.distance((Vector)sphere.getCenter()), (double)1.0E-10);
            Assert.assertTrue((v == ((Vector3D[])sphere.getSupport())[i++] ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, 0.9, 0.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)Vector3D.ZERO));
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 0.0, 0.0).distance((Vector)sphere.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)2L, (long)sphere.getSupportSize());
    }

    @Test
    public void testSupport3Points() {
        List<Vector3D> support = Arrays.asList(new Vector3D(1.0, 0.0, 0.0), new Vector3D(3.0, 0.0, 0.0), new Vector3D(2.0, 2.0, 0.0));
        EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
        Assert.assertEquals((double)1.25, (double)sphere.getRadius(), (double)1.0E-10);
        int i = 0;
        for (Vector3D v : support) {
            Assert.assertTrue((boolean)sphere.contains((Point)v));
            Assert.assertEquals((double)1.25, (double)v.distance((Vector)sphere.getCenter()), (double)1.0E-10);
            Assert.assertTrue((v == ((Vector3D[])sphere.getSupport())[i++] ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, 0.9, 0.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(0.9, 0.0, 0.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(3.1, 0.0, 0.0)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, -0.499, 0.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(2.0, -0.501, 0.0)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, 0.75, -1.249)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(2.0, 0.75, -1.251)));
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 0.75, 0.0).distance((Vector)sphere.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)3L, (long)sphere.getSupportSize());
    }

    @Test
    public void testSupport4Points() {
        List<Vector3D> support = Arrays.asList(new Vector3D(17.0, 14.0, 18.0), new Vector3D(11.0, 14.0, 22.0), new Vector3D(2.0, 22.0, 17.0), new Vector3D(22.0, 11.0, -10.0));
        EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
        Assert.assertEquals((double)25.0, (double)sphere.getRadius(), (double)1.0E-10);
        int i = 0;
        for (Vector3D v : support) {
            Assert.assertTrue((boolean)sphere.contains((Point)v));
            Assert.assertEquals((double)25.0, (double)v.distance((Vector)sphere.getCenter()), (double)1.0E-10);
            Assert.assertTrue((v == ((Vector3D[])sphere.getSupport())[i++] ? 1 : 0) != 0);
        }
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(-22.999, 2.0, 2.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(-23.001, 2.0, 2.0)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(26.999, 2.0, 2.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(27.001, 2.0, 2.0)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, -22.999, 2.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(2.0, -23.001, 2.0)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, 26.999, 2.0)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(2.0, 27.001, 2.0)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, 2.0, -22.999)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(2.0, 2.0, -23.001)));
        Assert.assertTrue((boolean)sphere.contains((Point)new Vector3D(2.0, 2.0, 26.999)));
        Assert.assertFalse((boolean)sphere.contains((Point)new Vector3D(2.0, 2.0, 27.001)));
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 2.0, 2.0).distance((Vector)sphere.getCenter()), (double)1.0E-10);
        Assert.assertEquals((long)4L, (long)sphere.getSupportSize());
    }

    @Test
    public void testRandom() {
        Well1024a random = new Well1024a(-3452686213302850044L);
        UnitSphereRandomVectorGenerator sr = new UnitSphereRandomVectorGenerator(3, (RandomGenerator)random);
        for (int i = 0; i < 100; ++i) {
            double d = 25.0 * random.nextDouble();
            double refRadius = 10.0 * random.nextDouble();
            Vector3D refCenter = new Vector3D(d, new Vector3D(sr.nextVector()));
            ArrayList<Vector3D> support = new ArrayList<Vector3D>();
            for (int j = 0; j < 5; ++j) {
                support.add(new Vector3D(1.0, refCenter, refRadius, new Vector3D(sr.nextVector())));
            }
            EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
            Assert.assertEquals((double)0.0, (double)refCenter.distance((Vector)sphere.getCenter()), (double)(4.0E-7 * refRadius));
            Assert.assertEquals((double)refRadius, (double)sphere.getRadius(), (double)(1.0E-7 * refRadius));
        }
    }

    @Test
    public void testDegeneratedCase() {
        List<Vector3D> support = Arrays.asList(new Vector3D(FastMath.scalb((double)-8.039905610797991E15, (int)-50), FastMath.scalb((double)-4.663475464714142E15, (int)-48), FastMath.scalb((double)6.592658872616184E15, (int)-49)), new Vector3D(FastMath.scalb((double)-8.036658568968473E15, (int)-50), FastMath.scalb((double)-4.66425634642488E15, (int)-48), FastMath.scalb((double)6.591357011730307E15, (int)-49)), new Vector3D(FastMath.scalb((double)-8.03782014297723E15, (int)-50), FastMath.scalb((double)-4.665280434237813E15, (int)-48), FastMath.scalb((double)6.592435966112099E15, (int)-49)), new Vector3D(FastMath.scalb((double)-8.038007803611611E15, (int)-50), FastMath.scalb((double)-4.66429121591838E15, (int)-48), FastMath.scalb((double)6.595270610894208E15, (int)-49)));
        EnclosingBall sphere = new SphereGenerator().ballOnSupport(support);
        Assert.assertEquals((double)0.003616820213530053, (double)sphere.getRadius(), (double)1.0E-20);
        Assert.assertEquals((double)-7.139325643360503, (double)((Vector3D)sphere.getCenter()).getX(), (double)1.0E-20);
        Assert.assertEquals((double)-16.571096474251746, (double)((Vector3D)sphere.getCenter()).getY(), (double)1.0E-20);
        Assert.assertEquals((double)11.711945804096962, (double)((Vector3D)sphere.getCenter()).getZ(), (double)1.0E-20);
        for (Vector3D v : support) {
            Assert.assertTrue((boolean)sphere.contains((Point)v, 1.0E-14));
        }
    }
}

