/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.filter;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.NormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.filter.DefaultMeasurementModel;
import com.hazelcast.shaded.org.apache.commons.math3.filter.DefaultProcessModel;
import com.hazelcast.shaded.org.apache.commons.math3.filter.KalmanFilter;
import com.hazelcast.shaded.org.apache.commons.math3.filter.MeasurementModel;
import com.hazelcast.shaded.org.apache.commons.math3.filter.ProcessModel;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixUtils;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.random.JDKRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class KalmanFilterTest {
    @Test(expected=MatrixDimensionMismatchException.class)
    public void testTransitionMeasurementMatrixMismatch() {
        Array2DRowRealMatrix A2 = new Array2DRowRealMatrix(new double[]{1.0});
        RealMatrix B2 = null;
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(new double[]{1.0, 1.0});
        Array2DRowRealMatrix Q = new Array2DRowRealMatrix(new double[]{0.0});
        Array2DRowRealMatrix R = new Array2DRowRealMatrix(new double[]{0.0});
        DefaultProcessModel pm = new DefaultProcessModel((RealMatrix)A2, B2, (RealMatrix)Q, (RealVector)new ArrayRealVector(new double[]{0.0}), null);
        DefaultMeasurementModel mm = new DefaultMeasurementModel((RealMatrix)H, (RealMatrix)R);
        new KalmanFilter((ProcessModel)pm, (MeasurementModel)mm);
        Assert.fail((String)"transition and measurement matrix should not be compatible");
    }

    @Test(expected=MatrixDimensionMismatchException.class)
    public void testTransitionControlMatrixMismatch() {
        Array2DRowRealMatrix A2 = new Array2DRowRealMatrix(new double[]{1.0});
        Array2DRowRealMatrix B2 = new Array2DRowRealMatrix(new double[]{1.0, 1.0});
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(new double[]{1.0});
        Array2DRowRealMatrix Q = new Array2DRowRealMatrix(new double[]{0.0});
        Array2DRowRealMatrix R = new Array2DRowRealMatrix(new double[]{0.0});
        DefaultProcessModel pm = new DefaultProcessModel((RealMatrix)A2, (RealMatrix)B2, (RealMatrix)Q, (RealVector)new ArrayRealVector(new double[]{0.0}), null);
        DefaultMeasurementModel mm = new DefaultMeasurementModel((RealMatrix)H, (RealMatrix)R);
        new KalmanFilter((ProcessModel)pm, (MeasurementModel)mm);
        Assert.fail((String)"transition and control matrix should not be compatible");
    }

    @Test
    public void testConstant() {
        double constantValue = 10.0;
        double measurementNoise = 0.1;
        double processNoise = 1.0E-5;
        Array2DRowRealMatrix A2 = new Array2DRowRealMatrix(new double[]{1.0});
        RealMatrix B2 = null;
        Array2DRowRealMatrix H = new Array2DRowRealMatrix(new double[]{1.0});
        ArrayRealVector x = new ArrayRealVector(new double[]{constantValue});
        Array2DRowRealMatrix Q = new Array2DRowRealMatrix(new double[]{processNoise});
        Array2DRowRealMatrix R = new Array2DRowRealMatrix(new double[]{measurementNoise});
        DefaultProcessModel pm = new DefaultProcessModel((RealMatrix)A2, B2, (RealMatrix)Q, (RealVector)new ArrayRealVector(new double[]{constantValue}), null);
        DefaultMeasurementModel mm = new DefaultMeasurementModel((RealMatrix)H, (RealMatrix)R);
        KalmanFilter filter = new KalmanFilter((ProcessModel)pm, (MeasurementModel)mm);
        Assert.assertEquals((long)1L, (long)filter.getMeasurementDimension());
        Assert.assertEquals((long)1L, (long)filter.getStateDimension());
        this.assertMatrixEquals(Q.getData(), filter.getErrorCovariance());
        double[] expectedInitialState = new double[]{constantValue};
        this.assertVectorEquals(expectedInitialState, filter.getStateEstimation());
        ArrayRealVector pNoise = new ArrayRealVector(1);
        ArrayRealVector mNoise = new ArrayRealVector(1);
        JDKRandomGenerator rand = new JDKRandomGenerator();
        for (int i = 0; i < 60; ++i) {
            filter.predict();
            pNoise.setEntry(0, processNoise * rand.nextGaussian());
            x = A2.operate((RealVector)x).add((RealVector)pNoise);
            mNoise.setEntry(0, measurementNoise * rand.nextGaussian());
            RealVector z = H.operate((RealVector)x).add((RealVector)mNoise);
            filter.correct(z);
            double diff = FastMath.abs((double)(constantValue - filter.getStateEstimation()[0]));
            Assert.assertTrue((Precision.compareTo((double)diff, (double)measurementNoise, (double)1.0E-6) < 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((Precision.compareTo((double)filter.getErrorCovariance()[0][0], (double)0.02, (double)1.0E-6) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testConstantAcceleration() {
        double dt = 0.1;
        double measurementNoise = 10.0;
        double accelNoise = 0.2;
        Array2DRowRealMatrix A2 = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, dt}, {0.0, 1.0}});
        Array2DRowRealMatrix B2 = new Array2DRowRealMatrix((double[][])new double[][]{{FastMath.pow((double)dt, (double)2.0) / 2.0}, {dt}});
        Array2DRowRealMatrix H = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 0.0}});
        ArrayRealVector x = new ArrayRealVector(new double[]{0.0, 0.0});
        Array2DRowRealMatrix tmp = new Array2DRowRealMatrix((double[][])new double[][]{{FastMath.pow((double)dt, (double)4.0) / 4.0, FastMath.pow((double)dt, (double)3.0) / 2.0}, {FastMath.pow((double)dt, (double)3.0) / 2.0, FastMath.pow((double)dt, (double)2.0)}});
        RealMatrix Q = tmp.scalarMultiply(FastMath.pow((double)accelNoise, (int)2));
        Array2DRowRealMatrix P0 = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 1.0}, {1.0, 1.0}});
        Array2DRowRealMatrix R = new Array2DRowRealMatrix(new double[]{FastMath.pow((double)measurementNoise, (int)2)});
        ArrayRealVector u = new ArrayRealVector(new double[]{0.1});
        DefaultProcessModel pm = new DefaultProcessModel((RealMatrix)A2, (RealMatrix)B2, Q, (RealVector)x, (RealMatrix)P0);
        DefaultMeasurementModel mm = new DefaultMeasurementModel((RealMatrix)H, (RealMatrix)R);
        KalmanFilter filter = new KalmanFilter((ProcessModel)pm, (MeasurementModel)mm);
        Assert.assertEquals((long)1L, (long)filter.getMeasurementDimension());
        Assert.assertEquals((long)2L, (long)filter.getStateDimension());
        this.assertMatrixEquals(P0.getData(), filter.getErrorCovariance());
        double[] expectedInitialState = new double[]{0.0, 0.0};
        this.assertVectorEquals(expectedInitialState, filter.getStateEstimation());
        JDKRandomGenerator rand = new JDKRandomGenerator();
        ArrayRealVector tmpPNoise = new ArrayRealVector(new double[]{FastMath.pow((double)dt, (double)2.0) / 2.0, dt});
        for (int i = 0; i < 60; ++i) {
            filter.predict((RealVector)u);
            RealVector pNoise = tmpPNoise.mapMultiply(accelNoise * rand.nextGaussian());
            x = A2.operate((RealVector)x).add(B2.operate((RealVector)u)).add(pNoise);
            double mNoise = measurementNoise * rand.nextGaussian();
            RealVector z = H.operate((RealVector)x).mapAdd(mNoise);
            filter.correct(z);
            double diff = FastMath.abs((double)(x.getEntry(0) - filter.getStateEstimation()[0]));
            Assert.assertTrue((Precision.compareTo((double)diff, (double)measurementNoise, (double)1.0E-6) < 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((Precision.compareTo((double)filter.getErrorCovariance()[1][1], (double)0.1, (double)1.0E-6) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCannonball() {
        int iterations = 144;
        double dt = 0.1;
        double measurementNoise = 30.0;
        double initialVelocity = 100.0;
        double angle = 45.0;
        Cannonball cannonball = new Cannonball(0.1, 45.0, 100.0);
        double speedX = cannonball.getXVelocity();
        double speedY = cannonball.getYVelocity();
        RealMatrix A2 = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.1, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.1}, {0.0, 0.0, 0.0, 1.0}});
        RealVector controlVector = MatrixUtils.createRealVector((double[])new double[]{0.0, 0.0, -0.04905000000000001, -0.9810000000000001});
        RealMatrix B2 = MatrixUtils.createRealMatrix((double[][])new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}});
        RealMatrix H = MatrixUtils.createRealMatrix((double[][])new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 0.0}});
        RealVector initialState = MatrixUtils.createRealVector((double[])new double[]{0.0, speedX, 0.0, speedY});
        double var = 900.0;
        RealMatrix initialErrorCovariance = MatrixUtils.createRealMatrix((double[][])new double[][]{{900.0, 0.0, 0.0, 0.0}, {0.0, 0.001, 0.0, 0.0}, {0.0, 0.0, 900.0, 0.0}, {0.0, 0.0, 0.0, 0.001}});
        RealMatrix Q = MatrixUtils.createRealMatrix((int)4, (int)4);
        RealMatrix R = MatrixUtils.createRealMatrix((double[][])new double[][]{{900.0, 0.0, 0.0, 0.0}, {0.0, 0.001, 0.0, 0.0}, {0.0, 0.0, 900.0, 0.0}, {0.0, 0.0, 0.0, 0.001}});
        DefaultProcessModel pm = new DefaultProcessModel(A2, B2, Q, initialState, initialErrorCovariance);
        DefaultMeasurementModel mm = new DefaultMeasurementModel(H, R);
        KalmanFilter filter = new KalmanFilter((ProcessModel)pm, (MeasurementModel)mm);
        Well19937c rng = new Well19937c(1000);
        NormalDistribution dist = new NormalDistribution((RandomGenerator)rng, 0.0, 30.0);
        for (int i = 0; i < 144; ++i) {
            double x = cannonball.getX();
            double y = cannonball.getY();
            double nx = x + dist.sample();
            double ny = y + dist.sample();
            cannonball.step();
            filter.predict(controlVector);
            filter.correct(new double[]{nx, 0.0, ny, 0.0});
            double diff = FastMath.abs((double)(cannonball.getY() - filter.getStateEstimation()[2]));
            Assert.assertTrue((Precision.compareTo((double)diff, (double)30.0, (double)1.0E-6) < 0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((Precision.compareTo((double)filter.getErrorCovariance()[0][0], (double)9.0, (double)1.0E-6) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((Precision.compareTo((double)filter.getErrorCovariance()[2][2], (double)9.0, (double)1.0E-6) < 0 ? 1 : 0) != 0);
    }

    private void assertVectorEquals(double[] expected, double[] result) {
        Assert.assertEquals((String)"Wrong number of rows.", (long)expected.length, (long)result.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)("Wrong value at position [" + i + "]"), (double)expected[i], (double)result[i], (double)1.0E-6);
        }
    }

    private void assertMatrixEquals(double[][] expected, double[][] result) {
        Assert.assertEquals((String)"Wrong number of rows.", (long)expected.length, (long)result.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((String)"Wrong number of columns.", (long)expected[i].length, (long)result[i].length);
            for (int j = 0; j < expected[i].length; ++j) {
                Assert.assertEquals((String)("Wrong value at position [" + i + "," + j + "]"), (double)expected[i][j], (double)result[i][j], (double)1.0E-6);
            }
        }
    }

    public static class Cannonball {
        private final double[] gravity = new double[]{0.0, -9.81};
        private final double[] velocity;
        private final double[] location;
        private double timeslice;

        public Cannonball(double timeslice, double angle, double initialVelocity) {
            this.timeslice = timeslice;
            double angleInRadians = FastMath.toRadians((double)angle);
            this.velocity = new double[]{initialVelocity * FastMath.cos((double)angleInRadians), initialVelocity * FastMath.sin((double)angleInRadians)};
            this.location = new double[]{0.0, 0.0};
        }

        public double getX() {
            return this.location[0];
        }

        public double getY() {
            return this.location[1];
        }

        public double getXVelocity() {
            return this.velocity[0];
        }

        public double getYVelocity() {
            return this.velocity[1];
        }

        public void step() {
            double[] slicedGravity = (double[])this.gravity.clone();
            int i = 0;
            while (i < slicedGravity.length) {
                int n = i++;
                slicedGravity[n] = slicedGravity[n] * this.timeslice;
            }
            double[] slicedVelocity = (double[])this.velocity.clone();
            for (int i2 = 0; i2 < this.velocity.length; ++i2) {
                int n = i2;
                this.velocity[n] = this.velocity[n] + slicedGravity[i2];
                slicedVelocity[i2] = this.velocity[i2] * this.timeslice;
                int n2 = i2;
                this.location[n2] = this.location[n2] + slicedVelocity[i2];
            }
            if (this.location[1] < 0.0) {
                this.location[1] = 0.0;
            }
        }
    }
}

