/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.GammaDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.special.Gamma;
import com.hazelcast.shaded.org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.junit.Assert;
import org.junit.Test;

public class GammaDistributionTest
extends RealDistributionAbstractTest {
    private static final double HALF_LOG_2_PI = 0.5 * FastMath.log((double)(Math.PI * 2));

    public GammaDistribution makeDistribution() {
        return new GammaDistribution(4.0, 2.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{0.857104827257, 1.64649737269, 2.17973074725, 2.7326367935, 3.48953912565, 26.1244815584, 20.0902350297, 17.5345461395, 15.5073130559, 13.3615661365};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.00427280075546, 0.0204117166709, 0.0362756163658, 0.0542113174239, 0.0773195272491, 3.94468852816E-4, 0.00366559696761, 0.00874649473311, 0.0166712508128, 0.0311798227954};
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    @Test
    public void testParameterAccessors() {
        GammaDistribution distribution = (GammaDistribution)this.getDistribution();
        Assert.assertEquals((double)4.0, (double)distribution.getAlpha(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)distribution.getBeta(), (double)0.0);
    }

    @Test
    public void testPreconditions() {
        try {
            new GammaDistribution(0.0, 1.0);
            Assert.fail((String)"Expecting NotStrictlyPositiveException for alpha = 0");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            new GammaDistribution(1.0, 0.0);
            Assert.fail((String)"Expecting NotStrictlyPositiveException for alpha = 0");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testProbabilities() {
        this.testProbability(-1.0, 4.0, 2.0, 0.0);
        this.testProbability(15.501, 4.0, 2.0, 0.9499);
        this.testProbability(0.504, 4.0, 1.0, 0.0018);
        this.testProbability(10.011, 1.0, 2.0, 0.9933);
        this.testProbability(5.0, 2.0, 2.0, 0.7127);
    }

    @Test
    public void testValues() {
        this.testValue(15.501, 4.0, 2.0, 0.9499);
        this.testValue(0.504, 4.0, 1.0, 0.0018);
        this.testValue(10.011, 1.0, 2.0, 0.9933);
        this.testValue(5.0, 2.0, 2.0, 0.7127);
    }

    private void testProbability(double x, double a, double b, double expected) {
        GammaDistribution distribution = new GammaDistribution(a, b);
        double actual = distribution.cumulativeProbability(x);
        Assert.assertEquals((String)("probability for " + x), (double)expected, (double)actual, (double)0.001);
    }

    private void testValue(double expected, double a, double b, double p) {
        GammaDistribution distribution = new GammaDistribution(a, b);
        double actual = distribution.inverseCumulativeProbability(p);
        Assert.assertEquals((String)("critical value for " + p), (double)expected, (double)actual, (double)0.001);
    }

    @Test
    public void testDensity() {
        double[] x = new double[]{-0.1, 1.0E-6, 0.5, 1.0, 2.0, 5.0};
        this.checkDensity(1.0, 1.0, x, new double[]{0.0, 0.999999000001, 0.606530659713, 0.367879441171, 0.135335283237, 0.006737946999});
        this.checkDensity(2.0, 1.0, x, new double[]{0.0, 9.99999E-7, 0.303265329856, 0.367879441171, 0.270670566473, 0.033689734995});
        this.checkDensity(4.0, 1.0, x, new double[]{0.0, 1.666665E-19, 0.01263605541, 0.0613132402, 0.1804470443, 0.1403738958});
        this.checkDensity(4.0, 10.0, x, new double[]{0.0, 1.66665E-15, 1.403738958, 0.0756665496, 2.74820483E-5, 4.01822885E-17});
        this.checkDensity(0.1, 10.0, x, new double[]{0.0, 33239.53832, 0.00166384901, 6.007786726E-6, 1.461647647E-10, 5.996008322E-24});
        this.checkDensity(0.1, 20.0, x, new double[]{0.0, 35624.89883, 1.201557345E-5, 2.923295295E-10, 3.228910843E-19, 1.239484589E-45});
        this.checkDensity(0.1, 4.0, x, new double[]{0.0, 30329.38388, 0.03049322494, 0.002211502311, 2.170613371E-5, 5.846590589E-11});
        this.checkDensity(0.1, 1.0, x, new double[]{0.0, 26403.34143, 0.1189704437, 0.03866916944, 0.007623306235, 1.66384901E-4});
    }

    private void checkDensity(double alpha, double rate, double[] x, double[] expected) {
        GammaDistribution d = new GammaDistribution(alpha, 1.0 / rate);
        for (int i = 0; i < x.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)d.density(x[i]), (double)1.0E-5);
        }
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{0.0, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        GammaDistribution dist = new GammaDistribution(1.0, 2.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)2.0, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)4.0, (double)1.0E-9);
        dist = new GammaDistribution(1.1, 4.2);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)4.620000000000001, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)19.404000000000003, (double)1.0E-9);
    }

    public static double logGamma(double x) {
        double ret;
        if (Double.isNaN(x) || x <= 0.0) {
            ret = Double.NaN;
        } else {
            double sum = Gamma.lanczos((double)x);
            double tmp = x + 4.7421875 + 0.5;
            ret = (x + 0.5) * FastMath.log((double)tmp) - tmp + HALF_LOG_2_PI + FastMath.log((double)(sum / x));
        }
        return ret;
    }

    public static double density(double x, double shape, double scale) {
        if (x < 0.0) {
            return 0.0;
        }
        return FastMath.pow((double)(x / scale), (double)(shape - 1.0)) / scale * FastMath.exp((double)(-x / scale)) / FastMath.exp((double)GammaDistributionTest.logGamma(shape));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestMath753(double shape, double meanNoOF, double sdNoOF, double meanOF, double sdOF, String resourceName) throws IOException {
        GammaDistribution distribution = new GammaDistribution(shape, 1.0);
        SummaryStatistics statOld = new SummaryStatistics();
        SummaryStatistics statNewNoOF = new SummaryStatistics();
        SummaryStatistics statNewOF = new SummaryStatistics();
        InputStream resourceAsStream = this.getClass().getResourceAsStream(resourceName);
        Assert.assertNotNull((String)("Could not find resource " + resourceName), (Object)resourceAsStream);
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream));
        try {
            String line = in.readLine();
            while (line != null) {
                if (!line.startsWith("#")) {
                    String[] tokens = line.split(", ");
                    Assert.assertTrue((String)"expected two floating-point values", (tokens.length == 2 ? 1 : 0) != 0);
                    double x = Double.parseDouble(tokens[0]);
                    String msg = "x = " + x + ", shape = " + shape + ", scale = 1.0";
                    double expected = Double.parseDouble(tokens[1]);
                    double ulp = FastMath.ulp((double)expected);
                    double actualOld = GammaDistributionTest.density(x, shape, 1.0);
                    double actualNew = distribution.density(x);
                    double errOld = FastMath.abs((double)((actualOld - expected) / ulp));
                    double errNew = FastMath.abs((double)((actualNew - expected) / ulp));
                    if (Double.isNaN(actualOld) || Double.isInfinite(actualOld)) {
                        Assert.assertFalse((String)msg, (boolean)Double.isNaN(actualNew));
                        Assert.assertFalse((String)msg, (boolean)Double.isInfinite(actualNew));
                        statNewOF.addValue(errNew);
                    } else {
                        statOld.addValue(errOld);
                        statNewNoOF.addValue(errNew);
                    }
                }
                line = in.readLine();
            }
            if (statOld.getN() != 0L) {
                StringBuilder sb = new StringBuilder("shape = ");
                sb.append(shape);
                sb.append(", scale = 1.0\n");
                sb.append("Old implementation\n");
                sb.append("------------------\n");
                sb.append(statOld.toString());
                sb.append("New implementation\n");
                sb.append("------------------\n");
                sb.append(statNewNoOF.toString());
                String msg = sb.toString();
                double oldMin = statOld.getMin();
                double newMin = statNewNoOF.getMin();
                Assert.assertTrue((String)msg, (newMin <= oldMin ? 1 : 0) != 0);
                double oldMax = statOld.getMax();
                double newMax = statNewNoOF.getMax();
                Assert.assertTrue((String)msg, (newMax <= oldMax ? 1 : 0) != 0);
                double oldMean = statOld.getMean();
                double newMean = statNewNoOF.getMean();
                Assert.assertTrue((String)msg, (newMean <= oldMean ? 1 : 0) != 0);
                double oldSd = statOld.getStandardDeviation();
                double newSd = statNewNoOF.getStandardDeviation();
                Assert.assertTrue((String)msg, (newSd <= oldSd ? 1 : 0) != 0);
                Assert.assertTrue((String)msg, (newMean <= meanNoOF ? 1 : 0) != 0);
                Assert.assertTrue((String)msg, (newSd <= sdNoOF ? 1 : 0) != 0);
            }
            if (statNewOF.getN() != 0L) {
                double newMean = statNewOF.getMean();
                double newSd = statNewOF.getStandardDeviation();
                StringBuilder sb = new StringBuilder("shape = ");
                sb.append(shape);
                sb.append(", scale = 1.0");
                sb.append(", max. mean error (ulps) = ");
                sb.append(meanOF);
                sb.append(", actual mean error (ulps) = ");
                sb.append(newMean);
                sb.append(", max. sd of error (ulps) = ");
                sb.append(sdOF);
                sb.append(", actual sd of error (ulps) = ");
                sb.append(newSd);
                String msg = sb.toString();
                Assert.assertTrue((String)msg, (newMean <= meanOF ? 1 : 0) != 0);
                Assert.assertTrue((String)msg, (newSd <= sdOF ? 1 : 0) != 0);
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testMath753Shape1() throws IOException {
        this.doTestMath753(1.0, 1.5, 0.5, 0.0, 0.0, "gamma-distribution-shape-1.csv");
    }

    @Test
    public void testMath753Shape8() throws IOException {
        this.doTestMath753(8.0, 1.5, 1.0, 0.0, 0.0, "gamma-distribution-shape-8.csv");
    }

    @Test
    public void testMath753Shape10() throws IOException {
        this.doTestMath753(10.0, 1.0, 1.0, 0.0, 0.0, "gamma-distribution-shape-10.csv");
    }

    @Test
    public void testMath753Shape100() throws IOException {
        this.doTestMath753(100.0, 1.5, 1.0, 0.0, 0.0, "gamma-distribution-shape-100.csv");
    }

    @Test
    public void testMath753Shape142() throws IOException {
        this.doTestMath753(142.0, 3.3, 1.6, 40.0, 40.0, "gamma-distribution-shape-142.csv");
    }

    @Test
    public void testMath753Shape1000() throws IOException {
        this.doTestMath753(1000.0, 1.0, 1.0, 160.0, 220.0, "gamma-distribution-shape-1000.csv");
    }
}

