/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.FDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.junit.Assert;
import org.junit.Test;

public class FDistributionTest
extends RealDistributionAbstractTest {
    public FDistribution makeDistribution() {
        return new FDistribution(5.0, 6.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{0.0346808448626, 0.0937009113303, 0.143313661184, 0.202008445998, 0.293728320107, 20.8026639595, 8.74589525602, 5.98756512605, 4.38737418741, 3.10751166664};
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.001, 0.01, 0.025, 0.05, 0.1, 0.999, 0.99, 0.975, 0.95, 0.9};
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0689156576706, 0.236735653193, 0.364074131941, 0.481570789649, 0.595880479994, 1.33443915657E-4, 0.00286681303403, 0.00969192007502, 0.0242883861471, 0.0605491314658};
    }

    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    @Test
    public void testCumulativeProbabilityExtremes() {
        this.setCumulativeTestPoints(new double[]{-2.0, 0.0});
        this.setCumulativeTestValues(new double[]{0.0, 0.0});
        this.verifyCumulativeProbabilities();
    }

    @Test
    public void testInverseCumulativeProbabilityExtremes() {
        this.setInverseCumulativeTestPoints(new double[]{0.0, 1.0});
        this.setInverseCumulativeTestValues(new double[]{0.0, Double.POSITIVE_INFINITY});
        this.verifyInverseCumulativeProbabilities();
    }

    @Test
    public void testDfAccessors() {
        FDistribution dist = (FDistribution)this.getDistribution();
        Assert.assertEquals((double)5.0, (double)dist.getNumeratorDegreesOfFreedom(), (double)Double.MIN_VALUE);
        Assert.assertEquals((double)6.0, (double)dist.getDenominatorDegreesOfFreedom(), (double)Double.MIN_VALUE);
    }

    @Test
    public void testPreconditions() {
        try {
            new FDistribution(0.0, 1.0);
            Assert.fail((String)"Expecting NotStrictlyPositiveException for df = 0");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
        try {
            new FDistribution(1.0, 0.0);
            Assert.fail((String)"Expecting NotStrictlyPositiveException for df = 0");
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            // empty catch block
        }
    }

    @Test
    public void testLargeDegreesOfFreedom() {
        FDistribution fd = new FDistribution(100000.0, 100000.0);
        double p = fd.cumulativeProbability(0.999);
        double x = fd.inverseCumulativeProbability(p);
        Assert.assertEquals((double)0.999, (double)x, (double)1.0E-5);
    }

    @Test
    public void testSmallDegreesOfFreedom() {
        FDistribution fd = new FDistribution(1.0, 1.0);
        double p = fd.cumulativeProbability(0.975);
        double x = fd.inverseCumulativeProbability(p);
        Assert.assertEquals((double)0.975, (double)x, (double)1.0E-5);
        fd = new FDistribution(1.0, 2.0);
        p = fd.cumulativeProbability(0.975);
        x = fd.inverseCumulativeProbability(p);
        Assert.assertEquals((double)0.975, (double)x, (double)1.0E-5);
    }

    @Test
    public void testMoments() {
        double tol = 1.0E-9;
        FDistribution dist = new FDistribution(1.0, 2.0);
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalMean()));
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalVariance()));
        dist = new FDistribution(1.0, 3.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)3.0, (double)1.0E-9);
        Assert.assertTrue((boolean)Double.isNaN(dist.getNumericalVariance()));
        dist = new FDistribution(1.0, 5.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)1.6666666666666667, (double)1.0E-9);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)22.22222222222222, (double)1.0E-9);
    }

    @Test
    public void testMath785() {
        try {
            double prob = 0.01;
            FDistribution f = new FDistribution(200000.0, 200000.0);
            double result = f.inverseCumulativeProbability(prob);
            Assert.assertTrue((result < 1.0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)"Failing to calculate inverse cumulative probability");
        }
    }
}

