/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.QuinticFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.XMinus5Function;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sin;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.AllowedSolution;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.BracketedUnivariateSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.PegasusSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSecantSolverAbstractTest {
    protected abstract UnivariateSolver getSolver();

    protected abstract int[] getQuinticEvalCounts();

    @Test
    public void testSinZero() {
        Sin f = new Sin();
        UnivariateSolver solver = this.getSolver();
        double result = solver.solve(100, (UnivariateFunction)f, 3.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 6 ? 1 : 0) != 0);
        result = solver.solve(100, (UnivariateFunction)f, 1.0, 4.0);
        Assert.assertEquals((double)result, (double)Math.PI, (double)solver.getAbsoluteAccuracy());
        Assert.assertTrue((solver.getEvaluations() <= 7 ? 1 : 0) != 0);
    }

    @Test
    public void testQuinticZero() {
        QuinticFunction f = new QuinticFunction();
        UnivariateSolver solver = this.getSolver();
        double atol = solver.getAbsoluteAccuracy();
        int[] counts = this.getQuinticEvalCounts();
        double[][] testsData = new double[][]{{-0.2, 0.2, 0.0}, {-0.1, 0.3, 0.0}, {-0.3, 0.45, 0.0}, {0.3, 0.7, 0.5}, {0.2, 0.6, 0.5}, {0.05, 0.95, 0.5}, {0.85, 1.25, 1.0}, {0.8, 1.2, 1.0}, {0.85, 1.75, 1.0}, {0.55, 1.45, 1.0}, {0.85, 5.0, 1.0}};
        int maxIter = 500;
        for (int i = 0; i < testsData.length; ++i) {
            if (counts[i] == -1) continue;
            double[] testData = testsData[i];
            double result = solver.solve(maxIter, (UnivariateFunction)f, testData[0], testData[1]);
            Assert.assertEquals((double)result, (double)testData[2], (double)atol);
            Assert.assertTrue((solver.getEvaluations() <= counts[i] + 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRootEndpoints() {
        XMinus5Function f = new XMinus5Function();
        UnivariateSolver solver = this.getSolver();
        double result = solver.solve(100, (UnivariateFunction)f, 5.0, 6.0);
        Assert.assertEquals((double)5.0, (double)result, (double)0.0);
        result = solver.solve(100, (UnivariateFunction)f, 4.0, 5.0);
        Assert.assertEquals((double)5.0, (double)result, (double)0.0);
        result = solver.solve(100, (UnivariateFunction)f, 5.0, 6.0, 5.5);
        Assert.assertEquals((double)5.0, (double)result, (double)0.0);
        result = solver.solve(100, (UnivariateFunction)f, 4.0, 5.0, 4.5);
        Assert.assertEquals((double)5.0, (double)result, (double)0.0);
    }

    @Test
    public void testBadEndpoints() {
        Sin f = new Sin();
        UnivariateSolver solver = this.getSolver();
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, -1.0);
            Assert.fail((String)"Expecting NumberIsTooLargeException - bad interval");
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, 1.5);
            Assert.fail((String)"Expecting NoBracketingException - non-bracketing");
        }
        catch (NoBracketingException noBracketingException) {
            // empty catch block
        }
        try {
            solver.solve(100, (UnivariateFunction)f, 1.0, 1.5, 1.2);
            Assert.fail((String)"Expecting NoBracketingException - non-bracketing");
        }
        catch (NoBracketingException noBracketingException) {
            // empty catch block
        }
    }

    @Test
    public void testSolutionLeftSide() {
        Sin f = new Sin();
        UnivariateSolver solver = this.getSolver();
        double left = -1.5;
        double right = 0.05;
        for (int i = 0; i < 10; ++i) {
            double solution = this.getSolution(solver, 100, (UnivariateFunction)f, left, right, AllowedSolution.LEFT_SIDE);
            if (!Double.isNaN(solution)) {
                Assert.assertTrue((solution <= 0.0 ? 1 : 0) != 0);
            }
            left -= 0.1;
            right += 0.3;
        }
    }

    @Test
    public void testSolutionRightSide() {
        Sin f = new Sin();
        UnivariateSolver solver = this.getSolver();
        double left = -1.5;
        double right = 0.05;
        for (int i = 0; i < 10; ++i) {
            double solution = this.getSolution(solver, 100, (UnivariateFunction)f, left, right, AllowedSolution.RIGHT_SIDE);
            if (!Double.isNaN(solution)) {
                Assert.assertTrue((solution >= 0.0 ? 1 : 0) != 0);
            }
            left -= 0.1;
            right += 0.3;
        }
    }

    @Test
    public void testSolutionBelowSide() {
        Sin f = new Sin();
        UnivariateSolver solver = this.getSolver();
        double left = -1.5;
        double right = 0.05;
        for (int i = 0; i < 10; ++i) {
            double solution = this.getSolution(solver, 100, (UnivariateFunction)f, left, right, AllowedSolution.BELOW_SIDE);
            if (!Double.isNaN(solution)) {
                Assert.assertTrue((f.value(solution) <= 0.0 ? 1 : 0) != 0);
            }
            left -= 0.1;
            right += 0.3;
        }
    }

    @Test
    public void testSolutionAboveSide() {
        Sin f = new Sin();
        UnivariateSolver solver = this.getSolver();
        double left = -1.5;
        double right = 0.05;
        for (int i = 0; i < 10; ++i) {
            double solution = this.getSolution(solver, 100, (UnivariateFunction)f, left, right, AllowedSolution.ABOVE_SIDE);
            if (!Double.isNaN(solution)) {
                Assert.assertTrue((f.value(solution) >= 0.0 ? 1 : 0) != 0);
            }
            left -= 0.1;
            right += 0.3;
        }
    }

    private double getSolution(UnivariateSolver solver, int maxEval, UnivariateFunction f, double left, double right, AllowedSolution allowedSolution) {
        try {
            BracketedUnivariateSolver bracketing = (BracketedUnivariateSolver)solver;
            return bracketing.solve(100, f, left, right, allowedSolution);
        }
        catch (ClassCastException cce) {
            double baseRoot = solver.solve(maxEval, f, left, right);
            if (baseRoot <= left || baseRoot >= right) {
                return Double.NaN;
            }
            PegasusSolver bracketing = new PegasusSolver(solver.getRelativeAccuracy(), solver.getAbsoluteAccuracy(), solver.getFunctionValueAccuracy());
            return UnivariateSolverUtils.forceSide((int)(maxEval - solver.getEvaluations()), (UnivariateFunction)f, (BracketedUnivariateSolver)bracketing, (double)baseRoot, (double)left, (double)right, (AllowedSolution)allowedSolution);
        }
    }
}

