/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.junit.Assert;
import org.junit.Test;

public final class PolynomialFunctionTest {
    protected double tolerance = 1.0E-12;

    @Test
    public void testConstants() {
        double[] c = new double[]{2.5};
        PolynomialFunction f = new PolynomialFunction(c);
        Assert.assertEquals((double)f.value(0.0), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)f.value(-1.0), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)f.value(-123.5), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)f.value(3.0), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)f.value(456.89), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((long)f.degree(), (long)0L);
        Assert.assertEquals((double)f.derivative().value(0.0), (double)0.0, (double)this.tolerance);
        Assert.assertEquals((double)f.polynomialDerivative().derivative().value(0.0), (double)0.0, (double)this.tolerance);
    }

    @Test
    public void testLinear() {
        double[] c = new double[]{-1.5, 3.0};
        PolynomialFunction f = new PolynomialFunction(c);
        Assert.assertEquals((double)f.value(0.0), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)-4.5, (double)f.value(-1.0), (double)this.tolerance);
        Assert.assertEquals((double)-9.0, (double)f.value(-2.5), (double)this.tolerance);
        Assert.assertEquals((double)0.0, (double)f.value(0.5), (double)this.tolerance);
        Assert.assertEquals((double)3.0, (double)f.value(1.5), (double)this.tolerance);
        Assert.assertEquals((double)7.5, (double)f.value(3.0), (double)this.tolerance);
        Assert.assertEquals((long)f.degree(), (long)1L);
        Assert.assertEquals((double)f.polynomialDerivative().derivative().value(0.0), (double)0.0, (double)this.tolerance);
    }

    @Test
    public void testQuadratic() {
        double[] c = new double[]{-2.0, -3.0, 2.0};
        PolynomialFunction f = new PolynomialFunction(c);
        Assert.assertEquals((double)f.value(0.0), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)0.0, (double)f.value(-0.5), (double)this.tolerance);
        Assert.assertEquals((double)0.0, (double)f.value(2.0), (double)this.tolerance);
        Assert.assertEquals((double)-2.0, (double)f.value(1.5), (double)this.tolerance);
        Assert.assertEquals((double)7.0, (double)f.value(-1.5), (double)this.tolerance);
        Assert.assertEquals((double)265.5312, (double)f.value(12.34), (double)this.tolerance);
    }

    @Test
    public void testQuintic() {
        double[] c = new double[]{0.0, 0.0, 15.0, -13.0, -3.0, 1.0};
        PolynomialFunction f = new PolynomialFunction(c);
        Assert.assertEquals((double)f.value(0.0), (double)c[0], (double)this.tolerance);
        Assert.assertEquals((double)0.0, (double)f.value(5.0), (double)this.tolerance);
        Assert.assertEquals((double)0.0, (double)f.value(1.0), (double)this.tolerance);
        Assert.assertEquals((double)0.0, (double)f.value(-3.0), (double)this.tolerance);
        Assert.assertEquals((double)54.84375, (double)f.value(-1.5), (double)this.tolerance);
        Assert.assertEquals((double)-8.06637, (double)f.value(1.3), (double)this.tolerance);
        Assert.assertEquals((long)f.degree(), (long)5L);
    }

    @Test
    public void testfirstDerivativeComparison() {
        double[] f_coeff = new double[]{3.0, 6.0, -2.0, 1.0};
        double[] g_coeff = new double[]{6.0, -4.0, 3.0};
        double[] h_coeff = new double[]{-4.0, 6.0};
        PolynomialFunction f = new PolynomialFunction(f_coeff);
        PolynomialFunction g = new PolynomialFunction(g_coeff);
        PolynomialFunction h = new PolynomialFunction(h_coeff);
        Assert.assertEquals((double)f.derivative().value(0.0), (double)g.value(0.0), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(1.0), (double)g.value(1.0), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(100.0), (double)g.value(100.0), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(4.1), (double)g.value(4.1), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(-3.25), (double)g.value(-3.25), (double)this.tolerance);
        Assert.assertEquals((double)g.derivative().value(Math.PI), (double)h.value(Math.PI), (double)this.tolerance);
        Assert.assertEquals((double)g.derivative().value(Math.E), (double)h.value(Math.E), (double)this.tolerance);
    }

    @Test
    public void testString() {
        PolynomialFunction p = new PolynomialFunction(new double[]{-5.0, 3.0, 1.0});
        this.checkPolynomial(p, "-5 + 3 x + x^2");
        this.checkPolynomial(new PolynomialFunction(new double[]{0.0, -2.0, 3.0}), "-2 x + 3 x^2");
        this.checkPolynomial(new PolynomialFunction(new double[]{1.0, -2.0, 3.0}), "1 - 2 x + 3 x^2");
        this.checkPolynomial(new PolynomialFunction(new double[]{0.0, 2.0, 3.0}), "2 x + 3 x^2");
        this.checkPolynomial(new PolynomialFunction(new double[]{1.0, 2.0, 3.0}), "1 + 2 x + 3 x^2");
        this.checkPolynomial(new PolynomialFunction(new double[]{1.0, 0.0, 3.0}), "1 + 3 x^2");
        this.checkPolynomial(new PolynomialFunction(new double[]{0.0}), "0");
    }

    @Test
    public void testAddition() {
        PolynomialFunction p1 = new PolynomialFunction(new double[]{-2.0, 1.0});
        PolynomialFunction p2 = new PolynomialFunction(new double[]{2.0, -1.0, 0.0});
        this.checkNullPolynomial(p1.add(p2));
        p2 = p1.add(p1);
        this.checkPolynomial(p2, "-4 + 2 x");
        p1 = new PolynomialFunction(new double[]{1.0, -4.0, 2.0});
        p2 = new PolynomialFunction(new double[]{-1.0, 3.0, -2.0});
        p1 = p1.add(p2);
        Assert.assertEquals((long)1L, (long)p1.degree());
        this.checkPolynomial(p1, "-x");
    }

    @Test
    public void testSubtraction() {
        PolynomialFunction p1 = new PolynomialFunction(new double[]{-2.0, 1.0});
        this.checkNullPolynomial(p1.subtract(p1));
        PolynomialFunction p2 = new PolynomialFunction(new double[]{-2.0, 6.0});
        p2 = p2.subtract(p1);
        this.checkPolynomial(p2, "5 x");
        p1 = new PolynomialFunction(new double[]{1.0, -4.0, 2.0});
        p2 = new PolynomialFunction(new double[]{-1.0, 3.0, 2.0});
        p1 = p1.subtract(p2);
        Assert.assertEquals((long)1L, (long)p1.degree());
        this.checkPolynomial(p1, "2 - 7 x");
    }

    @Test
    public void testMultiplication() {
        PolynomialFunction p1 = new PolynomialFunction(new double[]{-3.0, 2.0});
        PolynomialFunction p2 = new PolynomialFunction(new double[]{3.0, 2.0, 1.0});
        this.checkPolynomial(p1.multiply(p2), "-9 + x^2 + 2 x^3");
        p2 = p1 = new PolynomialFunction(new double[]{0.0, 1.0});
        for (int i = 2; i < 10; ++i) {
            p2 = p2.multiply(p1);
            this.checkPolynomial(p2, "x^" + i);
        }
    }

    @Test
    public void testSerial() {
        PolynomialFunction p2 = new PolynomialFunction(new double[]{3.0, 2.0, 1.0});
        Assert.assertEquals((Object)p2, (Object)TestUtils.serializeAndRecover(p2));
    }

    @Test
    public void testMath341() {
        double[] f_coeff = new double[]{3.0, 6.0, -2.0, 1.0};
        double[] g_coeff = new double[]{6.0, -4.0, 3.0};
        double[] h_coeff = new double[]{-4.0, 6.0};
        PolynomialFunction f = new PolynomialFunction(f_coeff);
        PolynomialFunction g = new PolynomialFunction(g_coeff);
        PolynomialFunction h = new PolynomialFunction(h_coeff);
        Assert.assertEquals((double)f.derivative().value(0.0), (double)g.value(0.0), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(1.0), (double)g.value(1.0), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(100.0), (double)g.value(100.0), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(4.1), (double)g.value(4.1), (double)this.tolerance);
        Assert.assertEquals((double)f.derivative().value(-3.25), (double)g.value(-3.25), (double)this.tolerance);
        Assert.assertEquals((double)g.derivative().value(Math.PI), (double)h.value(Math.PI), (double)this.tolerance);
        Assert.assertEquals((double)g.derivative().value(Math.E), (double)h.value(Math.E), (double)this.tolerance);
    }

    public void checkPolynomial(PolynomialFunction p, String reference) {
        Assert.assertEquals((Object)reference, (Object)p.toString());
    }

    private void checkNullPolynomial(PolynomialFunction p) {
        for (double coefficient : p.getCoefficients()) {
            Assert.assertEquals((double)0.0, (double)coefficient, (double)1.0E-15);
        }
    }
}

