/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.polynomials.PolynomialFunctionNewtonForm;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.junit.Assert;
import org.junit.Test;

public final class PolynomialFunctionNewtonFormTest {
    @Test
    public void testLinearFunction() {
        double tolerance = 1.0E-12;
        double[] a = new double[]{2.0, 1.5};
        double[] c = new double[]{4.0};
        PolynomialFunctionNewtonForm p = new PolynomialFunctionNewtonForm(a, c);
        double z = 2.0;
        double expected = -1.0;
        double result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 4.5;
        expected = 2.75;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 6.0;
        expected = 5.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        Assert.assertEquals((long)1L, (long)p.degree());
        double[] coefficients = p.getCoefficients();
        Assert.assertEquals((long)2L, (long)coefficients.length);
        Assert.assertEquals((double)-4.0, (double)coefficients[0], (double)tolerance);
        Assert.assertEquals((double)1.5, (double)coefficients[1], (double)tolerance);
    }

    @Test
    public void testQuadraticFunction() {
        double tolerance = 1.0E-12;
        double[] a = new double[]{4.0, 3.0, 2.0};
        double[] c = new double[]{1.0, -2.0};
        PolynomialFunctionNewtonForm p = new PolynomialFunctionNewtonForm(a, c);
        double z = 1.0;
        double expected = 4.0;
        double result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 2.5;
        expected = 22.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = -2.0;
        expected = -5.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        Assert.assertEquals((long)2L, (long)p.degree());
        double[] coefficients = p.getCoefficients();
        Assert.assertEquals((long)3L, (long)coefficients.length);
        Assert.assertEquals((double)-3.0, (double)coefficients[0], (double)tolerance);
        Assert.assertEquals((double)5.0, (double)coefficients[1], (double)tolerance);
        Assert.assertEquals((double)2.0, (double)coefficients[2], (double)tolerance);
    }

    @Test
    public void testQuinticFunction() {
        double tolerance = 1.0E-12;
        double[] a = new double[]{0.0, 6.0, -6.0, -6.0, 1.0, 1.0};
        double[] c = new double[]{0.0, 0.0, 1.0, -1.0, 2.0};
        PolynomialFunctionNewtonForm p = new PolynomialFunctionNewtonForm(a, c);
        double z = 0.0;
        double expected = 0.0;
        double result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = -2.0;
        expected = 0.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        z = 4.0;
        expected = 360.0;
        result = p.value(z);
        Assert.assertEquals((double)expected, (double)result, (double)tolerance);
        Assert.assertEquals((long)5L, (long)p.degree());
        double[] coefficients = p.getCoefficients();
        Assert.assertEquals((long)6L, (long)coefficients.length);
        Assert.assertEquals((double)0.0, (double)coefficients[0], (double)tolerance);
        Assert.assertEquals((double)6.0, (double)coefficients[1], (double)tolerance);
        Assert.assertEquals((double)1.0, (double)coefficients[2], (double)tolerance);
        Assert.assertEquals((double)-7.0, (double)coefficients[3], (double)tolerance);
        Assert.assertEquals((double)-1.0, (double)coefficients[4], (double)tolerance);
        Assert.assertEquals((double)1.0, (double)coefficients[5], (double)tolerance);
    }

    @Test
    public void testDerivative() {
        PolynomialFunctionNewtonForm p = new PolynomialFunctionNewtonForm(new double[]{0.0, 1.0, 3.0, 1.0}, new double[]{0.0, 1.0, 2.0});
        double eps = 2.0E-14;
        for (double t = 0.0; t < 10.0; t += 0.1) {
            DerivativeStructure x = new DerivativeStructure(1, 4, 0, t);
            DerivativeStructure y = p.value(x);
            Assert.assertEquals((double)(t * t * t), (double)y.getValue(), (double)(eps * t * t * t));
            Assert.assertEquals((double)(3.0 * t * t), (double)y.getPartialDerivative(new int[]{1}), (double)(eps * 3.0 * t * t));
            Assert.assertEquals((double)(6.0 * t), (double)y.getPartialDerivative(new int[]{2}), (double)(eps * 6.0 * t));
            Assert.assertEquals((double)6.0, (double)y.getPartialDerivative(new int[]{3}), (double)(eps * 6.0));
            Assert.assertEquals((double)0.0, (double)y.getPartialDerivative(new int[]{4}), (double)eps);
        }
    }

    @Test
    public void testParameters() {
        double[] c;
        double[] a2;
        try {
            a2 = new double[]{1.0};
            c = new double[]{2.0};
            new PolynomialFunctionNewtonForm(a2, c);
            Assert.fail((String)"Expecting MathIllegalArgumentException - bad input array length");
        }
        catch (MathIllegalArgumentException a2) {
            // empty catch block
        }
        try {
            a2 = new double[]{1.0, 2.0, 3.0, 4.0};
            c = new double[]{4.0, 3.0, 2.0, 1.0};
            new PolynomialFunctionNewtonForm(a2, c);
            Assert.fail((String)"Expecting MathIllegalArgumentException - mismatch input arrays");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }
}

