/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.TrivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.TricubicSplineInterpolatingFunction;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public final class TricubicSplineInterpolatingFunctionTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 2.5};
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        TricubicSplineInterpolatingFunction tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, fval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            tcf = new TricubicSplineInterpolatingFunction(wxval, yval, zval, fval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -1.0, -1.0, 2.5};
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, wyval, zval, fval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wzval = new double[]{-12.0, -8.0, -9.0, -3.0, 0.0, 2.5};
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, wzval, fval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][][] wfval = new double[xval.length - 1][yval.length - 1][zval.length];
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, wfval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, wfval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, wfval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, wfval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, wfval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, wfval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, wfval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wfval = new double[xval.length][yval.length - 1][zval.length];
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, wfval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, wfval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, wfval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, wfval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, wfval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, wfval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, wfval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wfval = new double[xval.length][yval.length][zval.length - 1];
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, wfval, fval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, wfval, fval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, wfval, fval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, wfval, fval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, wfval, fval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, wfval, fval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, wfval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, fval, fval, fval, fval, fval, fval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testPlane() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 2.5};
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 2.0 * x - 3.0 * y - 4.0 * z + 5.0;
            }
        };
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    fval[i][j][k] = f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] dFdX = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    dFdX[i][j][k] = 2.0;
                }
            }
        }
        double[][][] dFdY = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    dFdY[i][j][k] = -3.0;
                }
            }
        }
        double[][][] dFdZ = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    dFdZ[i][j][k] = -4.0;
                }
            }
        }
        double[][][] d2FdXdY = new double[xval.length][yval.length][zval.length];
        double[][][] d2FdXdZ = new double[xval.length][yval.length][zval.length];
        double[][][] d2FdYdZ = new double[xval.length][yval.length][zval.length];
        double[][][] d3FdXdYdZ = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    d2FdXdY[i][j][k] = 0.0;
                    d2FdXdZ[i][j][k] = 0.0;
                    d2FdYdZ[i][j][k] = 0.0;
                    d3FdXdYdZ[i][j][k] = 0.0;
                }
            }
        }
        TricubicSplineInterpolatingFunction tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, dFdX, dFdY, dFdZ, d2FdXdY, d2FdXdZ, d2FdYdZ, d3FdXdYdZ);
        double x = 4.0;
        double y = -3.0;
        double z = 0.0;
        double expected = f.value(x, y, z);
        double result = tcf.value(x, y, z);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)1.0E-15);
        x = 4.5;
        y = -1.5;
        z = -4.25;
        expected = f.value(x, y, z);
        result = tcf.value(x, y, z);
        Assert.assertEquals((String)"Half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)0.3);
        x = 3.5;
        y = -3.5;
        z = -10.0;
        expected = f.value(x, y, z);
        result = tcf.value(x, y, z);
        Assert.assertEquals((String)"Half-way between sample points (border of the patch)", (double)expected, (double)result, (double)0.3);
    }

    @Test
    public void testWave() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 4.0};
        double a = 0.2;
        double omega = 0.5;
        double kx = 2.0;
        double ky = 1.0;
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.cos((double)(0.5 * z - 2.0 * x - 1.0 * y));
            }
        };
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    fval[i][j][k] = f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] dFdX = new double[xval.length][yval.length][zval.length];
        TrivariateFunction dFdX_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.sin((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 2.0;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    dFdX[i][j][k] = dFdX_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] dFdY = new double[xval.length][yval.length][zval.length];
        TrivariateFunction dFdY_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.sin((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 1.0;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    dFdY[i][j][k] = dFdY_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] dFdZ = new double[xval.length][yval.length][zval.length];
        TrivariateFunction dFdZ_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -0.2 * FastMath.sin((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 0.5;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    dFdZ[i][j][k] = dFdZ_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] d2FdXdY = new double[xval.length][yval.length][zval.length];
        TrivariateFunction d2FdXdY_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return -0.2 * FastMath.cos((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 2.0 * 1.0;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    d2FdXdY[i][j][k] = d2FdXdY_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] d2FdXdZ = new double[xval.length][yval.length][zval.length];
        TrivariateFunction d2FdXdZ_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.cos((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 2.0 * 0.5;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    d2FdXdZ[i][j][k] = d2FdXdZ_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] d2FdYdZ = new double[xval.length][yval.length][zval.length];
        TrivariateFunction d2FdYdZ_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.cos((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 1.0 * 0.5;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    d2FdYdZ[i][j][k] = d2FdYdZ_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        double[][][] d3FdXdYdZ = new double[xval.length][yval.length][zval.length];
        TrivariateFunction d3FdXdYdZ_f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.sin((double)(0.5 * z - 2.0 * x - 1.0 * y)) * 2.0 * 1.0 * 0.5;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    d3FdXdYdZ[i][j][k] = d3FdXdYdZ_f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        TricubicSplineInterpolatingFunction tcf = new TricubicSplineInterpolatingFunction(xval, yval, zval, fval, dFdX, dFdY, dFdZ, d2FdXdY, d2FdXdZ, d2FdYdZ, d3FdXdYdZ);
        double x = 4.0;
        double y = -3.0;
        double z = 0.0;
        double expected = f.value(x, y, z);
        double result = tcf.value(x, y, z);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)1.0E-14);
        x = 4.5;
        y = -1.5;
        z = -4.25;
        expected = f.value(x, y, z);
        result = tcf.value(x, y, z);
        Assert.assertEquals((String)"Half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)0.1);
        x = 3.5;
        y = -3.5;
        z = -10.0;
        expected = f.value(x, y, z);
        result = tcf.value(x, y, z);
        Assert.assertEquals((String)"Half-way between sample points (border of the patch)", (double)expected, (double)result, (double)0.1);
    }
}

