/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.MicrosphereInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public final class MicrosphereInterpolatorTest {
    @Test
    public void testLinearFunction2D() {
        MultivariateFunction f = new MultivariateFunction(){

            public double value(double[] x) {
                if (x.length != 2) {
                    throw new IllegalArgumentException();
                }
                return 2.0 * x[0] - 3.0 * x[1] + 5.0;
            }
        };
        MicrosphereInterpolator interpolator = new MicrosphereInterpolator();
        int n = 9;
        int dim = 2;
        double[][] x = new double[9][2];
        double[] y = new double[9];
        int index = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                x[index][0] = i;
                x[index][1] = j;
                y[index] = f.value(x[index]);
                ++index;
            }
        }
        MultivariateFunction p = interpolator.interpolate(x, y);
        double[] c = new double[]{0.0, 0.0};
        double expected = f.value(c);
        double result = p.value(c);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)FastMath.ulp((double)1.0));
        c[0] = 1.0E-5;
        c[1] = 0.99999;
        expected = f.value(c);
        result = p.value(c);
        Assert.assertEquals((String)"1e-5 away from sample point", (double)expected, (double)result, (double)1.0E-4);
    }

    @Test
    public void testParaboloid2D() {
        MultivariateFunction f = new MultivariateFunction(){

            public double value(double[] x) {
                if (x.length != 2) {
                    throw new IllegalArgumentException();
                }
                return 2.0 * x[0] * x[0] - 3.0 * x[1] * x[1] + 4.0 * x[0] * x[1] - 5.0;
            }
        };
        MicrosphereInterpolator interpolator = new MicrosphereInterpolator();
        int n = 121;
        int dim = 2;
        double[][] x = new double[121][2];
        double[] y = new double[121];
        int index = 0;
        for (int i = -10; i <= 10; i += 2) {
            for (int j = -10; j <= 10; j += 2) {
                x[index][0] = i;
                x[index][1] = j;
                y[index] = f.value(x[index]);
                ++index;
            }
        }
        MultivariateFunction p = interpolator.interpolate(x, y);
        double[] c = new double[]{0.0, 0.0};
        double expected = f.value(c);
        double result = p.value(c);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)FastMath.ulp((double)1.0));
        c[0] = 2.00001;
        c[1] = 1.99999;
        expected = f.value(c);
        result = p.value(c);
        Assert.assertEquals((String)"1e-5 away from sample point", (double)expected, (double)result, (double)0.001);
    }
}

