/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotFiniteNumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class LoessInterpolatorTest {
    @Test
    public void testOnOnePoint() {
        double[] xval = new double[]{0.5};
        double[] yval = new double[]{0.7};
        double[] res = new LoessInterpolator().smooth(xval, yval);
        Assert.assertEquals((long)1L, (long)res.length);
        Assert.assertEquals((double)0.7, (double)res[0], (double)0.0);
    }

    @Test
    public void testOnTwoPoints() {
        double[] xval = new double[]{0.5, 0.6};
        double[] yval = new double[]{0.7, 0.8};
        double[] res = new LoessInterpolator().smooth(xval, yval);
        Assert.assertEquals((long)2L, (long)res.length);
        Assert.assertEquals((double)0.7, (double)res[0], (double)0.0);
        Assert.assertEquals((double)0.8, (double)res[1], (double)0.0);
    }

    @Test
    public void testOnStraightLine() {
        double[] xval = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] yval = new double[]{2.0, 4.0, 6.0, 8.0, 10.0};
        LoessInterpolator li = new LoessInterpolator(0.6, 2, 1.0E-12);
        double[] res = li.smooth(xval, yval);
        Assert.assertEquals((long)5L, (long)res.length);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((double)yval[i], (double)res[i], (double)1.0E-8);
        }
    }

    @Test
    public void testOnDistortedSine() {
        int numPoints = 100;
        double[] xval = new double[numPoints];
        double[] yval = new double[numPoints];
        double xnoise = 0.1;
        double ynoise = 0.2;
        this.generateSineData(xval, yval, xnoise, ynoise);
        LoessInterpolator li = new LoessInterpolator(0.3, 4, 1.0E-12);
        double[] res = li.smooth(xval, yval);
        double noisyResidualSum = 0.0;
        double fitResidualSum = 0.0;
        for (int i = 0; i < numPoints; ++i) {
            double expected = FastMath.sin((double)xval[i]);
            double noisy = yval[i];
            double fit = res[i];
            noisyResidualSum += FastMath.pow((double)(noisy - expected), (int)2);
            fitResidualSum += FastMath.pow((double)(fit - expected), (int)2);
        }
        Assert.assertTrue((fitResidualSum < noisyResidualSum ? 1 : 0) != 0);
    }

    @Test
    public void testIncreasingBandwidthIncreasesSmoothness() {
        int i;
        int numPoints = 100;
        double[] xval = new double[numPoints];
        double[] yval = new double[numPoints];
        double xnoise = 0.1;
        double ynoise = 0.1;
        this.generateSineData(xval, yval, xnoise, ynoise);
        double[] bandwidths = new double[]{0.1, 0.5, 1.0};
        double[] variances = new double[bandwidths.length];
        for (i = 0; i < bandwidths.length; ++i) {
            double bw = bandwidths[i];
            LoessInterpolator li = new LoessInterpolator(bw, 4, 1.0E-12);
            double[] res = li.smooth(xval, yval);
            for (int j = 1; j < res.length; ++j) {
                int n = i;
                variances[n] = variances[n] + FastMath.pow((double)(res[j] - res[j - 1]), (int)2);
            }
        }
        for (i = 1; i < variances.length; ++i) {
            Assert.assertTrue((variances[i] < variances[i - 1] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIncreasingRobustnessItersIncreasesSmoothnessWithOutliers() {
        int i;
        int numPoints = 100;
        double[] xval = new double[numPoints];
        double[] yval = new double[numPoints];
        double xnoise = 0.1;
        double ynoise = 0.1;
        this.generateSineData(xval, yval, xnoise, ynoise);
        int n = numPoints / 3;
        yval[n] = yval[n] * 100.0;
        int n2 = 2 * numPoints / 3;
        yval[n2] = yval[n2] * -100.0;
        double[] variances = new double[4];
        for (i = 0; i < 4; ++i) {
            LoessInterpolator li = new LoessInterpolator(0.3, i, 1.0E-12);
            double[] res = li.smooth(xval, yval);
            for (int j = 1; j < res.length; ++j) {
                int n3 = i;
                variances[n3] = variances[n3] + FastMath.abs((double)(res[j] - res[j - 1]));
            }
        }
        for (i = 1; i < variances.length; ++i) {
            Assert.assertTrue((variances[i] < variances[i - 1] ? 1 : 0) != 0);
        }
    }

    @Test(expected=DimensionMismatchException.class)
    public void testUnequalSizeArguments() {
        new LoessInterpolator().smooth(new double[]{1.0, 2.0, 3.0}, new double[]{1.0, 2.0, 3.0, 4.0});
    }

    @Test(expected=NoDataException.class)
    public void testEmptyData() {
        new LoessInterpolator().smooth(new double[0], new double[0]);
    }

    @Test(expected=NonMonotonicSequenceException.class)
    public void testNonStrictlyIncreasing1() {
        new LoessInterpolator().smooth(new double[]{4.0, 3.0, 1.0, 2.0}, new double[]{3.0, 4.0, 5.0, 6.0});
    }

    @Test(expected=NonMonotonicSequenceException.class)
    public void testNonStrictlyIncreasing2() {
        new LoessInterpolator().smooth(new double[]{1.0, 2.0, 2.0, 3.0}, new double[]{3.0, 4.0, 5.0, 6.0});
    }

    @Test(expected=NotFiniteNumberException.class)
    public void testNotAllFiniteReal1() {
        new LoessInterpolator().smooth(new double[]{1.0, 2.0, Double.NaN}, new double[]{3.0, 4.0, 5.0});
    }

    @Test(expected=NotFiniteNumberException.class)
    public void testNotAllFiniteReal2() {
        new LoessInterpolator().smooth(new double[]{1.0, 2.0, Double.POSITIVE_INFINITY}, new double[]{3.0, 4.0, 5.0});
    }

    @Test(expected=NotFiniteNumberException.class)
    public void testNotAllFiniteReal3() {
        new LoessInterpolator().smooth(new double[]{1.0, 2.0, Double.NEGATIVE_INFINITY}, new double[]{3.0, 4.0, 5.0});
    }

    @Test(expected=NotFiniteNumberException.class)
    public void testNotAllFiniteReal4() {
        new LoessInterpolator().smooth(new double[]{3.0, 4.0, 5.0}, new double[]{1.0, 2.0, Double.NaN});
    }

    @Test(expected=NotFiniteNumberException.class)
    public void testNotAllFiniteReal5() {
        new LoessInterpolator().smooth(new double[]{3.0, 4.0, 5.0}, new double[]{1.0, 2.0, Double.POSITIVE_INFINITY});
    }

    @Test(expected=NotFiniteNumberException.class)
    public void testNotAllFiniteReal6() {
        new LoessInterpolator().smooth(new double[]{3.0, 4.0, 5.0}, new double[]{1.0, 2.0, Double.NEGATIVE_INFINITY});
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testInsufficientBandwidth() {
        LoessInterpolator li = new LoessInterpolator(0.1, 3, 1.0E-12);
        li.smooth(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0}, new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0});
    }

    @Test(expected=OutOfRangeException.class)
    public void testCompletelyIncorrectBandwidth1() {
        new LoessInterpolator(-0.2, 3, 1.0E-12);
    }

    @Test(expected=OutOfRangeException.class)
    public void testCompletelyIncorrectBandwidth2() {
        new LoessInterpolator(1.1, 3, 1.0E-12);
    }

    @Test
    public void testMath296withoutWeights() {
        double[] xval = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0};
        double[] yval = new double[]{0.47, 0.48, 0.55, 0.56, -0.08, -0.04, -0.07, -0.07, -0.56, -0.46, -0.56, -0.52, -3.03, -3.08, -3.09, -3.04, 3.54, 3.46, 3.36, 3.35};
        double[] yref = new double[]{0.461, 0.499, 0.541, 0.308, 0.175, -0.042, -0.072, -0.196, -0.311, -0.446, -0.557, -1.497, -2.133, -3.08, -3.09, -0.621, 0.982, 3.449, 3.389, 3.336};
        LoessInterpolator li = new LoessInterpolator(0.3, 4, 1.0E-12);
        double[] res = li.smooth(xval, yval);
        Assert.assertEquals((long)xval.length, (long)res.length);
        for (int i = 0; i < res.length; ++i) {
            Assert.assertEquals((double)yref[i], (double)res[i], (double)0.02);
        }
    }

    private void generateSineData(double[] xval, double[] yval, double xnoise, double ynoise) {
        double dx = Math.PI * 2 / (double)xval.length;
        double x = 0.0;
        for (int i = 0; i < xval.length; ++i) {
            xval[i] = x;
            yval[i] = FastMath.sin((double)x) + (2.0 * FastMath.random() - 1.0) * ynoise;
            x += dx * (1.0 + (2.0 * FastMath.random() - 1.0) * xnoise);
        }
    }
}

