/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.BivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.BicubicSplineFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Deprecated
public final class BicubicSplineInterpolatingFunctionTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[][] zval = new double[xval.length][yval.length];
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, zval, zval, zval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            bcf = new BicubicSplineInterpolatingFunction(wxval, yval, zval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -1.0, -1.0, 2.5};
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, wyval, zval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][] wzval = new double[xval.length][yval.length - 1];
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, wzval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, wzval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, zval, wzval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, zval, zval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wzval = new double[xval.length - 1][yval.length];
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, wzval, zval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, wzval, zval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, zval, wzval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, zval, zval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Ignore
    @Test
    public void testPlane() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5};
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        double[][] dZdX = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdX[i][j] = 2.0;
            }
        }
        double[][] dZdY = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdY[i][j] = -3.0;
            }
        }
        double[][] dZdXdY = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdXdY[i][j] = 0.0;
            }
        }
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, dZdX, dZdY, dZdXdY);
        double x = 4.0;
        double y = -3.0;
        double expected = f.value(x, y);
        double result = bcf.value(x, y);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)1.0E-15);
        x = 4.5;
        y = -1.5;
        expected = f.value(x, y);
        result = bcf.value(x, y);
        Assert.assertEquals((String)"Half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)0.3);
        x = 3.5;
        y = -3.5;
        expected = f.value(x, y);
        result = bcf.value(x, y);
        Assert.assertEquals((String)"Half-way between sample points (border of the patch)", (double)expected, (double)result, (double)0.3);
    }

    @Ignore
    @Test
    public void testParaboloid() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5};
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        double[][] dZdX = new double[xval.length][yval.length];
        BivariateFunction dfdX = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0 * (x + y);
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdX[i][j] = dfdX.value(xval[i], yval[j]);
            }
        }
        double[][] dZdY = new double[xval.length][yval.length];
        BivariateFunction dfdY = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0 * x - 6.0 * y;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdY[i][j] = dfdY.value(xval[i], yval[j]);
            }
        }
        double[][] dZdXdY = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdXdY[i][j] = 4.0;
            }
        }
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, dZdX, dZdY, dZdXdY);
        double x = 4.0;
        double y = -3.0;
        double expected = f.value(x, y);
        double result = bcf.value(x, y);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)1.0E-15);
        x = 4.5;
        y = -1.5;
        expected = f.value(x, y);
        result = bcf.value(x, y);
        Assert.assertEquals((String)"Half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)2.0);
        x = 3.5;
        y = -3.5;
        expected = f.value(x, y);
        result = bcf.value(x, y);
        Assert.assertEquals((String)"Half-way between sample points (border of the patch)", (double)expected, (double)result, (double)2.0);
    }

    @Ignore
    @Test
    public void testSplinePartialDerivatives() {
        int N = 4;
        double[] coeff = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                coeff[i + 4 * j] = (i + 1) * (j + 2);
            }
        }
        BicubicSplineFunction f = new BicubicSplineFunction(coeff);
        double x = 0.435;
        double y = 0.776;
        double tol = 1.0E-13;
        Object derivative = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double y2 = y * y;
                double y3 = y2 * y;
                double yFactor = 2.0 + 3.0 * y + 4.0 * y2 + 5.0 * y3;
                return yFactor * (2.0 + 6.0 * x + 12.0 * x2);
            }
        };
        Assert.assertEquals((String)"dFdX", (double)derivative.value(0.435, 0.776), (double)f.partialDerivativeX().value(0.435, 0.776), (double)1.0E-13);
        derivative = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double x3 = x2 * x;
                double y2 = y * y;
                double xFactor = 1.0 + 2.0 * x + 3.0 * x2 + 4.0 * x3;
                return xFactor * (3.0 + 8.0 * y + 15.0 * y2);
            }
        };
        Assert.assertEquals((String)"dFdY", (double)derivative.value(0.435, 0.776), (double)f.partialDerivativeY().value(0.435, 0.776), (double)1.0E-13);
        derivative = new BivariateFunction(){

            public double value(double x, double y) {
                double y2 = y * y;
                double y3 = y2 * y;
                double yFactor = 2.0 + 3.0 * y + 4.0 * y2 + 5.0 * y3;
                return yFactor * (6.0 + 24.0 * x);
            }
        };
        Assert.assertEquals((String)"d2FdX2", (double)derivative.value(0.435, 0.776), (double)f.partialDerivativeXX().value(0.435, 0.776), (double)1.0E-13);
        derivative = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double x3 = x2 * x;
                double xFactor = 1.0 + 2.0 * x + 3.0 * x2 + 4.0 * x3;
                return xFactor * (8.0 + 30.0 * y);
            }
        };
        Assert.assertEquals((String)"d2FdY2", (double)derivative.value(0.435, 0.776), (double)f.partialDerivativeYY().value(0.435, 0.776), (double)1.0E-13);
        derivative = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double y2 = y * y;
                double yFactor = 3.0 + 8.0 * y + 15.0 * y2;
                return yFactor * (2.0 + 6.0 * x + 12.0 * x2);
            }
        };
        Assert.assertEquals((String)"d2FdXdY", (double)derivative.value(0.435, 0.776), (double)f.partialDerivativeXY().value(0.435, 0.776), (double)1.0E-13);
    }

    @Ignore
    @Test
    public void testMatchingPartialDerivatives() {
        int sz = 21;
        double[] val = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            val[i] = (double)i * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double x3 = x2 * x;
                double y2 = y * y;
                double y3 = y2 * y;
                return 5.0 - 3.0 * x + 2.0 * y - x * y + 2.0 * x2 - 3.0 * y2 + 4.0 * x2 * y - x * y2 - 3.0 * x3 + y3;
            }
        };
        double[][] fval = new double[21][21];
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 21; ++j) {
                fval[i][j] = f.value(val[i], val[j]);
            }
        }
        double[][] dFdX = new double[21][21];
        BivariateFunction dfdX = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double y2 = y * y;
                return -3.0 - y + 4.0 * x + 8.0 * x * y - y2 - 9.0 * x2;
            }
        };
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 21; ++j) {
                dFdX[i][j] = dfdX.value(val[i], val[j]);
            }
        }
        double[][] dFdY = new double[21][21];
        BivariateFunction dfdY = new BivariateFunction(){

            public double value(double x, double y) {
                double x2 = x * x;
                double y2 = y * y;
                return 2.0 - x - 6.0 * y + 4.0 * x2 - 2.0 * x * y + 3.0 * y2;
            }
        };
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 21; ++j) {
                dFdY[i][j] = dfdY.value(val[i], val[j]);
            }
        }
        double[][] d2FdXdY = new double[21][21];
        BivariateFunction d2fdXdY = new BivariateFunction(){

            public double value(double x, double y) {
                return -1.0 + 8.0 * x - 2.0 * y;
            }
        };
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 21; ++j) {
                d2FdXdY[i][j] = d2fdXdY.value(val[i], val[j]);
            }
        }
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(val, val, fval, dFdX, dFdY, d2FdXdY);
        double tol = 1.0E-12;
        for (int i = 0; i < 21; ++i) {
            double x = val[i];
            for (int j = 0; j < 21; ++j) {
                double y = val[j];
                double expected = dfdX.value(x, y);
                double result = bcf.partialDerivativeX(x, y);
                Assert.assertEquals((String)(x + " " + y + " dFdX"), (double)expected, (double)result, (double)1.0E-12);
                expected = dfdY.value(x, y);
                result = bcf.partialDerivativeY(x, y);
                Assert.assertEquals((String)(x + " " + y + " dFdY"), (double)expected, (double)result, (double)1.0E-12);
                expected = d2fdXdY.value(x, y);
                result = bcf.partialDerivativeXY(x, y);
                Assert.assertEquals((String)(x + " " + y + " d2FdXdY"), (double)expected, (double)result, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testInterpolation1() {
        int sz = 21;
        double[] xval = new double[21];
        double[] yval = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            xval[i] = -1.0 + (double)(15 * i) * 0.05;
            yval[i] = -20.0 + (double)(30 * i) * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        double[][] dZdX = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdX[i][j] = 2.0;
            }
        }
        double[][] dZdY = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdY[i][j] = -3.0;
            }
        }
        double[][] dZdXdY = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdXdY[i][j] = 0.0;
            }
        }
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, dZdX, dZdY, dZdXdY);
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xval[0], xval[xval.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yval[0], yval[yval.length - 1]);
        int numSamples = 50;
        double tol = 6.0;
        for (int i = 0; i < 50; ++i) {
            double x = distX.sample();
            for (int j = 0; j < 50; ++j) {
                double y = distY.sample();
                Assert.assertEquals((double)f.value(x, y), (double)bcf.value(x, y), (double)6.0);
            }
        }
    }

    @Test
    public void testInterpolation2() {
        int sz = 21;
        double[] xval = new double[21];
        double[] yval = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            xval[i] = -1.0 + (double)(15 * i) * 0.05;
            yval[i] = -20.0 + (double)(30 * i) * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        double[][] dZdX = new double[xval.length][yval.length];
        BivariateFunction dfdX = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0 * (x + y);
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdX[i][j] = dfdX.value(xval[i], yval[j]);
            }
        }
        double[][] dZdY = new double[xval.length][yval.length];
        BivariateFunction dfdY = new BivariateFunction(){

            public double value(double x, double y) {
                return 4.0 * x - 6.0 * y;
            }
        };
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdY[i][j] = dfdY.value(xval[i], yval[j]);
            }
        }
        double[][] dZdXdY = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                dZdXdY[i][j] = 4.0;
            }
        }
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(xval, yval, zval, dZdX, dZdY, dZdXdY);
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xval[0], xval[xval.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yval[0], yval[yval.length - 1]);
        double tol = 224.0;
        for (int i = 0; i < 21; ++i) {
            double x = distX.sample();
            for (int j = 0; j < 21; ++j) {
                double y = distY.sample();
                Assert.assertEquals((double)f.value(x, y), (double)bcf.value(x, y), (double)224.0);
            }
        }
    }

    @Test
    public void testIsValidPoint() {
        double[][] f;
        double xMin = -12.0;
        double xMax = 34.0;
        double yMin = 5.0;
        double yMax = 67.0;
        double[] xval = new double[]{-12.0, 34.0};
        double[] yval = new double[]{5.0, 67.0};
        double[][] dFdX = f = new double[][]{{1.0, 2.0}, {3.0, 4.0}};
        double[][] dFdY = f;
        double[][] dFdXdY = f;
        BicubicSplineInterpolatingFunction bcf = new BicubicSplineInterpolatingFunction(xval, yval, (double[][])f, (double[][])dFdX, (double[][])dFdY, (double[][])dFdXdY);
        double x = -12.0;
        double y = 5.0;
        Assert.assertTrue((boolean)bcf.isValidPoint(x, y));
        bcf.value(x, y);
        x = 34.0;
        y = 67.0;
        Assert.assertTrue((boolean)bcf.isValidPoint(x, y));
        bcf.value(x, y);
        double xRange = 46.0;
        double yRange = 62.0;
        x = 1.5294117647058822;
        y = 56.66666666666667;
        Assert.assertTrue((boolean)bcf.isValidPoint(x, y));
        bcf.value(x, y);
        double small = 1.0E-8;
        x = -12.00000001;
        y = 67.0;
        Assert.assertFalse((boolean)bcf.isValidPoint(x, y));
        try {
            bcf.value(x, y);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        x = -12.0;
        y = 67.00000001;
        Assert.assertFalse((boolean)bcf.isValidPoint(x, y));
        try {
            bcf.value(x, y);
            Assert.fail((String)"OutOfRangeException expected");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }
}

