/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Power;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public abstract class GaussianQuadratureAbstractTest {
    private final double eps;
    private final double numUlps;
    private final GaussIntegrator integrator;
    private final int maxDegree;

    public GaussianQuadratureAbstractTest(GaussIntegrator integrator, int maxDegree, double eps, double numUlps) {
        this.integrator = integrator;
        this.maxDegree = maxDegree;
        this.eps = eps;
        this.numUlps = numUlps;
    }

    public abstract double getExpectedValue(int var1);

    @Test
    public void testAllMonomials() {
        for (int n = 0; n <= this.maxDegree; ++n) {
            double expected = this.getExpectedValue(n);
            Power monomial = new Power((double)n);
            double actual = this.integrator.integrate((UnivariateFunction)monomial);
            if (expected == 0.0) {
                Assert.assertEquals((String)("while integrating monomial x**" + n + " with a " + this.integrator.getNumberOfPoints() + "-point quadrature rule"), (double)expected, (double)actual, (double)this.eps);
                continue;
            }
            double err = FastMath.abs((double)(actual - expected)) / Math.ulp(expected);
            Assert.assertEquals((String)("while integrating monomial x**" + n + " with a " + this.integrator.getNumberOfPoints() + "-point quadrature rule, " + " error was " + err + " ulps"), (double)expected, (double)actual, (double)(Math.ulp(expected) * this.numUlps));
        }
    }
}

