/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.JacobianFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.MultivariateDifferentiableVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class JacobianFunctionTest {
    @Test
    public void testSphere() {
        SphereMapping f = new SphereMapping(10.0);
        JacobianFunction j = new JacobianFunction((MultivariateDifferentiableVectorFunction)f);
        for (double latitude = -1.5; latitude < 1.5; latitude += 0.1) {
            for (double longitude = -3.1; longitude < 3.1; longitude += 0.1) {
                double[] point = new double[]{latitude, longitude};
                double[][] referenceJacobian = f.jacobian(point);
                double[][] testJacobian = j.value(point);
                Assert.assertEquals((long)referenceJacobian.length, (long)testJacobian.length);
                for (int i = 0; i < 3; ++i) {
                    TestUtils.assertEquals(referenceJacobian[i], testJacobian[i], 2.0E-15);
                }
            }
        }
    }

    private static class SphereMapping
    implements MultivariateDifferentiableVectorFunction {
        private final double radius;

        public SphereMapping(double radius) {
            this.radius = radius;
        }

        public double[] value(double[] point) {
            double cLat = FastMath.cos((double)point[0]);
            double sLat = FastMath.sin((double)point[0]);
            double cLon = FastMath.cos((double)point[1]);
            double sLon = FastMath.sin((double)point[1]);
            return new double[]{this.radius * cLon * cLat, this.radius * sLon * cLat, this.radius * sLat};
        }

        public DerivativeStructure[] value(DerivativeStructure[] point) {
            DerivativeStructure cLat = point[0].cos();
            DerivativeStructure sLat = point[0].sin();
            DerivativeStructure cLon = point[1].cos();
            DerivativeStructure sLon = point[1].sin();
            return new DerivativeStructure[]{cLon.multiply(cLat).multiply(this.radius), sLon.multiply(cLat).multiply(this.radius), sLat.multiply(this.radius)};
        }

        public double[][] jacobian(double[] point) {
            double cLat = FastMath.cos((double)point[0]);
            double sLat = FastMath.sin((double)point[0]);
            double cLon = FastMath.cos((double)point[1]);
            double sLon = FastMath.sin((double)point[1]);
            return new double[][]{{-this.radius * cLon * sLat, -this.radius * sLon * cLat}, {-this.radius * sLon * sLat, this.radius * cLon * cLat}, {this.radius * cLat, 0.0}};
        }
    }
}

