/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.language.bm;

import org.junit.jupiter.api.Test;

class CacheSubSequencePerformanceTest {
    CacheSubSequencePerformanceTest() {
    }

    private CharSequence cacheSubSequence(final CharSequence cached) {
        final CharSequence[][] cache = new CharSequence[cached.length()][cached.length()];
        return new CharSequence(){

            @Override
            public char charAt(int index) {
                return cached.charAt(index);
            }

            @Override
            public int length() {
                return cached.length();
            }

            @Override
            public CharSequence subSequence(int start, int end) {
                if (start == end) {
                    return "";
                }
                CharSequence res = cache[start][end - 1];
                if (res == null) {
                    cache[start][end - 1] = res = cached.subSequence(start, end);
                }
                return res;
            }
        };
    }

    @Test
    void test() {
        int times = 10000000;
        System.out.print("Test with String : ");
        this.test("Angelo", 10000000);
        System.out.print("Test with StringBuilder : ");
        this.test(new StringBuilder("Angelo"), 10000000);
        System.out.print("Test with cached String : ");
        this.test(this.cacheSubSequence("Angelo"), 10000000);
        System.out.print("Test with cached StringBuilder : ");
        this.test(this.cacheSubSequence(new StringBuilder("Angelo")), 10000000);
    }

    private void test(CharSequence input) {
        for (int i = 0; i < input.length(); ++i) {
            for (int j = i; j <= input.length(); ++j) {
                input.subSequence(i, j);
            }
        }
    }

    private void test(CharSequence input, int times) {
        long beginTimeMillis = System.currentTimeMillis();
        for (int i = 0; i < times; ++i) {
            this.test(input);
        }
        System.out.println(System.currentTimeMillis() - beginTimeMillis + " millis");
    }
}

