/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.language;

import com.hazelcast.shaded.org.apache.commons.codec.AbstractStringEncoderTest;
import com.hazelcast.shaded.org.apache.commons.codec.EncoderException;
import com.hazelcast.shaded.org.apache.commons.codec.language.DaitchMokotoffSoundex;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class DaitchMokotoffSoundexTest
extends AbstractStringEncoderTest<DaitchMokotoffSoundex> {
    DaitchMokotoffSoundexTest() {
    }

    static IntStream getNonLetters() {
        return IntStream.rangeClosed(0, 65535).filter(c -> !Character.isLetter(c));
    }

    @Override
    protected DaitchMokotoffSoundex createStringEncoder() {
        return new DaitchMokotoffSoundex();
    }

    private String encode(String source) {
        return ((DaitchMokotoffSoundex)this.getStringEncoder()).encode(source);
    }

    private String soundex(String source) {
        return ((DaitchMokotoffSoundex)this.getStringEncoder()).soundex(source);
    }

    @Test
    void testAccentedCharacterFolding() {
        Assertions.assertEquals((Object)"294795", (Object)this.soundex("Stra\u00dfburg"));
        Assertions.assertEquals((Object)"294795", (Object)this.soundex("Strasburg"));
        Assertions.assertEquals((Object)"095600", (Object)this.soundex("\u00c9regon"));
        Assertions.assertEquals((Object)"095600", (Object)this.soundex("Eregon"));
    }

    @Test
    void testAdjacentCodes() {
        Assertions.assertEquals((Object)"054800", (Object)this.soundex("AKSSOL"));
        Assertions.assertEquals((Object)"547830|545783|594783|594578", (Object)this.soundex("GERSCHFELD"));
    }

    @Test
    void testEncodeBasic() {
        Assertions.assertEquals((Object)"097400", (Object)this.encode("AUERBACH"));
        Assertions.assertEquals((Object)"097400", (Object)this.encode("OHRBACH"));
        Assertions.assertEquals((Object)"874400", (Object)this.encode("LIPSHITZ"));
        Assertions.assertEquals((Object)"874400", (Object)this.encode("LIPPSZYC"));
        Assertions.assertEquals((Object)"876450", (Object)this.encode("LEWINSKY"));
        Assertions.assertEquals((Object)"876450", (Object)this.encode("LEVINSKI"));
        Assertions.assertEquals((Object)"486740", (Object)this.encode("SZLAMAWICZ"));
        Assertions.assertEquals((Object)"486740", (Object)this.encode("SHLAMOVITZ"));
    }

    @Test
    void testEncodeIgnoreApostrophes() throws EncoderException {
        this.checkEncodingVariations("079600", "OBrien", "'OBrien", "O'Brien", "OB'rien", "OBr'ien", "OBri'en", "OBrie'n", "OBrien'");
    }

    @Test
    void testEncodeIgnoreHyphens() throws EncoderException {
        this.checkEncodingVariations("565463", "KINGSMITH", "-KINGSMITH", "K-INGSMITH", "KI-NGSMITH", "KIN-GSMITH", "KING-SMITH", "KINGS-MITH", "KINGSM-ITH", "KINGSMI-TH", "KINGSMIT-H", "KINGSMITH-");
    }

    @ParameterizedTest
    @MethodSource(value={"getNonLetters"})
    void testEncodeIgnoreNonLetters(int nonLetterInt) throws EncoderException {
        char nonLetterChar = (char)nonLetterInt;
        this.checkEncodingVariations("746536", "Washington" + nonLetterChar, nonLetterChar + "Washington", nonLetterChar + "Washington" + nonLetterChar, "Washi" + nonLetterChar + "ngton");
    }

    @Test
    void testEncodeIgnoreTrimmable() {
        Assertions.assertEquals((Object)"746536", (Object)this.encode(" \t\n\r Washington \t\n\r "));
        Assertions.assertEquals((Object)"746536", (Object)this.encode("Washington"));
    }

    @Test
    void testSoundexBasic() {
        Assertions.assertEquals((Object)"583600", (Object)this.soundex("GOLDEN"));
        Assertions.assertEquals((Object)"087930", (Object)this.soundex("Alpert"));
        Assertions.assertEquals((Object)"791900", (Object)this.soundex("Breuer"));
        Assertions.assertEquals((Object)"579000", (Object)this.soundex("Haber"));
        Assertions.assertEquals((Object)"665600", (Object)this.soundex("Mannheim"));
        Assertions.assertEquals((Object)"664000", (Object)this.soundex("Mintz"));
        Assertions.assertEquals((Object)"370000", (Object)this.soundex("Topf"));
        Assertions.assertEquals((Object)"586660", (Object)this.soundex("Kleinmann"));
        Assertions.assertEquals((Object)"769600", (Object)this.soundex("Ben Aron"));
        Assertions.assertEquals((Object)"097400|097500", (Object)this.soundex("AUERBACH"));
        Assertions.assertEquals((Object)"097400|097500", (Object)this.soundex("OHRBACH"));
        Assertions.assertEquals((Object)"874400", (Object)this.soundex("LIPSHITZ"));
        Assertions.assertEquals((Object)"874400|874500", (Object)this.soundex("LIPPSZYC"));
        Assertions.assertEquals((Object)"876450", (Object)this.soundex("LEWINSKY"));
        Assertions.assertEquals((Object)"876450", (Object)this.soundex("LEVINSKI"));
        Assertions.assertEquals((Object)"486740", (Object)this.soundex("SZLAMAWICZ"));
        Assertions.assertEquals((Object)"486740", (Object)this.soundex("SHLAMOVITZ"));
    }

    @Test
    void testSoundexBasic2() {
        Assertions.assertEquals((Object)"467000|567000", (Object)this.soundex("Ceniow"));
        Assertions.assertEquals((Object)"467000", (Object)this.soundex("Tsenyuv"));
        Assertions.assertEquals((Object)"587400|587500", (Object)this.soundex("Holubica"));
        Assertions.assertEquals((Object)"587400", (Object)this.soundex("Golubitsa"));
        Assertions.assertEquals((Object)"746480|794648", (Object)this.soundex("Przemysl"));
        Assertions.assertEquals((Object)"746480", (Object)this.soundex("Pshemeshil"));
        Assertions.assertEquals((Object)"944744|944745|944754|944755|945744|945745|945754|945755", (Object)this.soundex("Rosochowaciec"));
        Assertions.assertEquals((Object)"945744", (Object)this.soundex("Rosokhovatsets"));
    }

    @Test
    void testSoundexBasic3() {
        Assertions.assertEquals((Object)"734000|739400", (Object)this.soundex("Peters"));
        Assertions.assertEquals((Object)"734600|739460", (Object)this.soundex("Peterson"));
        Assertions.assertEquals((Object)"645740", (Object)this.soundex("Moskowitz"));
        Assertions.assertEquals((Object)"645740", (Object)this.soundex("Moskovitz"));
        Assertions.assertEquals((Object)"154600|145460|454600|445460", (Object)this.soundex("Jackson"));
        String jacksonJackson = "154654|154645|154644|145465|145464|454654|454645|454644|445465|445464";
        Assertions.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("Jackson-Jackson"));
        Assertions.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("Jackson--Jackson"));
        Assertions.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("Jackson\u2014Jackson"));
        Assertions.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("Jackson_Jackson"));
        Assertions.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("Jackson$Jackson"));
        Assertions.assertEquals((Object)"154654|154645|154644|145465|145464|454654|454645|454644|445465|445464", (Object)this.soundex("JacksonJackson"));
    }

    @Test
    void testSpecialRomanianCharacters() {
        Assertions.assertEquals((Object)"364000|464000", (Object)this.soundex("\u0163amas"));
        Assertions.assertEquals((Object)"364000|464000", (Object)this.soundex("\u021bamas"));
    }
}

