/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.digest;

import com.hazelcast.shaded.org.apache.commons.codec.digest.DigestUtils;
import com.hazelcast.shaded.org.apache.commons.codec.digest.DigestUtilsTest;
import com.hazelcast.shaded.org.apache.commons.codec.digest.MessageDigestAlgorithms;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class MessageDigestAlgorithmsTest {
    private DigestUtilsTest digestUtilsTest;

    MessageDigestAlgorithmsTest() {
    }

    @BeforeAll
    public static void checkValues() throws Exception {
        Field[] fields = MessageDigestAlgorithms.class.getDeclaredFields();
        boolean ok = true;
        int psf = 0;
        for (Field f : fields) {
            int modifiers;
            if (f.getName().contains("cobertura") || !Modifier.isPublic(modifiers = f.getModifiers()) || !Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            ++psf;
            if (MessageDigestAlgorithmsTest.contains((String)f.get(null))) continue;
            System.out.println("Not found in MessageDigestAlgorithms.values(): " + f.getName());
            ok = false;
        }
        if (!ok) {
            Assertions.fail((String)"One or more entries are missing from the MessageDigestAlgorithms.values() array");
        }
        if (psf != MessageDigestAlgorithms.values().length) {
            Assertions.fail((String)"One or more unexpected entries found in the MessageDigestAlgorithms.values() array");
        }
    }

    private static boolean contains(String key) {
        for (String s : MessageDigestAlgorithms.values()) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static String[] data() {
        return MessageDigestAlgorithms.values();
    }

    private byte[] digestTestData(String messageDigestAlgorithm) {
        return DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (byte[])this.getTestData());
    }

    private byte[] getTestData() {
        return this.digestUtilsTest.getTestData();
    }

    private File getTestFile() {
        return this.digestUtilsTest.getTestPath().toFile();
    }

    private Path getTestPath() {
        return this.digestUtilsTest.getTestPath();
    }

    private RandomAccessFile getTestRandomAccessFile() {
        return this.digestUtilsTest.getTestRandomAccessFile();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.digestUtilsTest = new DigestUtilsTest();
        this.digestUtilsTest.setUp();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.digestUtilsTest.tearDown();
        this.digestUtilsTest = null;
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testAlgorithm(String messageDigestAlgorithm) throws NoSuchAlgorithmException {
        String algorithm = messageDigestAlgorithm;
        Assertions.assertNotNull((Object)algorithm);
        Assertions.assertFalse((boolean)algorithm.isEmpty());
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        MessageDigest.getInstance(algorithm);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testDigestByteArray(String messageDigestAlgorithm) {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (byte[])this.getTestData()));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (byte[])this.getTestData()));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testDigestByteBuffer(String messageDigestAlgorithm) {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (ByteBuffer)ByteBuffer.wrap(this.getTestData())));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (ByteBuffer)ByteBuffer.wrap(this.getTestData())));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testDigestFile(String messageDigestAlgorithm) throws IOException {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (File)this.getTestFile()));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (File)this.getTestFile()));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testDigestInputStream(String messageDigestAlgorithm) throws IOException {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (InputStream)new ByteArrayInputStream(this.getTestData())));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (InputStream)new ByteArrayInputStream(this.getTestData())));
    }

    private void testDigestPath(String messageDigestAlgorithm, OpenOption ... options) throws IOException {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (Path)this.getTestPath(), (OpenOption[])options));
        Assertions.assertArrayEquals((byte[])this.digestTestData(messageDigestAlgorithm), (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (Path)this.getTestPath(), (OpenOption[])options));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testDigestPathOpenOptionsEmpty(String messageDigestAlgorithm) throws IOException {
        this.testDigestPath(messageDigestAlgorithm, new OpenOption[0]);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testDigestPathStandardOpenOptionRead(String messageDigestAlgorithm) throws IOException {
        this.testDigestPath(messageDigestAlgorithm, StandardOpenOption.READ);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testGetMessageDigest(String messageDigestAlgorithm) {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        MessageDigest messageDigest = DigestUtils.getDigest((String)messageDigestAlgorithm);
        Assertions.assertEquals((Object)messageDigestAlgorithm, (Object)messageDigest.getAlgorithm());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    void testNonBlockingDigestRandomAccessFile(String messageDigestAlgorithm) throws IOException {
        Assumptions.assumeTrue((boolean)DigestUtils.isAvailable((String)messageDigestAlgorithm));
        byte[] expected = this.digestTestData(messageDigestAlgorithm);
        RandomAccessFile randomAccessFile = this.getTestRandomAccessFile();
        Assertions.assertArrayEquals((byte[])expected, (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (RandomAccessFile)randomAccessFile));
        randomAccessFile.seek(0L);
        Assertions.assertArrayEquals((byte[])expected, (byte[])DigestUtils.digest((MessageDigest)DigestUtils.getDigest((String)messageDigestAlgorithm), (RandomAccessFile)randomAccessFile));
    }
}

