/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HazelcastIntegerTypeTest {
    @Test
    public void testNullableIntegerTypeOfTypeName() {
        HazelcastIntegerTypeTest.assertType(SqlTypeName.TINYINT, 7, false, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.TINYINT, (boolean)false));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.SMALLINT, 15, false, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.SMALLINT, (boolean)false));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.INTEGER, 31, false, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.INTEGER, (boolean)false));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.BIGINT, 63, false, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.BIGINT, (boolean)false));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.TINYINT, 7, true, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.TINYINT, (boolean)true));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.SMALLINT, 15, true, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.SMALLINT, (boolean)true));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.INTEGER, 31, true, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.INTEGER, (boolean)true));
        HazelcastIntegerTypeTest.assertType(SqlTypeName.BIGINT, 63, true, (RelDataType)HazelcastIntegerType.create((SqlTypeName)SqlTypeName.BIGINT, (boolean)true));
    }

    @Test
    public void testNullableIntegerTypeOfType() {
        HazelcastIntegerType intType = HazelcastIntegerType.create((SqlTypeName)SqlTypeName.INTEGER, (boolean)false);
        HazelcastIntegerType nullableIntType = HazelcastIntegerType.create((SqlTypeName)SqlTypeName.INTEGER, (boolean)true);
        Assert.assertSame((Object)intType, (Object)HazelcastIntegerType.create((HazelcastIntegerType)intType, (boolean)false));
        Assert.assertSame((Object)nullableIntType, (Object)HazelcastIntegerType.create((HazelcastIntegerType)intType, (boolean)true));
        Assert.assertSame((Object)intType, (Object)HazelcastIntegerType.create((HazelcastIntegerType)nullableIntType, (boolean)false));
        Assert.assertSame((Object)nullableIntType, (Object)HazelcastIntegerType.create((HazelcastIntegerType)nullableIntType, (boolean)true));
    }

    @Test
    public void testNullableIntegerTypeOfBitWidth() {
        for (int i = 0; i < 74; ++i) {
            HazelcastIntegerType type = HazelcastIntegerType.create((int)i, (boolean)false);
            HazelcastIntegerType nullableType = HazelcastIntegerType.create((int)i, (boolean)true);
            if (i < 8) {
                HazelcastIntegerTypeTest.assertType(SqlTypeName.TINYINT, i, false, (RelDataType)type);
                HazelcastIntegerTypeTest.assertType(SqlTypeName.TINYINT, i, true, (RelDataType)nullableType);
                continue;
            }
            if (i < 16) {
                HazelcastIntegerTypeTest.assertType(SqlTypeName.SMALLINT, i, false, (RelDataType)type);
                HazelcastIntegerTypeTest.assertType(SqlTypeName.SMALLINT, i, true, (RelDataType)nullableType);
                continue;
            }
            if (i < 32) {
                HazelcastIntegerTypeTest.assertType(SqlTypeName.INTEGER, i, false, (RelDataType)type);
                HazelcastIntegerTypeTest.assertType(SqlTypeName.INTEGER, i, true, (RelDataType)nullableType);
                continue;
            }
            if (i < 64) {
                HazelcastIntegerTypeTest.assertType(SqlTypeName.BIGINT, i, false, (RelDataType)type);
                HazelcastIntegerTypeTest.assertType(SqlTypeName.BIGINT, i, true, (RelDataType)nullableType);
                continue;
            }
            HazelcastIntegerTypeTest.assertType(SqlTypeName.BIGINT, 64, false, (RelDataType)type);
            HazelcastIntegerTypeTest.assertType(SqlTypeName.BIGINT, 64, true, (RelDataType)nullableType);
        }
    }

    @Test
    public void testBitWidthOfLong() {
        Assert.assertEquals((long)0L, (long)HazelcastIntegerType.bitWidthOf((long)0L));
        Assert.assertEquals((long)1L, (long)HazelcastIntegerType.bitWidthOf((long)1L));
        Assert.assertEquals((long)1L, (long)HazelcastIntegerType.bitWidthOf((long)-1L));
        Assert.assertEquals((long)2L, (long)HazelcastIntegerType.bitWidthOf((long)2L));
        Assert.assertEquals((long)2L, (long)HazelcastIntegerType.bitWidthOf((long)-2L));
        Assert.assertEquals((long)10L, (long)HazelcastIntegerType.bitWidthOf((long)555L));
        Assert.assertEquals((long)10L, (long)HazelcastIntegerType.bitWidthOf((long)-555L));
        Assert.assertEquals((long)63L, (long)HazelcastIntegerType.bitWidthOf((long)Long.MAX_VALUE));
        Assert.assertEquals((long)63L, (long)HazelcastIntegerType.bitWidthOf((long)Long.MIN_VALUE));
        Assert.assertEquals((long)31L, (long)HazelcastIntegerType.bitWidthOf((long)Integer.MAX_VALUE));
        Assert.assertEquals((long)31L, (long)HazelcastIntegerType.bitWidthOf((long)Integer.MIN_VALUE));
        Assert.assertEquals((long)15L, (long)HazelcastIntegerType.bitWidthOf((long)32767L));
        Assert.assertEquals((long)15L, (long)HazelcastIntegerType.bitWidthOf((long)-32768L));
        Assert.assertEquals((long)7L, (long)HazelcastIntegerType.bitWidthOf((long)127L));
        Assert.assertEquals((long)7L, (long)HazelcastIntegerType.bitWidthOf((long)-128L));
    }

    @Test
    public void testBitWidthOfTypeName() {
        block6: for (SqlTypeName typeName : SqlTypeName.values()) {
            switch (typeName) {
                case TINYINT: {
                    Assert.assertEquals((long)7L, (long)HazelcastIntegerType.bitWidthOf((SqlTypeName)typeName));
                    continue block6;
                }
                case SMALLINT: {
                    Assert.assertEquals((long)15L, (long)HazelcastIntegerType.bitWidthOf((SqlTypeName)typeName));
                    continue block6;
                }
                case INTEGER: {
                    Assert.assertEquals((long)31L, (long)HazelcastIntegerType.bitWidthOf((SqlTypeName)typeName));
                    continue block6;
                }
                case BIGINT: {
                    Assert.assertEquals((long)63L, (long)HazelcastIntegerType.bitWidthOf((SqlTypeName)typeName));
                    continue block6;
                }
                default: {
                    HazelcastTestSupport.assertThrows(IllegalArgumentException.class, () -> HazelcastIntegerType.bitWidthOf((SqlTypeName)typeName));
                }
            }
        }
    }

    private static void assertType(SqlTypeName expectedTypeName, int expectedBitWidth, boolean expectedNullable, RelDataType actual) {
        if (actual == null) {
            Assert.fail((String)"non-null actual type expected");
        }
        Assert.assertEquals((Object)expectedTypeName, (Object)actual.getSqlTypeName());
        Assert.assertEquals((long)expectedBitWidth, (long)((HazelcastIntegerType)actual).getBitWidth());
        Assert.assertEquals((Object)expectedNullable, (Object)actual.isNullable());
    }
}

