/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.DefaultNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.type.CompactNestedFieldsTest;
import com.hazelcast.jet.sql.impl.type.PortableNestedFieldsTest;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlLazyDeserializationTest {
    private TestHazelcastFactory mockInstanceFactory;
    private HazelcastInstance instance;
    private HazelcastInstance client;
    private InternalSerializationService serializationService;

    @Before
    public void before() {
        Config config = new Config();
        config.getJetConfig().setEnabled(true);
        SerializationConfig serializationConfig = config.getSerializationConfig();
        ClassDefinition officeType = new ClassDefinitionBuilder(1, 3).addLongField("id").addStringField("name").build();
        ClassDefinition organizationType = new ClassDefinitionBuilder(1, 2).addLongField("id").addStringField("name").addPortableField("office", officeType).build();
        ClassDefinition userType = new ClassDefinitionBuilder(1, 1).addLongField("id").addStringField("name").addPortableField("organization", organizationType).build();
        serializationConfig.addClassDefinition(officeType);
        serializationConfig.addClassDefinition(organizationType);
        serializationConfig.addClassDefinition(userType);
        this.mockInstanceFactory = new TestHazelcastFactory();
        this.mockInstanceFactory.withNodeExtensionCustomizer(SerializationServiceMockingNodeExtension::new);
        this.instance = this.mockInstanceFactory.newHazelcastInstance(config);
        this.serializationService = Util.getHazelcastInstanceImpl((HazelcastInstance)this.instance).getSerializationService();
        this.client = this.mockInstanceFactory.newHazelcastClient();
    }

    @After
    public void after() {
        this.mockInstanceFactory.terminateAll();
    }

    @Test
    public void test_compactNestedQueryLazyDeserialization() throws IOException {
        CompactNestedFieldsTest.setupCompactTypesForNestedQuery(this.client);
        ResultCaptor resultCaptor = new ResultCaptor();
        ((InternalSerializationService)Mockito.doAnswer((Answer)resultCaptor).when((Object)this.serializationService)).readAsInternalGenericRecord((Data)ArgumentMatchers.any(Data.class));
        this.client.getSql().execute("INSERT INTO test VALUES (1, 1, 'user1', (1, 'organization1', (1, 'office1')))", new Object[0]);
        SqlTestSupport.assertRowsAnyOrder(this.instance, "SELECT (organization).office.name FROM test", SqlTestSupport.rows(1, "office1"));
        ((InternalSerializationService)Mockito.verify((Object)this.serializationService, (VerificationMode)Mockito.times((int)1))).readAsInternalGenericRecord((Data)ArgumentMatchers.any(Data.class));
        CopyOnWriteArrayList<InternalGenericRecord> results = resultCaptor.getResults();
        Assert.assertEquals((long)3L, (long)results.size());
        ((InternalGenericRecord)Mockito.verify((Object)results.get(0), (VerificationMode)Mockito.times((int)1))).getInternalGenericRecord("organization");
        ((InternalGenericRecord)Mockito.verify((Object)results.get(1), (VerificationMode)Mockito.times((int)1))).getInternalGenericRecord("office");
    }

    @Test
    public void test_portableNestedQueryLazyDeserialization() throws IOException {
        PortableNestedFieldsTest.setupPortableTypesForNestedQuery(this.client);
        ResultCaptor resultCaptor = new ResultCaptor();
        ((InternalSerializationService)Mockito.doAnswer((Answer)resultCaptor).when((Object)this.serializationService)).readAsInternalGenericRecord((Data)ArgumentMatchers.any(Data.class));
        this.client.getSql().execute("INSERT INTO test VALUES (1, 1, 'user1', (1, 'organization1', (1, 'office1')))", new Object[0]);
        SqlTestSupport.assertRowsAnyOrder(this.instance, "SELECT (organization).office.name FROM test", SqlTestSupport.rows(1, "office1"));
        ((InternalSerializationService)Mockito.verify((Object)this.serializationService, (VerificationMode)Mockito.times((int)1))).readAsInternalGenericRecord((Data)ArgumentMatchers.any(Data.class));
        CopyOnWriteArrayList<InternalGenericRecord> results = resultCaptor.getResults();
        Assert.assertEquals((long)3L, (long)results.size());
        ((InternalGenericRecord)Mockito.verify((Object)results.get(0), (VerificationMode)Mockito.times((int)1))).getInternalGenericRecord("organization");
        ((InternalGenericRecord)Mockito.verify((Object)results.get(1), (VerificationMode)Mockito.times((int)1))).getInternalGenericRecord("office");
    }

    private static class ResultCaptor
    implements Answer<InternalGenericRecord> {
        private CopyOnWriteArrayList<InternalGenericRecord> results = new CopyOnWriteArrayList();

        private ResultCaptor() {
        }

        public CopyOnWriteArrayList<InternalGenericRecord> getResults() {
            return this.results;
        }

        public InternalGenericRecord answer(InvocationOnMock invocationOnMock) throws Throwable {
            InternalGenericRecord spiedResult = (InternalGenericRecord)Mockito.spy((Object)((InternalGenericRecord)invocationOnMock.callRealMethod()));
            ((InternalGenericRecord)Mockito.doAnswer((Answer)this).when((Object)spiedResult)).getInternalGenericRecord((String)ArgumentMatchers.any(String.class));
            this.results.add(spiedResult);
            return spiedResult;
        }
    }

    private static class SerializationServiceMockingNodeExtension
    extends DefaultNodeExtension {
        SerializationServiceMockingNodeExtension(Node node) {
            super(node);
        }

        public InternalSerializationService createSerializationService() {
            return (InternalSerializationService)Mockito.spy((Object)super.createSerializationService());
        }
    }
}

