/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.impl.portable.DeserializedPortableGenericRecord;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastSerialClassRunner;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class PortableNestedFieldsTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        Config config = PortableNestedFieldsTest.smallInstanceConfig();
        SerializationConfig serializationConfig = config.getSerializationConfig();
        ClassDefinition officeType = new ClassDefinitionBuilder(1, 3).addLongField("id").addStringField("name").build();
        serializationConfig.addClassDefinition(officeType);
        ClassDefinition organizationType = new ClassDefinitionBuilder(1, 2).addLongField("id").addStringField("name").addPortableField("office", officeType).build();
        serializationConfig.addClassDefinition(organizationType);
        ClassDefinition organizationAndLongType = new ClassDefinitionBuilder(1, 4).addLongField("id").addLongField("l").addPortableField("organization", organizationType).build();
        serializationConfig.addClassDefinition(organizationAndLongType);
        ClassDefinition userType = new ClassDefinitionBuilder(1, 1).addLongField("id").addStringField("name").addPortableField("organization", organizationType).build();
        serializationConfig.addClassDefinition(userType);
        ClassDefinition userType2 = new ClassDefinitionBuilder(1, 5).addLongField("id").addStringField("name").addPortableField("organizationAndLong", organizationAndLongType).build();
        serializationConfig.addClassDefinition(userType2);
        PortableNestedFieldsTest.initialize((int)2, (Config)config);
    }

    static void setupPortableTypesForNestedQuery(HazelcastInstance instance) {
        new SqlTestSupport.SqlType("Office").create(instance);
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("Organization").fields(new String[]{"id BIGINT", "name VARCHAR", "office Office"})).create(instance);
        PortableNestedFieldsTest.createPortableMapping(instance, "test", 1, 1, "id BIGINT", "name VARCHAR", "organization Organization");
    }

    static void createPortableMapping(HazelcastInstance instance, String name, int factoryId, int classId, String ... valueFields) {
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).fields(new String[]{"__key BIGINT"})).fields(valueFields)).options(new Object[]{"keyFormat", "bigint", "valueFormat", "portable", "valuePortableFactoryId", factoryId, "valuePortableClassId", classId})).create(instance);
    }

    private static SqlResult execute(String sql) {
        return PortableNestedFieldsTest.instance().getSql().execute(sql, new Object[0]);
    }

    @Test
    public void test_basicQuerying() {
        PortableNestedFieldsTest.setupPortableTypesForNestedQuery(PortableNestedFieldsTest.instance());
        PortableNestedFieldsTest.execute("INSERT INTO test VALUES (1, 1, 'user1', (1, 'organization1', (1, 'office1')))");
        PortableNestedFieldsTest.assertRowsAnyOrder("SELECT (organization).name FROM test", PortableNestedFieldsTest.rows(1, "organization1"));
        PortableNestedFieldsTest.assertRowsAnyOrder("SELECT (organization).office.name FROM test", PortableNestedFieldsTest.rows(1, "office1"));
    }

    @Test
    public void test_nestedPortablesAreReturnedAsDeserialized() {
        new SqlTestSupport.SqlType("Office").create();
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("Organization").fields(new String[]{"id BIGINT", "name VARCHAR", "office Office"})).create();
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("OrganizationAndLong").fields(new String[]{"id BIGINT", "l BIGINT", "organization Organization"})).create();
        PortableNestedFieldsTest.createPortableMapping(PortableNestedFieldsTest.instance(), "test", 1, 5, "id BIGINT", "name VARCHAR", "organizationAndLong OrganizationAndLong");
        PortableNestedFieldsTest.execute("INSERT INTO test VALUES (1, 1, 'user1', (1, 1, (1, 'organization1', (1, 'office1'))))");
        SqlResult result = PortableNestedFieldsTest.execute("SELECT (organizationAndLong).organization.office FROM test");
        ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
        for (SqlRow row : result) {
            rows.add(row);
        }
        Assert.assertEquals((long)1L, (long)rows.size());
        PortableNestedFieldsTest.assertInstanceOf(DeserializedPortableGenericRecord.class, (Object)((SqlRow)rows.get(0)).getObject(0));
    }

    @Test
    public void test_unknownClassDef_givenColumns() {
        Assertions.assertThatCode(() -> ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType("Foo").fields(new String[]{"column1 INT", "column2 VARCHAR"})).create()).doesNotThrowAnyException();
    }
}

