/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.dataconnection.impl.DataConnectionServiceImpl;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.schema.DataConnectionResolver;
import com.hazelcast.jet.sql.impl.schema.DataConnectionStorage;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DataConnectionResolverTest {
    private DataConnectionResolver dataConnectionResolver;
    @Mock
    SqlConnectorCache connectorCache;
    @Mock
    DataConnectionServiceImpl dataConnectionService;
    @Mock
    private DataConnectionStorage relationsStorage;
    private AutoCloseable openMocks;

    @Before
    public void before() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
        this.dataConnectionResolver = new DataConnectionResolver((InternalDataConnectionService)this.dataConnectionService, this.connectorCache, this.relationsStorage, false);
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    public void when_createDataConnection_then_succeeds() {
        DataConnectionCatalogEntry dataConnectionCatalogEntry = DataConnectionResolverTest.dataConnection();
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent(dataConnectionCatalogEntry.name(), dataConnectionCatalogEntry)).willReturn((Object)true);
        this.dataConnectionResolver.createDataConnection(dataConnectionCatalogEntry, false, false);
        ((DataConnectionStorage)Mockito.verify((Object)this.relationsStorage)).putIfAbsent((String)ArgumentMatchers.eq((Object)dataConnectionCatalogEntry.name()), (DataConnectionCatalogEntry)ArgumentMatchers.isA(DataConnectionCatalogEntry.class));
    }

    @Test
    public void when_createsDataConnectionIfNotExists_then_succeeds() {
        DataConnectionCatalogEntry dataConnectionCatalogEntry = DataConnectionResolverTest.dataConnection();
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent(dataConnectionCatalogEntry.name(), dataConnectionCatalogEntry)).willReturn((Object)true);
        this.dataConnectionResolver.createDataConnection(dataConnectionCatalogEntry, false, true);
        ((DataConnectionStorage)Mockito.verify((Object)this.relationsStorage)).putIfAbsent((String)ArgumentMatchers.eq((Object)dataConnectionCatalogEntry.name()), (DataConnectionCatalogEntry)ArgumentMatchers.isA(DataConnectionCatalogEntry.class));
    }

    @Test
    public void when_createsDuplicateDataConnectionIfReplace_then_succeeds() {
        DataConnectionCatalogEntry dataConnectionCatalogEntry = DataConnectionResolverTest.dataConnection();
        this.dataConnectionResolver.createDataConnection(dataConnectionCatalogEntry, true, false);
        ((DataConnectionStorage)Mockito.verify((Object)this.relationsStorage)).put((String)ArgumentMatchers.eq((Object)dataConnectionCatalogEntry.name()), (DataConnectionCatalogEntry)ArgumentMatchers.isA(DataConnectionCatalogEntry.class));
    }

    @Test
    public void when_createsDuplicateDataConnectionIfReplaceAndIfNotExists_then_succeeds() {
        DataConnectionCatalogEntry dataConnectionCatalogEntry = DataConnectionResolverTest.dataConnection();
        this.dataConnectionResolver.createDataConnection(dataConnectionCatalogEntry, false, true);
        ((DataConnectionStorage)Mockito.verify((Object)this.relationsStorage)).putIfAbsent((String)ArgumentMatchers.eq((Object)dataConnectionCatalogEntry.name()), (DataConnectionCatalogEntry)ArgumentMatchers.isA(DataConnectionCatalogEntry.class));
    }

    @Test
    public void when_createsDuplicateDataConnection_then_throws() {
        DataConnectionCatalogEntry dataConnectionCatalogEntry = DataConnectionResolverTest.dataConnection();
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent((String)ArgumentMatchers.eq((Object)dataConnectionCatalogEntry.name()), (DataConnectionCatalogEntry)ArgumentMatchers.isA(DataConnectionCatalogEntry.class))).willReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.dataConnectionResolver.createDataConnection(dataConnectionCatalogEntry, false, false)).isInstanceOf(QueryException.class)).hasMessageContaining("Data connection already exists: " + dataConnectionCatalogEntry.name());
    }

    @Test
    public void when_removesNonExistingDataConnection_then_throws() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeDataConnection(name)).willReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.dataConnectionResolver.removeDataConnection(name, false)).isInstanceOf(QueryException.class)).hasMessageContaining("Data connection does not exist: " + name);
    }

    @Test
    public void when_removesNonExistingDataConnectionWithIfExists_then_succeeds() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeDataConnection(name)).willReturn((Object)false);
        this.dataConnectionResolver.removeDataConnection(name, true);
    }

    private static DataConnectionCatalogEntry dataConnection() {
        return new DataConnectionCatalogEntry();
    }
}

