/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.processors.SqlHashJoinP;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlHashJoinPTest
extends SqlTestSupport {
    private static final int LOW_PRIORITY = 10;
    private static final int HIGH_PRIORITY = 1;
    private static final Expression<Boolean> TRUE_PREDICATE = ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN);
    private static final Expression<Boolean> LEFT_LT_RIGHT = ComparisonPredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ColumnExpression.create((int)2, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.LESS_THAN);
    private static final Expression<Boolean> LEFT_GT_RIGHT = ComparisonPredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ColumnExpression.create((int)2, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.GREATER_THAN);

    @BeforeClass
    public static void beforeClass() {
        SqlHashJoinPTest.initialize((int)2, null);
    }

    @Test
    public void test_innerJoin() {
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, 2, new int[]{0}, new int[]{0}, Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1"), SqlHashJoinPTest.jetRow(2, "left-2")), Arrays.asList(SqlHashJoinPTest.jetRow(2, "right-2"), SqlHashJoinPTest.jetRow(3, "right-3")), Collections.singletonList(SqlHashJoinPTest.jetRow(2, "left-2", 2, "right-2")));
    }

    @Test
    public void test_innerNonEquiJoin() {
        this.runTest(JoinRelType.INNER, LEFT_LT_RIGHT, 2, new int[0], new int[0], Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1"), SqlHashJoinPTest.jetRow(2, "left-2")), Arrays.asList(SqlHashJoinPTest.jetRow(2, "right-2"), SqlHashJoinPTest.jetRow(3, "right-3")), Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1", 2, "right-2"), SqlHashJoinPTest.jetRow(1, "left-1", 3, "right-3"), SqlHashJoinPTest.jetRow(2, "left-2", 3, "right-3")));
    }

    @Test
    public void test_leftEquiJoin() {
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, 2, new int[]{0}, new int[]{0}, Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1"), SqlHashJoinPTest.jetRow(2, "left-2")), Arrays.asList(SqlHashJoinPTest.jetRow(2, "right-2"), SqlHashJoinPTest.jetRow(3, "right-3")), Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1", null, null), SqlHashJoinPTest.jetRow(2, "left-2", 2, "right-2")));
    }

    @Test
    public void test_leftNonEquiJoin() {
        this.runTest(JoinRelType.LEFT, LEFT_GT_RIGHT, 2, new int[0], new int[0], Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1"), SqlHashJoinPTest.jetRow(2, "left-2")), Arrays.asList(SqlHashJoinPTest.jetRow(2, "right-2"), SqlHashJoinPTest.jetRow(3, "right-3")), Arrays.asList(SqlHashJoinPTest.jetRow(1, "left-1", null, null), SqlHashJoinPTest.jetRow(2, "left-2", null, null)));
    }

    private void runTest(JoinRelType joinType, Expression<Boolean> nonEquiCondition, int rightInputColumnCount, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices, List<JetSqlRow> leftInput, List<JetSqlRow> rightInput, List<JetSqlRow> output) {
        SqlHashJoinP.HashJoinProcessorSupplier processor = SqlHashJoinP.supplier((JetJoinInfo)new JetJoinInfo(joinType, leftEquiJoinIndices, rightEquiJoinIndices, nonEquiCondition, null), (int)rightInputColumnCount);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)processor)).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).inputs(Arrays.asList(leftInput, rightInput), new int[]{10, 1}).hazelcastInstance(SqlHashJoinPTest.instance()).outputChecker(SqlTestSupport::compareRowLists).disableSnapshots().expectOutput(output);
    }
}

