/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.TestTableResolver;
import com.hazelcast.jet.sql.impl.parse.QueryParseResult;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ParserNameResolutionTest {
    private static OptimizerContext context;
    private static final String BAD_CATALOG = "badCatalog";
    private static final String SCHEMA_1 = "mySchema1";
    private static final String SCHEMA_2 = "mySchema2";
    private static final String BAD_SCHEMA = "badSchema";
    private static final String TABLE_1 = "myTable1";
    private static final String TABLE_2 = "myTable2";
    private static final String BAD_TABLE = "badTable";
    private static final String FIELD_1 = "myField1";
    private static final String FIELD_2 = "myField2";
    private static final String BAD_FIELD = "badField";
    private static final String TABLE_1_FQN;
    private static final String TABLE_2_FQN;

    @BeforeClass
    public static void beforeClass() {
        context = ParserNameResolutionTest.createContext();
    }

    @Test
    public void testNameResolution() {
        ParserNameResolutionTest.checkSuccess(FIELD_1, TABLE_1_FQN, SCHEMA_1, TABLE_1);
        ParserNameResolutionTest.checkSuccess(FIELD_1, TABLE_1_FQN, "hazelcast", SCHEMA_1, TABLE_1);
        ParserNameResolutionTest.checkSuccess(FIELD_2, TABLE_2_FQN, TABLE_2);
        ParserNameResolutionTest.checkSuccess(FIELD_2, TABLE_2_FQN, SCHEMA_2, TABLE_2);
        ParserNameResolutionTest.checkSuccess(FIELD_2, TABLE_2_FQN, "hazelcast", SCHEMA_2, TABLE_2);
        ParserNameResolutionTest.checkSuccess(context, FIELD_1, TABLE_1_FQN, TABLE_1);
        ParserNameResolutionTest.checkFailure(ParserNameResolutionTest.errorColumnNotFound(BAD_FIELD), BAD_FIELD, SCHEMA_1, TABLE_1);
        ParserNameResolutionTest.checkFailure(1010, ParserNameResolutionTest.errorObjectNotFound(BAD_TABLE), BAD_FIELD, BAD_TABLE);
        ParserNameResolutionTest.checkFailure(1010, ParserNameResolutionTest.errorObjectNotFoundWithin(BAD_TABLE, "hazelcast", SCHEMA_1), BAD_FIELD, SCHEMA_1, BAD_TABLE);
        ParserNameResolutionTest.checkFailure(1010, ParserNameResolutionTest.errorObjectNotFoundWithin(BAD_TABLE, "hazelcast", SCHEMA_1), BAD_FIELD, "hazelcast", SCHEMA_1, BAD_TABLE);
        ParserNameResolutionTest.checkFailure(1010, ParserNameResolutionTest.errorObjectNotFound(BAD_SCHEMA), BAD_FIELD, BAD_SCHEMA, BAD_TABLE);
        ParserNameResolutionTest.checkFailure(1010, ParserNameResolutionTest.errorObjectNotFoundWithin(BAD_SCHEMA, "hazelcast"), BAD_FIELD, "hazelcast", BAD_SCHEMA, BAD_TABLE);
        ParserNameResolutionTest.checkFailure(1010, ParserNameResolutionTest.errorObjectNotFound(BAD_CATALOG), BAD_FIELD, BAD_CATALOG, BAD_SCHEMA, BAD_TABLE);
    }

    private static void checkSuccess(String fieldName, String tableFqn, String ... tableComponents) {
        ParserNameResolutionTest.checkSuccess(context, fieldName, tableFqn, tableComponents);
    }

    private static void checkSuccess(OptimizerContext context, String fieldName, String tableFqn, String ... tableComponents) {
        QueryParseResult res = context.parse(ParserNameResolutionTest.composeSelect(fieldName, tableComponents));
        SqlSelect select = (SqlSelect)res.getNode();
        SqlNodeList selectList = select.getSelectList();
        Assert.assertEquals((long)1L, (long)selectList.size());
        SqlIdentifier fieldIdentifier = (SqlIdentifier)selectList.get(0);
        Assert.assertEquals((Object)SqlIdentifier.getString(Arrays.asList(ParserNameResolutionTest.last(tableComponents), fieldName)), (Object)fieldIdentifier.toString());
        SqlCall from = (SqlCall)select.getFrom();
        Assert.assertEquals((Object)SqlKind.AS, (Object)from.getKind());
        Assert.assertEquals((Object)tableFqn, (Object)from.operand(0).toString());
        Assert.assertEquals((Object)ParserNameResolutionTest.last(tableComponents), (Object)from.operand(1).toString());
    }

    private static void checkFailure(String errorMessage, String fieldName, String ... tableComponents) {
        ParserNameResolutionTest.checkFailure(1008, errorMessage, fieldName, tableComponents);
    }

    private static void checkFailure(int errorCode, String errorMessage, String fieldName, String ... tableComponents) {
        try {
            context.parse(ParserNameResolutionTest.composeSelect(fieldName, tableComponents));
            Assert.fail();
        }
        catch (QueryException e) {
            Assert.assertEquals((long)errorCode, (long)e.getCode());
            Throwable cause = e.getCause();
            Assert.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().endsWith(errorMessage));
        }
    }

    private static String errorColumnNotFound(String columnName) {
        return "Column '" + columnName + "' not found in any table";
    }

    private static String errorObjectNotFound(String tableName) {
        return "Object '" + tableName + "' not found, did you forget to CREATE MAPPING?";
    }

    private static String errorObjectNotFoundWithin(String tableName, String ... schemaComponents) {
        return "Object '" + tableName + "' not found within '" + SqlIdentifier.getString(Arrays.asList(schemaComponents)) + "', did you forget to CREATE MAPPING?";
    }

    private static String composeSelect(String fieldName, String ... tableComponents) {
        StringBuilder res = new StringBuilder("SELECT " + fieldName + " FROM ");
        boolean first = true;
        for (String tableComponent : tableComponents) {
            if (first) {
                first = false;
            } else {
                res.append(".");
            }
            res.append(tableComponent);
        }
        return res.toString();
    }

    private static OptimizerContext createContext() {
        PartitionedMapTable table1 = new PartitionedMapTable(SCHEMA_1, TABLE_1, TABLE_1, Arrays.asList(ParserNameResolutionTest.field(FIELD_1), ParserNameResolutionTest.field(FIELD_2)), (TableStatistics)new ConstantTableStatistics(100L), null, null, null, null, null, false, Collections.emptyList(), false);
        PartitionedMapTable table2 = new PartitionedMapTable(SCHEMA_2, TABLE_2, TABLE_2, Arrays.asList(ParserNameResolutionTest.field(FIELD_1), ParserNameResolutionTest.field(FIELD_2)), (TableStatistics)new ConstantTableStatistics(100L), null, null, null, null, null, false, Collections.emptyList(), false);
        TestTableResolver resolver1 = TestTableResolver.create(SCHEMA_1, new Table[]{table1});
        TestTableResolver resolver2 = TestTableResolver.create(SCHEMA_2, new Table[]{table2});
        List<TableResolver> tableResolvers = Arrays.asList(resolver1, resolver2);
        List searchPaths = QueryUtils.prepareSearchPaths(Collections.emptyList(), tableResolvers);
        return OptimizerContext.create((SqlCatalog)new SqlCatalog(tableResolvers), (List)searchPaths, Collections.emptyList(), name -> null, null, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
    }

    private static <E> E last(E[] array) {
        return array[array.length - 1];
    }

    private static TableField field(String name) {
        return new Field(name, QueryDataType.INT, false);
    }

    static {
        TABLE_1_FQN = SqlIdentifier.getString(Arrays.asList("hazelcast", SCHEMA_1, TABLE_1));
        TABLE_2_FQN = SqlIdentifier.getString(Arrays.asList("hazelcast", SCHEMA_2, TABLE_2));
    }

    private static class Field
    extends TableField {
        private Field(String name, QueryDataType type, boolean hidden) {
            super(name, type, hidden);
        }
    }
}

