/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.calcite.parser.HazelcastSqlParser;
import com.hazelcast.jet.sql.impl.parse.SqlCreateIndex;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlCreateView;
import com.hazelcast.jet.sql.impl.parse.SqlDropIndex;
import com.hazelcast.jet.sql.impl.parse.SqlDropMapping;
import com.hazelcast.jet.sql.impl.parse.SqlDropView;
import com.hazelcast.jet.sql.impl.parse.SqlExtendedInsert;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.Casing;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.Quoting;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParseException;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class HazelcastSqlParserTest {
    private static final SqlParser.Config CONFIG = SqlParser.configBuilder().setCaseSensitive(true).setUnquotedCasing(Casing.UNCHANGED).setQuotedCasing(Casing.UNCHANGED).setQuoting(Quoting.DOUBLE_QUOTE).setParserFactory(HazelcastSqlParser.FACTORY).build();

    /*
     * Exception decompiling
     */
    @Test
    @Parameters(value={"true, false", "false, true"})
    public void test_createMapping(boolean replace, boolean ifNotExists) throws SqlParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_createIndex(boolean ifNotExists) throws SqlParseException {
        String sql = "CREATE INDEX " + (ifNotExists ? "IF NOT EXISTS " : "") + "index_name ON mapping_name (column_name1, column_name2) TYPE SORTED OPTIONS ('option.key'='option.value')";
        SqlNode parsedNode = HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((Object)parsedNode).isInstanceOf(SqlCreateIndex.class);
        SqlCreateIndex node = (SqlCreateIndex)parsedNode;
        Assertions.assertThat((String)node.mapName()).isEqualTo("mapping_name");
        Assertions.assertThat((String)node.indexName()).isEqualTo("index_name");
        Assertions.assertThat((Comparable)node.type()).isEqualTo((Object)IndexType.SORTED);
        Assertions.assertThat((String)((String)node.columns().get(0))).isEqualTo("column_name1");
        Assertions.assertThat((Map)node.options()).isEqualTo((Object)ImmutableMap.of((Object)"option.key", (Object)"option.value"));
        Assertions.assertThat((boolean)node.ifNotExists()).isEqualTo(ifNotExists);
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_createIndexWithoutOptions(boolean ifNotExists) throws SqlParseException {
        String sql = "CREATE INDEX " + (ifNotExists ? "IF NOT EXISTS " : "") + "index_name ON map_name (column_name1, column_name2) TYPE SORTED ";
        SqlNode parsedNode = HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((Object)parsedNode).isInstanceOf(SqlCreateIndex.class);
        SqlCreateIndex node = (SqlCreateIndex)parsedNode;
        Assertions.assertThat((String)node.mapName()).isEqualTo("map_name");
        Assertions.assertThat((String)node.indexName()).isEqualTo("index_name");
        Assertions.assertThat((Comparable)node.type()).isEqualTo((Object)IndexType.SORTED);
        Assertions.assertThat((String)((String)node.columns().get(0))).isEqualTo("column_name1");
        Assertions.assertThat((boolean)node.ifNotExists()).isEqualTo(ifNotExists);
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_createIndexRequiresMapName(boolean ifNotExists) {
        String sql = "CREATE INDEX " + (ifNotExists ? "IF NOT EXISTS " : "") + "index_name ";
        Assertions.assertThatThrownBy(() -> HazelcastSqlParserTest.parse(sql)).hasMessageContaining("Encountered \"<EOF>\" at line 1").hasMessageContaining("\"ON\" ...");
    }

    @Test
    public void test_createExternalMapping() throws SqlParseException {
        String sql = "CREATE EXTERNAL MAPPING mapping_name TYPE mapping_type";
        SqlNode node = HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((Object)node).isInstanceOf(SqlCreateMapping.class);
    }

    @Test
    public void test_createMappingWithExternalName() throws SqlParseException {
        String sql = "CREATE MAPPING mapping_name EXTERNAL NAME \"external.mapping.name\"TYPE mapping_type";
        SqlCreateMapping node = (SqlCreateMapping)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((String)node.nameWithoutSchema()).isEqualTo("mapping_name");
        Assertions.assertThat((Object[])node.externalName()).containsExactly((Object[])new String[]{"external.mapping.name"});
    }

    @Test
    public void test_createMappingWithExternalNameWithSchema() throws SqlParseException {
        String sql = "CREATE MAPPING mapping_name EXTERNAL NAME \"external.schema\".\"external.mapping.name\"TYPE mapping_type";
        SqlCreateMapping node = (SqlCreateMapping)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((String)node.nameWithoutSchema()).isEqualTo("mapping_name");
        Assertions.assertThat((Object[])node.externalName()).containsExactly((Object[])new String[]{"external.schema", "external.mapping.name"});
    }

    @Test
    public void test_createMappingWithSchema() throws SqlParseException {
        String sql = "CREATE MAPPING public.mapping_name TYPE mapping_type";
        SqlCreateMapping node = (SqlCreateMapping)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((String)node.nameWithoutSchema()).isEqualTo("mapping_name");
        Assertions.assertThat((Object[])node.externalName()).containsExactly((Object[])new String[]{"mapping_name"});
    }

    @Test
    public void test_createMappingRequiresColumns() {
        String sql = "CREATE MAPPING mapping_name ()TYPE mapping_type";
        Assertions.assertThatThrownBy(() -> HazelcastSqlParserTest.parse(sql)).hasMessageContaining("Encountered \")\" at line 1, column 30");
    }

    @Test
    public void test_createMappingRequiresColumnType() {
        String sql = "CREATE MAPPING mapping_name (column_name)TYPE mapping_type";
        Assertions.assertThatThrownBy(() -> HazelcastSqlParserTest.parse(sql)).hasMessageContaining("Encountered \")\" at line 1, column 41");
    }

    @Test
    public void test_createMappingRequiresMappingType() {
        String sql = "CREATE MAPPING mapping_name (column_name INT)";
        Assertions.assertThatThrownBy(() -> HazelcastSqlParserTest.parse(sql)).hasMessageContaining("Encountered \"<EOF>\" at line 1, column 45");
    }

    @Test
    public void test_createMappingRequiresMappingTypeSimpleIdentifier() {
        String sql = "CREATE MAPPING mapping_name TYPE mapping.type";
        Assertions.assertThatThrownBy(() -> HazelcastSqlParserTest.parse(sql)).hasMessageContaining("Encountered \".\" at line 1, column 41");
    }

    @Test
    @Parameters(value={"false", "true"})
    public void test_dropMapping(boolean ifExists) throws SqlParseException {
        String sql = "DROP MAPPING " + (ifExists ? "IF EXISTS " : "") + "mapping_name";
        SqlDropMapping node = (SqlDropMapping)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((String)node.nameWithoutSchema()).isEqualTo("mapping_name");
        Assertions.assertThat((boolean)node.ifExists()).isEqualTo(ifExists);
    }

    @Test
    @Parameters(value={"false", "true"})
    public void test_dropIndex(boolean ifExists) throws SqlParseException {
        String sql = "DROP INDEX " + (ifExists ? "IF EXISTS " : "") + "index_name ON object_name";
        SqlDropIndex node = (SqlDropIndex)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((String)node.indexName()).isEqualTo("index_name");
        Assertions.assertThat((String)node.objectName()).isEqualTo("object_name");
        Assertions.assertThat((boolean)node.ifExists()).isEqualTo(ifExists);
    }

    @Test
    public void test_dropExternalMapping() throws SqlParseException {
        String sql = "DROP EXTERNAL MAPPING mapping_name";
        SqlNode node = HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((Object)node).isInstanceOf(SqlDropMapping.class);
    }

    @Test
    public void test_dropExternalMappingWithSchema() throws SqlParseException {
        String sql = "DROP MAPPING some_schema.mapping_name";
        SqlDropMapping node = (SqlDropMapping)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((String)node.nameWithoutSchema()).isEqualTo("mapping_name");
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_createView(boolean toReplace) throws SqlParseException {
        String sql = "CREATE  " + (toReplace ? " OR REPLACE " : "") + "VIEW view_name AS SELECT * FROM map";
        SqlNode parsedNode = HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((Object)parsedNode).isInstanceOf(SqlCreateView.class);
        SqlCreateView node = (SqlCreateView)parsedNode;
        Assertions.assertThat((String)node.name()).isEqualTo("view_name");
        Assertions.assertThat((Object)node.getQuery()).isInstanceOf(SqlSelect.class);
        Assertions.assertThat((boolean)node.getReplace()).isEqualTo(toReplace);
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_createViewRequiresQuery(boolean toReplace) throws SqlParseException {
        String sql = "CREATE  " + (toReplace ? " OR REPLACE " : "") + "VIEW view_name ";
        Assertions.assertThatThrownBy(() -> HazelcastSqlParserTest.parse(sql)).hasMessageContaining("Encountered \"<EOF>\" at line 1");
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_dropView(boolean ifExists) throws SqlParseException {
        String sql = "DROP  VIEW " + (ifExists ? " IF EXISTS " : "") + "view_name ";
        SqlNode parsedNode = HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((Object)parsedNode).isInstanceOf(SqlDropView.class);
        SqlDropView node = (SqlDropView)parsedNode;
        Assertions.assertThat((String)node.viewName()).isEqualTo("view_name");
        Assertions.assertThat((boolean)node.ifExists()).isEqualTo(ifExists);
    }

    @Test
    public void test_sinkIntoWithValues() throws SqlParseException {
        String sql = "SINK INTO partitioned.t (id, name) VALUES (1, '1')";
        SqlExtendedInsert node = (SqlExtendedInsert)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((List)node.tableNames()).isEqualTo(Arrays.asList("partitioned", "t"));
        Assertions.assertThat((Comparable)node.getSource().getKind()).isEqualTo((Object)SqlKind.VALUES);
        Assertions.assertThat((List)node.getTargetColumnList()).hasSize(2);
    }

    @Test
    public void test_sinkIntoWithSelect() throws SqlParseException {
        String sql = "SINK INTO t SELECT * FROM s";
        SqlExtendedInsert node = (SqlExtendedInsert)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((List)node.tableNames()).isEqualTo(Collections.singletonList("t"));
        Assertions.assertThat((Comparable)node.getSource().getKind()).isEqualTo((Object)SqlKind.SELECT);
        Assertions.assertThat((List)node.getTargetColumnList()).isNullOrEmpty();
    }

    @Test
    public void test_insertIntoWithValues() throws SqlParseException {
        String sql = "INSERT INTO partitioned.t (id, name) VALUES (1, '1')";
        SqlExtendedInsert node = (SqlExtendedInsert)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((List)node.tableNames()).isEqualTo(Arrays.asList("partitioned", "t"));
        Assertions.assertThat((Comparable)node.getSource().getKind()).isEqualTo((Object)SqlKind.VALUES);
        Assertions.assertThat((List)node.getTargetColumnList()).hasSize(2);
    }

    @Test
    public void test_insertIntoWithSelect() throws SqlParseException {
        String sql = "INSERT INTO t SELECT * FROM s";
        SqlExtendedInsert node = (SqlExtendedInsert)HazelcastSqlParserTest.parse(sql);
        Assertions.assertThat((List)node.tableNames()).isEqualTo(Collections.singletonList("t"));
        Assertions.assertThat((Comparable)node.getSource().getKind()).isEqualTo((Object)SqlKind.SELECT);
        Assertions.assertThat((List)node.getTargetColumnList()).isNullOrEmpty();
    }

    private static SqlNode parse(String sql) throws SqlParseException {
        return SqlParser.create((String)sql, (SqlParser.Config)CONFIG).parseStmt();
    }
}

