/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.test.TestAbstractSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateAccumulateByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.AggregateCombineByKeyPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.CalcPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinHashPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.JoinNestedLoopPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableStatistic;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistic;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class PhysicalJoinTest
extends OptimizerTestSupport {
    private TableResolver resolver;

    @BeforeClass
    public static void beforeClass() throws Exception {
        PhysicalJoinTest.initialize((int)1, null);
    }

    @Before
    public void setUp() throws Exception {
        NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)PhysicalJoinTest.instance());
        this.resolver = new TableResolverImpl((NodeEngine)nodeEngine, new RelationsStorage((NodeEngine)nodeEngine), new SqlConnectorCache((NodeEngine)nodeEngine));
    }

    @Test
    public void when_isSimpleJoin_then_useNestedLoopJoin() {
        HazelcastTable tableLeft = PhysicalJoinTest.partitionedTable("l", Arrays.asList(PhysicalJoinTest.field(QueryPath.KEY, QueryDataType.INT), PhysicalJoinTest.field(QueryPath.VALUE, QueryDataType.INT)), 1L);
        HazelcastTable tableRight = PhysicalJoinTest.partitionedTable("r", Arrays.asList(PhysicalJoinTest.field(QueryPath.KEY, QueryDataType.INT), PhysicalJoinTest.field(QueryPath.VALUE, QueryDataType.INT)), 1L);
        String query = "SELECT * FROM l JOIN r ON l.__key = r.__key";
        PhysicalJoinTest.assertPlan((RelNode)this.optimizePhysical(query, Arrays.asList(QueryDataType.INT, QueryDataType.INT, QueryDataType.INT, QueryDataType.INT), tableLeft, tableRight).getPhysical(), PhysicalJoinTest.plan(PhysicalJoinTest.planRow(0, JoinNestedLoopPhysicalRel.class), PhysicalJoinTest.planRow(1, FullScanPhysicalRel.class), PhysicalJoinTest.planRow(1, FullScanPhysicalRel.class)));
    }

    @Test
    public void when_rightChildIsNotTableScan_then_useHashJoin() {
        HazelcastTable tableLeft = PhysicalJoinTest.partitionedTable("l", Arrays.asList(PhysicalJoinTest.field(QueryPath.KEY, QueryDataType.INT), PhysicalJoinTest.field(QueryPath.VALUE, QueryDataType.INT)), 1L);
        HazelcastTable tableRight = PhysicalJoinTest.partitionedTable("r", Arrays.asList(PhysicalJoinTest.field(QueryPath.KEY, QueryDataType.INT), PhysicalJoinTest.field(QueryPath.VALUE, QueryDataType.INT)), 1L);
        String query = "SELECT * FROM l WHERE EXISTS (SELECT 1 FROM r WHERE l.__key = r.__key)";
        PhysicalJoinTest.assertPlan((RelNode)this.optimizePhysical(query, Arrays.asList(new QueryDataType[0]), tableLeft, tableRight).getPhysical(), PhysicalJoinTest.plan(PhysicalJoinTest.planRow(0, CalcPhysicalRel.class), PhysicalJoinTest.planRow(1, JoinHashPhysicalRel.class), PhysicalJoinTest.planRow(2, FullScanPhysicalRel.class), PhysicalJoinTest.planRow(2, AggregateCombineByKeyPhysicalRel.class), PhysicalJoinTest.planRow(3, AggregateAccumulateByKeyPhysicalRel.class), PhysicalJoinTest.planRow(4, FullScanPhysicalRel.class)));
    }

    @Ignore(value="Support streaming tables with watermarks in OptimizerTestSupport")
    @Test
    public void when_bothInputsAreStreamScan_then_useS2SJoin() {
        String leftStream = "l";
        TestStreamSqlConnector.create(PhysicalJoinTest.instance().getSql(), leftStream, Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP), new Object[][]{PhysicalJoinTest.row(1, PhysicalJoinTest.timestamp(1L))});
        String rightStream = "r";
        TestStreamSqlConnector.create(PhysicalJoinTest.instance().getSql(), rightStream, Arrays.asList("x", "y"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP), new Object[][]{PhysicalJoinTest.row(1, PhysicalJoinTest.timestamp(1L))});
        PhysicalJoinTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(0));
        PhysicalJoinTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(1));
        HazelcastTable tableLeft = PhysicalJoinTest.streamingTable((Table)this.resolver.getTables().get(0));
        HazelcastTable tableRight = PhysicalJoinTest.streamingTable((Table)this.resolver.getTables().get(1));
        String query = "SELECT * FROM l JOIN r ON l.b = r.y";
        PhysicalJoinTest.assertPlan((RelNode)this.optimizePhysical(query, List.of(), tableLeft, tableRight).getPhysical(), PhysicalJoinTest.plan(PhysicalJoinTest.planRow(0, StreamToStreamJoinPhysicalRel.class), PhysicalJoinTest.planRow(1, FullScanPhysicalRel.class), PhysicalJoinTest.planRow(1, FullScanPhysicalRel.class)));
    }

    private static HazelcastTable streamingTable(Table table) {
        return new HazelcastTable(table, (Statistic)new HazelcastTableStatistic(1L));
    }
}

