/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.test.TestAbstractSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.DropLateItemsLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMetadataQuery;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalCalc;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CalcDropLateItemsTransposeTest
extends OptimizerTestSupport {
    private TableResolver resolver;

    @BeforeClass
    public static void beforeClass() {
        CalcDropLateItemsTransposeTest.initialize((int)1, null);
    }

    @Before
    public void setUp() throws Exception {
        NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)CalcDropLateItemsTransposeTest.instance());
        this.resolver = new TableResolverImpl((NodeEngine)nodeEngine, new RelationsStorage((NodeEngine)nodeEngine), new SqlConnectorCache((NodeEngine)nodeEngine));
        String stream = "stream1";
        TestStreamSqlConnector.create(CalcDropLateItemsTransposeTest.instance().getSql(), stream, Arrays.asList("a", "b", "c"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.VARCHAR), new Object[][]{CalcDropLateItemsTransposeTest.row(1, CalcDropLateItemsTransposeTest.timestamp(1L), "1")});
    }

    @Test
    public void given_calcAndDropItemsRelTransposes_whenNoProjectPermutes_then_success() {
        String sql = "SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream1, DESCRIPTOR(b), INTERVAL '0.001' SECOND))";
        CalcDropLateItemsTransposeTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(0));
        HazelcastTable streamingTable = CalcDropLateItemsTransposeTest.streamingTable((Table)this.resolver.getTables().get(0), 1L);
        RelNode node = this.preOptimize(sql, streamingTable);
        CalcDropLateItemsTransposeTest.assertPlan(node, CalcDropLateItemsTransposeTest.plan(CalcDropLateItemsTransposeTest.planRow(0, LogicalTableFunctionScan.class), CalcDropLateItemsTransposeTest.planRow(1, LogicalTableScan.class)));
        LogicalRel logicalRel = this.optimizeLogical(sql, streamingTable);
        CalcDropLateItemsTransposeTest.assertPlan((RelNode)logicalRel, CalcDropLateItemsTransposeTest.plan(CalcDropLateItemsTransposeTest.planRow(0, DropLateItemsLogicalRel.class), CalcDropLateItemsTransposeTest.planRow(1, FullScanLogicalRel.class)));
        CalcDropLateItemsTransposeTest.assertRowsEventuallyInAnyOrder(sql, List.of(new SqlTestSupport.Row(1, CalcDropLateItemsTransposeTest.timestamp(1L), "1")));
    }

    @Test
    public void given_calcAndDropItemsRelTransposes_whenProjectPermutes_then_success() {
        String sql = "SELECT c, a, b, c FROM TABLE(IMPOSE_ORDER(TABLE stream1, DESCRIPTOR(b), INTERVAL '0.001' SECOND))";
        CalcDropLateItemsTransposeTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(0));
        HazelcastTable streamingTable = CalcDropLateItemsTransposeTest.streamingTable((Table)this.resolver.getTables().get(0), 1L);
        RelNode node = this.preOptimize(sql, streamingTable);
        CalcDropLateItemsTransposeTest.assertPlan(node, CalcDropLateItemsTransposeTest.plan(CalcDropLateItemsTransposeTest.planRow(0, LogicalCalc.class), CalcDropLateItemsTransposeTest.planRow(1, LogicalTableFunctionScan.class), CalcDropLateItemsTransposeTest.planRow(2, LogicalTableScan.class)));
        LogicalRel logicalRel = this.optimizeLogical(sql, streamingTable);
        CalcDropLateItemsTransposeTest.assertPlan((RelNode)logicalRel, CalcDropLateItemsTransposeTest.plan(CalcDropLateItemsTransposeTest.planRow(0, DropLateItemsLogicalRel.class), CalcDropLateItemsTransposeTest.planRow(1, FullScanLogicalRel.class)));
        HazelcastRelMetadataQuery query = HazelcastRelMetadataQuery.reuseOrCreate((RelMetadataQuery)RelMetadataQuery.instance());
        Set wmIndexes = query.extractWatermarkedFields((RelNode)logicalRel).getFieldIndexes();
        Assertions.assertThat((int)wmIndexes.size()).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)wmIndexes.iterator().next())).isEqualTo(2);
        CalcDropLateItemsTransposeTest.assertRowsEventuallyInAnyOrder(sql, Collections.singletonList(new SqlTestSupport.Row("1", 1, CalcDropLateItemsTransposeTest.timestamp(1L), "1")));
    }
}

