/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.CalciteSqlOptimizerImpl;
import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.connector.generator.StreamSqlConnector;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRules;
import com.hazelcast.jet.sql.impl.opt.logical.SelectByKeyMapLogicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRules;
import com.hazelcast.jet.sql.impl.parse.QueryParseResult;
import com.hazelcast.jet.sql.impl.schema.HazelcastSchema;
import com.hazelcast.jet.sql.impl.schema.HazelcastSchemaUtils;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableStatistic;
import com.hazelcast.jet.sql.impl.validate.param.StrictParameterConverter;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepProgram;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.schema.Schema;
import com.hazelcast.shaded.org.apache.calcite.schema.Statistic;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlExplainLevel;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.tools.RuleSets;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.SqlServiceImpl;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;

public abstract class OptimizerTestSupport
extends SqlTestSupport {
    protected RelNode preOptimize(String sql, HazelcastTable ... tables) {
        HazelcastSchema schema = OptimizerTestSupport.schema(tables);
        OptimizerContext context = OptimizerTestSupport.context(schema, new QueryDataType[0]);
        return OptimizerTestSupport.preOptimizeInternal(sql, context);
    }

    protected LogicalRel optimizeLogical(String sql, HazelcastTable ... tables) {
        HazelcastSchema schema = OptimizerTestSupport.schema(tables);
        OptimizerContext context = OptimizerTestSupport.context(schema, new QueryDataType[0]);
        return OptimizerTestSupport.optimizeLogicalInternal(sql, context);
    }

    protected LogicalRel optimizeLogical(String sql, boolean requiresJob, HazelcastTable ... tables) {
        HazelcastSchema schema = OptimizerTestSupport.schema(tables);
        OptimizerContext context = OptimizerTestSupport.context(schema, new QueryDataType[0]);
        context.setRequiresJob(requiresJob);
        return OptimizerTestSupport.optimizeLogicalInternal(sql, context);
    }

    protected Result optimizePhysical(String sql, List<QueryDataType> parameterTypes, HazelcastTable ... tables) {
        HazelcastSchema schema = OptimizerTestSupport.schema(tables);
        OptimizerContext context = OptimizerTestSupport.context(schema, parameterTypes.toArray(new QueryDataType[0]));
        return OptimizerTestSupport.optimizePhysicalInternal(sql, context);
    }

    static RelNode preOptimizeInternal(String sql, OptimizerContext context) {
        QueryParseResult parseResult = context.parse(sql);
        return context.convert(parseResult.getNode()).getRel();
    }

    private static LogicalRel optimizeLogicalInternal(String sql, OptimizerContext context) {
        RelNode rel = OptimizerTestSupport.preOptimizeInternal(sql, context);
        LogicalRel optimizedLogicalRel = (LogicalRel)context.optimize(rel, LogicalRules.getRuleSet(), OptUtils.toLogicalConvention((RelTraitSet)rel.getTraitSet()));
        return (LogicalRel)context.optimize((RelNode)optimizedLogicalRel, RuleSets.ofList((RelOptRule[])new RelOptRule[]{SelectByKeyMapLogicalRule.INSTANCE}), OptUtils.toLogicalConvention((RelTraitSet)rel.getTraitSet()));
    }

    private static Result optimizePhysicalInternal(String sql, OptimizerContext context) {
        LogicalRel logicalRel = OptimizerTestSupport.optimizeLogicalInternal(sql, context);
        PhysicalRel physicalRel = (PhysicalRel)context.optimize((RelNode)logicalRel, PhysicalRules.getRuleSet(), OptUtils.toPhysicalConvention((RelTraitSet)logicalRel.getTraitSet()));
        physicalRel = CalciteSqlOptimizerImpl.postOptimizationRewrites((PhysicalRel)physicalRel);
        return new Result(logicalRel, physicalRel);
    }

    private static HazelcastSchema schema(HazelcastTable ... tables) {
        return new HazelcastSchema(Arrays.stream(tables).collect(Collectors.toMap(table -> table.getTarget().getSqlName(), Function.identity())));
    }

    private static OptimizerContext context(HazelcastSchema schema, QueryDataType ... parameterTypes) {
        SqlServiceImpl sql = (SqlServiceImpl)OptimizerTestSupport.instance().getSql();
        HepProgram subqueryRewriterProgram = sql.getOptimizer().getSubqueryRewriterProgram();
        OptimizerContext context = OptimizerContext.create((HazelcastSchema)HazelcastSchemaUtils.createCatalog((Schema)schema), (List)QueryUtils.prepareSearchPaths(null, null), Collections.emptyList(), name -> null, (HepProgram)subqueryRewriterProgram, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
        ParameterConverter[] parameterConverters = (ParameterConverter[])IntStream.range(0, parameterTypes.length).mapToObj(i -> new StrictParameterConverter(i, SqlParserPos.ZERO, parameterTypes[i])).toArray(ParameterConverter[]::new);
        QueryParameterMetadata parameterMetadata = new QueryParameterMetadata(parameterConverters);
        context.setParameterMetadata(parameterMetadata);
        return context;
    }

    protected static HazelcastTable partitionedTable(String name, List<TableField> fields, long rowCount) {
        return OptimizerTestSupport.partitionedTable(name, fields, Collections.emptyList(), rowCount);
    }

    protected static HazelcastTable partitionedTable(String name, List<TableField> fields, List<MapTableIndex> indexes, long rowCount) {
        return OptimizerTestSupport.partitionedTable(name, fields, indexes, rowCount, Collections.emptyList(), false);
    }

    protected static HazelcastTable partitionedTable(String name, List<TableField> fields, List<MapTableIndex> indexes, long rowCount, List<String> partitioningAttributes, boolean supportsPartitionPruning) {
        PartitionedMapTable table = new PartitionedMapTable("public", name, name, fields, (TableStatistics)new ConstantTableStatistics(rowCount), (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (Object)PrimitiveUpsertTargetDescriptor.INSTANCE, (Object)PrimitiveUpsertTargetDescriptor.INSTANCE, indexes, false, partitioningAttributes, supportsPartitionPruning);
        return new HazelcastTable((Table)table, (Statistic)new HazelcastTableStatistic(rowCount));
    }

    protected static HazelcastTable streamingTable(Table table, long rowCount) {
        return new HazelcastTable(table, (Statistic)new HazelcastTableStatistic(rowCount));
    }

    protected static HazelcastTable streamGeneratorTable(String name, int rowCount) {
        return new HazelcastTable((Table)StreamSqlConnector.createTable((String)"public", (String)name, Collections.emptyList()), (Statistic)new HazelcastTableStatistic((long)rowCount));
    }

    protected static TableField field(String name, QueryDataType type) {
        return new Field(name, type, false);
    }

    protected static MapTableField mapField(String name, QueryDataType type, QueryPath queryPath) {
        return new MapTableField(name, type, false, queryPath);
    }

    protected static void assertPlan(RelNode rel, PlanRows expected) {
        BufferedReader reader = new BufferedReader(new StringReader(RelOptUtil.toString((RelNode)rel, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES)));
        List<PlanRow> rows = reader.lines().map(PlanRow::parse).collect(Collectors.toList());
        OptimizerTestSupport.assertPlan(new PlanRows(rows), expected);
    }

    private static void assertPlan(PlanRows actual, PlanRows expected) {
        int expectedRowCount = expected.getRowCount();
        int actualRowCount = actual.getRowCount();
        ((AbstractIntegerAssert)Assertions.assertThat((int)actualRowCount).as("Plan are different%n%n>>> EXPECTED PLAN:%n%s%n>>> ACTUAL PLAN:%n%s", new Object[]{expected, actual})).isEqualTo(expectedRowCount);
        for (int i = 0; i < expectedRowCount; ++i) {
            PlanRow expectedRow = expected.getRow(i);
            PlanRow actualRow = actual.getRow(i);
            ((ObjectAssert)Assertions.assertThat((Object)actualRow).as("Plan rows are different at %s%n%n>>> EXPECTED PLAN:%n%s%n>>> ACTUAL PLAN:%n%s", new Object[]{i + 1, expected, actual})).isEqualTo((Object)expectedRow);
        }
    }

    protected static PlanRows plan(PlanRow ... rows) {
        return new PlanRows(Arrays.asList(rows));
    }

    protected static PlanRow planRow(int level, Class<? extends RelNode> node) {
        return new PlanRow(level, node);
    }

    protected static class Result {
        private final LogicalRel logical;
        private final PhysicalRel physical;

        private Result(LogicalRel logical, PhysicalRel physical) {
            this.logical = logical;
            this.physical = physical;
        }

        public LogicalRel getLogical() {
            return this.logical;
        }

        public PhysicalRel getPhysical() {
            return this.physical;
        }
    }

    private static class Field
    extends TableField {
        private Field(String name, QueryDataType type, boolean hidden) {
            super(name, type, hidden);
        }
    }

    protected static class PlanRows {
        private final List<PlanRow> rows;

        private PlanRows(List<PlanRow> rows) {
            this.rows = rows;
        }

        private int getRowCount() {
            return this.rows.size();
        }

        private PlanRow getRow(int index) {
            return this.rows.get(index);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.rows.size(); ++i) {
                PlanRow row = this.rows.get(i);
                builder.append(String.format("%02d", i)).append(": ").append(row).append("\n");
            }
            return builder.toString();
        }
    }

    protected static class PlanRow {
        private final int level;
        private final String node;

        protected PlanRow(int level, Class<? extends RelNode> nodeClass) {
            this(level, nodeClass.getSimpleName());
        }

        protected PlanRow(int level, String node) {
            this.level = level;
            this.node = node;
        }

        protected static PlanRow parse(String input) {
            int level = 0;
            while (input.charAt(level * 2) == ' ') {
                ++level;
            }
            String nodeAndSignature = input.substring(0, input.lastIndexOf(":")).trim();
            String node = input.contains("(") ? nodeAndSignature.substring(0, nodeAndSignature.indexOf(40)) : nodeAndSignature;
            return new PlanRow(level, node);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.level; ++i) {
                builder.append("  ");
            }
            builder.append(this.node);
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PlanRow planRow = (PlanRow)o;
            return this.level == planRow.level && Objects.equals(this.node, planRow.node);
        }

        public int hashCode() {
            return Objects.hash(this.level, this.node);
        }
    }
}

