/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.misc;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.SqlExecuteCodec;
import com.hazelcast.client.impl.protocol.codec.SqlFetchCodec;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.sql.SqlExpectedResultType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.SqlRowImpl;
import com.hazelcast.sql.impl.client.SqlClientService;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlNoDeserializationTest
extends SqlTestSupport {
    protected static final int PORTABLE_FACTORY_ID = 1;
    private static final int PORTABLE_KEY_ID = 1;
    private static final int PORTABLE_VALUE_ID = 2;
    private static final String MAP_NAME = "map";
    private static final int KEY_COUNT = 100;
    private static final String SQL = "SELECT __key, this FROM map";
    private static final String ERROR_KEY = "KEY FAILURE";
    private static final String ERROR_VALUE = "VALUE FAILURE";

    @BeforeClass
    public static void beforeClass() {
        SqlNoDeserializationTest.initializeWithClient((int)1, (Config)SqlNoDeserializationTest.config(), (ClientConfig)SqlNoDeserializationTest.clientConfig());
    }

    @Before
    public void before() {
        this.prepare();
    }

    private static Config config() {
        Config config = SqlNoDeserializationTest.smallInstanceConfig();
        config.addMapConfig(new MapConfig(MAP_NAME).setInMemoryFormat(InMemoryFormat.BINARY));
        config.getSerializationConfig().addPortableFactory(1, SqlNoDeserializationTest.portableFactory());
        return config;
    }

    private static ClientConfig clientConfig() {
        ClientConfig config = new ClientConfig();
        config.getSerializationConfig().addPortableFactory(1, SqlNoDeserializationTest.portableFactory());
        return config;
    }

    protected static PortableFactory portableFactory() {
        return classId -> {
            if (classId == 1) {
                return new PersonKey();
            }
            Assert.assertEquals((long)2L, (long)classId);
            return new Person();
        };
    }

    @Test
    public void testMember() {
        try (SqlResult res = SqlNoDeserializationTest.instance().getSql().execute(SQL, new Object[0]);){
            for (SqlRow row : res) {
                SqlRowImpl row0 = (SqlRowImpl)row;
                row0.getObjectRaw(0);
                row0.getObjectRaw(1);
                this.checkFailure(row, true);
                this.checkFailure(row, false);
            }
        }
    }

    @Test
    public void testClient() {
        int pageSize = 50;
        SqlClientService clientService = (SqlClientService)SqlNoDeserializationTest.client().getSql();
        ClientConnection connection = clientService.getQueryConnection();
        QueryId queryId = QueryId.create((UUID)connection.getRemoteUuid());
        ClientMessage executeRequest = SqlExecuteCodec.encodeRequest((String)SQL, Collections.emptyList(), (long)Long.MAX_VALUE, (int)pageSize, null, (byte)SqlExpectedResultType.ROWS.getId(), (QueryId)queryId, (boolean)false);
        SqlExecuteCodec.ResponseParameters executeResponse = SqlExecuteCodec.decodeResponse((ClientMessage)clientService.invokeOnConnection(connection, executeRequest));
        if (executeResponse.error != null) {
            Assert.fail((String)executeResponse.error.getMessage());
        }
        Assert.assertNotNull((Object)executeResponse.rowPage);
        Assert.assertEquals((long)pageSize, (long)executeResponse.rowPage.getRowCount());
        ClientMessage fetchRequest = SqlFetchCodec.encodeRequest((QueryId)queryId, (int)pageSize);
        SqlFetchCodec.ResponseParameters fetchResponse = SqlFetchCodec.decodeResponse((ClientMessage)clientService.invokeOnConnection(connection, fetchRequest));
        if (fetchResponse.error != null) {
            Assert.fail((String)fetchResponse.error.getMessage());
        }
        Assert.assertNotNull((Object)fetchResponse.rowPage);
        Assert.assertEquals((long)pageSize, (long)fetchResponse.rowPage.getRowCount());
    }

    private void checkFailure(SqlRow row, boolean key) {
        int index = key ? 0 : 1;
        String expectedMessage = key ? ERROR_KEY : ERROR_VALUE;
        try {
            row.getObject(index);
            Assert.fail();
        }
        catch (HazelcastSerializationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(expectedMessage));
        }
    }

    private void prepare() {
        HashMap<PersonKey, Person> localMap = new HashMap<PersonKey, Person>();
        for (int i = 0; i < 100; ++i) {
            localMap.put(new PersonKey(i), new Person());
        }
        SqlNoDeserializationTest.instance().getMap(MAP_NAME).putAll(localMap);
        SqlNoDeserializationTest.createMapping(MAP_NAME, 1, 1, 0, 1, 2, 0);
    }

    public static class PersonKey
    implements Portable {
        private int id;

        public PersonKey() {
        }

        public PersonKey(int id) {
            this.id = id;
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 1;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("id", this.id);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.id = reader.readInt("id");
            throw new IOException(SqlNoDeserializationTest.ERROR_KEY);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PersonKey personKey = (PersonKey)o;
            return this.id == personKey.id;
        }

        public int hashCode() {
            return this.id;
        }
    }

    public static class Person
    implements Portable {
        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }

        public void writePortable(PortableWriter writer) {
        }

        public void readPortable(PortableReader reader) throws IOException {
            throw new IOException(SqlNoDeserializationTest.ERROR_VALUE);
        }
    }
}

