/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.jet.sql.impl.inject.PortableUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.function.Function;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class PortableUpsertTargetTest {
    @Test
    public void test_set() throws IOException {
        ClassDefinition innerClassDefinition = new ClassDefinitionBuilder(4, 5, 6).build();
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).addPortableField("null", innerClassDefinition).addPortableField("object", innerClassDefinition).addStringField("string").addCharField("character").addBooleanField("boolean").addByteField("byte").addShortField("short").addIntField("int").addLongField("long").addFloatField("float").addDoubleField("double").addDecimalField("decimal").addTimeField("time").addDateField("date").addTimestampField("timestamp").addTimestampWithTimezoneField("timestampTz").build();
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        UpsertInjector nullFieldInjector = target.createInjector("null", QueryDataType.OBJECT);
        UpsertInjector objectFieldInjector = target.createInjector("object", QueryDataType.OBJECT);
        UpsertInjector stringFieldInjector = target.createInjector("string", QueryDataType.VARCHAR);
        UpsertInjector characterFieldInjector = target.createInjector("character", QueryDataType.VARCHAR_CHARACTER);
        UpsertInjector booleanFieldInjector = target.createInjector("boolean", QueryDataType.BOOLEAN);
        UpsertInjector byteFieldInjector = target.createInjector("byte", QueryDataType.TINYINT);
        UpsertInjector shortFieldInjector = target.createInjector("short", QueryDataType.SMALLINT);
        UpsertInjector intFieldInjector = target.createInjector("int", QueryDataType.INT);
        UpsertInjector longFieldInjector = target.createInjector("long", QueryDataType.BIGINT);
        UpsertInjector floatFieldInjector = target.createInjector("float", QueryDataType.REAL);
        UpsertInjector doubleFieldInjector = target.createInjector("double", QueryDataType.DOUBLE);
        UpsertInjector decimalFieldInjector = target.createInjector("decimal", QueryDataType.DECIMAL);
        UpsertInjector timeFieldInjector = target.createInjector("time", QueryDataType.TIME);
        UpsertInjector dateFieldInjector = target.createInjector("date", QueryDataType.DATE);
        UpsertInjector timestampFieldInjector = target.createInjector("timestamp", QueryDataType.TIMESTAMP);
        UpsertInjector timestampTzFieldInjector = target.createInjector("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        target.init();
        nullFieldInjector.set(null);
        objectFieldInjector.set((Object)new PortableGenericRecordBuilder(innerClassDefinition).build());
        stringFieldInjector.set((Object)"1");
        characterFieldInjector.set((Object)Character.valueOf('2'));
        booleanFieldInjector.set((Object)true);
        byteFieldInjector.set((Object)3);
        shortFieldInjector.set((Object)4);
        intFieldInjector.set((Object)5);
        longFieldInjector.set((Object)6L);
        floatFieldInjector.set((Object)Float.valueOf(7.1f));
        doubleFieldInjector.set((Object)7.2);
        decimalFieldInjector.set((Object)new BigDecimal("8.1"));
        timeFieldInjector.set((Object)LocalTime.of(12, 23, 34));
        dateFieldInjector.set((Object)LocalDate.of(2021, 2, 9));
        timestampFieldInjector.set((Object)LocalDateTime.of(2021, 2, 9, 12, 23, 34, 1000000));
        timestampTzFieldInjector.set((Object)OffsetDateTime.of(2021, 2, 9, 12, 23, 34, 200000000, ZoneOffset.UTC));
        Object portable = target.conclude();
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        InternalGenericRecord record = ss.readAsInternalGenericRecord(ss.toData(portable));
        Assertions.assertThat((Object)record.getGenericRecord("null")).isNull();
        Assertions.assertThat((Object)record.getGenericRecord("object")).isEqualTo((Object)new PortableGenericRecordBuilder(innerClassDefinition).build());
        Assertions.assertThat((String)record.getString("string")).isEqualTo("1");
        Assertions.assertThat((char)record.getChar("character")).isEqualTo('2');
        Assertions.assertThat((boolean)record.getBoolean("boolean")).isEqualTo(true);
        Assertions.assertThat((byte)record.getInt8("byte")).isEqualTo((byte)3);
        Assertions.assertThat((short)record.getInt16("short")).isEqualTo((short)4);
        Assertions.assertThat((int)record.getInt32("int")).isEqualTo(5);
        Assertions.assertThat((long)record.getInt64("long")).isEqualTo(6L);
        Assertions.assertThat((float)record.getFloat32("float")).isEqualTo(7.1f);
        Assertions.assertThat((double)record.getFloat64("double")).isEqualTo(7.2);
        Assertions.assertThat((BigDecimal)record.getDecimal("decimal")).isEqualTo((Object)new BigDecimal("8.1"));
        Assertions.assertThat((LocalTime)record.getTime("time")).isEqualTo((Object)LocalTime.of(12, 23, 34));
        Assertions.assertThat((LocalDate)record.getDate("date")).isEqualTo((Object)LocalDate.of(2021, 2, 9));
        Assertions.assertThat((LocalDateTime)record.getTimestamp("timestamp")).isEqualTo((Object)LocalDateTime.of(2021, 2, 9, 12, 23, 34, 1000000));
        Assertions.assertThat((OffsetDateTime)record.getTimestampWithTimezone("timestampTz")).isEqualTo((Object)OffsetDateTime.of(2021, 2, 9, 12, 23, 34, 200000000, ZoneOffset.UTC));
    }

    private Object[] primitiveClassDefinitions() {
        return new Object[]{new Object[]{new ClassDefinitionBuilder(1, 2, 3).addBooleanField("field").build(), QueryDataType.BOOLEAN, false, record -> record.getBoolean("field")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addByteField("field").build(), QueryDataType.TINYINT, (byte)0, record -> record.getInt8("field")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addShortField("field").build(), QueryDataType.SMALLINT, (short)0, record -> record.getInt16("field")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addIntField("field").build(), QueryDataType.INT, 0, record -> record.getInt32("field")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addLongField("field").build(), QueryDataType.BIGINT, 0L, record -> record.getInt64("field")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addFloatField("field").build(), QueryDataType.REAL, Float.valueOf(0.0f), record -> Float.valueOf(record.getFloat32("field"))}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDoubleField("field").build(), QueryDataType.DOUBLE, 0.0, record -> record.getFloat64("field")}};
    }

    @Test
    @Parameters(method="primitiveClassDefinitions")
    public void when_injectNullIntoPrimitive_then_throws(ClassDefinition classDefinition, QueryDataType type, Object defaultValue, Function<InternalGenericRecord, Object> valueExtractor) {
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        UpsertInjector injector = target.createInjector("field", type);
        target.init();
        injector.set(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((UpsertTarget)target).conclude()).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot set value null");
    }

    @Test
    @Parameters(method="primitiveClassDefinitions")
    public void when_doesNotInjectIntoPrimitive_then_insertsDefaultValue(ClassDefinition classDefinition, QueryDataType type, Object defaultValue, Function<InternalGenericRecord, Object> valueExtractor) throws IOException {
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        target.init();
        Object portable = target.conclude();
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        InternalGenericRecord record = ss.readAsInternalGenericRecord(ss.toData(portable));
        Assertions.assertThat((Object)valueExtractor.apply(record)).isEqualTo(defaultValue);
    }

    private Object[] objectClassDefinitions() {
        ClassDefinition innerClassDefinition = new ClassDefinitionBuilder(4, 5, 6).build();
        return new Object[]{new Object[]{new ClassDefinitionBuilder(1, 2, 3).addPortableField("object", innerClassDefinition).build(), null, record -> record.getGenericRecord("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addPortableField("object", innerClassDefinition).build(), new PortableGenericRecordBuilder(innerClassDefinition).build(), record -> record.getGenericRecord("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addPortableArrayField("object", innerClassDefinition).build(), null, record -> record.getArrayOfGenericRecord("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addPortableArrayField("object", innerClassDefinition).build(), new GenericRecord[0], record -> record.getArrayOfGenericRecord("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addBooleanArrayField("object").build(), null, record -> record.getArrayOfBoolean("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addBooleanArrayField("object").build(), new boolean[0], record -> record.getArrayOfBoolean("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addByteArrayField("object").build(), null, record -> record.getArrayOfInt8("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addByteArrayField("object").build(), new byte[0], record -> record.getArrayOfInt8("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addShortArrayField("object").build(), null, record -> record.getArrayOfInt16("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addShortArrayField("object").build(), new short[0], record -> record.getArrayOfInt16("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addCharArrayField("object").build(), null, record -> record.getArrayOfChar("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addCharArrayField("object").build(), new char[0], record -> record.getArrayOfChar("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addIntArrayField("object").build(), null, record -> record.getArrayOfInt32("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addIntArrayField("object").build(), new int[0], record -> record.getArrayOfInt32("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addLongArrayField("object").build(), null, record -> record.getArrayOfInt64("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addLongArrayField("object").build(), new long[0], record -> record.getArrayOfInt64("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addFloatArrayField("object").build(), null, record -> record.getArrayOfFloat32("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addFloatArrayField("object").build(), new float[0], record -> record.getArrayOfFloat32("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDoubleArrayField("object").build(), null, record -> record.getArrayOfFloat64("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDoubleArrayField("object").build(), new double[0], record -> record.getArrayOfFloat64("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDecimalArrayField("object").build(), null, record -> record.getArrayOfDecimal("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDecimalArrayField("object").build(), new BigDecimal[0], record -> record.getArrayOfDecimal("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addStringArrayField("object").build(), null, record -> record.getArrayOfString("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addStringArrayField("object").build(), new String[0], record -> record.getArrayOfString("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addTimeArrayField("object").build(), null, record -> record.getArrayOfTime("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addTimeArrayField("object").build(), new LocalTime[0], record -> record.getArrayOfTime("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDateArrayField("object").build(), null, record -> record.getArrayOfDate("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addDateArrayField("object").build(), new LocalDate[0], record -> record.getArrayOfDate("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addTimestampArrayField("object").build(), null, record -> record.getArrayOfTimestamp("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addTimestampArrayField("object").build(), new LocalDateTime[0], record -> record.getArrayOfTimestamp("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addTimestampWithTimezoneArrayField("object").build(), null, record -> record.getArrayOfTimestampWithTimezone("object")}, new Object[]{new ClassDefinitionBuilder(1, 2, 3).addTimestampWithTimezoneArrayField("object").build(), new OffsetDateTime[0], record -> record.getArrayOfTimestampWithTimezone("object")}};
    }

    @Test
    @Parameters(method="objectClassDefinitions")
    public void when_typeIsObject_then_allValuesAreAllowed(ClassDefinition classDefinition, Object value, Function<InternalGenericRecord, Object> valueExtractor) throws IOException {
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        UpsertInjector injector = target.createInjector("object", QueryDataType.OBJECT);
        target.init();
        injector.set(value);
        Object portable = target.conclude();
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        InternalGenericRecord record = ss.readAsInternalGenericRecord(ss.toData(portable));
        Assertions.assertThat((Object)valueExtractor.apply(record)).isEqualTo(value);
    }

    @Test
    @Parameters(method="objectClassDefinitions")
    public void when_doesNotInjectIntoObject_then_insertsNull(ClassDefinition classDefinition, Object value, Function<InternalGenericRecord, Object> valueExtractor) throws IOException {
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        target.init();
        Object portable = target.conclude();
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        InternalGenericRecord record = ss.readAsInternalGenericRecord(ss.toData(portable));
        Assertions.assertThat((Object)valueExtractor.apply(record)).isNull();
    }

    @Test
    public void when_injectNonExistingPropertyValue_then_throws() {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).build();
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        UpsertInjector injector = target.createInjector("field", QueryDataType.INT);
        target.init();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> injector.set((Object)"1")).isInstanceOf(QueryException.class)).hasMessageContaining("Field \"field\" doesn't exist in Portable Class Definition");
    }

    @Test
    public void when_injectNonExistingPropertyNullValue_then_succeeds() throws IOException {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).build();
        PortableUpsertTarget target = new PortableUpsertTarget(classDefinition);
        UpsertInjector injector = target.createInjector("field", QueryDataType.INT);
        target.init();
        injector.set(null);
        Object portable = target.conclude();
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        InternalGenericRecord record = ss.readAsInternalGenericRecord(ss.toData(portable));
        Assertions.assertThat((Object)record).isNotNull();
    }
}

