/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataAvroResolver;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecordBuilder;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class AvroUpsertTargetTest {
    @Test
    public void test_set() {
        Schema schema = (Schema)SchemaBuilder.record((String)"name").fields().name("null").type().nullType().nullDefault().optionalString("string").optionalBoolean("boolean").optionalInt("byte").optionalInt("short").optionalInt("int").optionalLong("long").optionalFloat("float").optionalDouble("double").optionalString("decimal").optionalString("time").optionalString("date").optionalString("timestamp").optionalString("timestampTz").endRecord();
        AvroUpsertTarget target = new AvroUpsertTarget(schema);
        UpsertInjector nullInjector = target.createInjector("null", QueryDataType.OBJECT);
        UpsertInjector stringInjector = target.createInjector("string", QueryDataType.VARCHAR);
        UpsertInjector booleanInjector = target.createInjector("boolean", QueryDataType.BOOLEAN);
        UpsertInjector byteInjector = target.createInjector("byte", QueryDataType.TINYINT);
        UpsertInjector shortInjector = target.createInjector("short", QueryDataType.SMALLINT);
        UpsertInjector intInjector = target.createInjector("int", QueryDataType.INT);
        UpsertInjector longInjector = target.createInjector("long", QueryDataType.BIGINT);
        UpsertInjector floatInjector = target.createInjector("float", QueryDataType.REAL);
        UpsertInjector doubleInjector = target.createInjector("double", QueryDataType.DOUBLE);
        UpsertInjector decimalInjector = target.createInjector("decimal", QueryDataType.DECIMAL);
        UpsertInjector timeInjector = target.createInjector("time", QueryDataType.TIME);
        UpsertInjector dateInjector = target.createInjector("date", QueryDataType.DATE);
        UpsertInjector timestampInjector = target.createInjector("timestamp", QueryDataType.TIMESTAMP);
        UpsertInjector timestampTzInjector = target.createInjector("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME);
        target.init();
        nullInjector.set(null);
        stringInjector.set((Object)"string");
        booleanInjector.set((Object)true);
        byteInjector.set((Object)127);
        shortInjector.set((Object)Short.MAX_VALUE);
        intInjector.set((Object)Integer.MAX_VALUE);
        longInjector.set((Object)Long.MAX_VALUE);
        floatInjector.set((Object)Float.valueOf(1.234568E9f));
        doubleInjector.set((Object)1.234512345678901E14);
        decimalInjector.set((Object)new BigDecimal("9223372036854775.123"));
        timeInjector.set((Object)LocalTime.of(12, 23, 34));
        dateInjector.set((Object)LocalDate.of(2020, 9, 9));
        timestampInjector.set((Object)LocalDateTime.of(2020, 9, 9, 12, 23, 34, 100000000));
        timestampTzInjector.set((Object)OffsetDateTime.of(2020, 9, 9, 12, 23, 34, 200000000, ZoneOffset.UTC));
        Object record = target.conclude();
        Assertions.assertThat((Object)record).isEqualTo((Object)new GenericRecordBuilder(schema).set("null", null).set("string", (Object)"string").set("boolean", (Object)true).set("byte", (Object)127).set("short", (Object)Short.MAX_VALUE).set("int", (Object)Integer.MAX_VALUE).set("long", (Object)Long.MAX_VALUE).set("float", (Object)Float.valueOf(1.234568E9f)).set("double", (Object)1.234512345678901E14).set("decimal", (Object)"9223372036854775.123").set("time", (Object)"12:23:34").set("date", (Object)"2020-09-09").set("timestamp", (Object)"2020-09-09T12:23:34.100").set("timestampTz", (Object)"2020-09-09T12:23:34.200Z").build());
    }

    private Object[] values() {
        return new Object[]{new Object[]{null, null}, new Object[]{"string", "string"}, new Object[]{true, true}, new Object[]{(byte)127, 127}, new Object[]{(short)Short.MAX_VALUE, Short.MAX_VALUE}, new Object[]{Integer.MAX_VALUE, Integer.MAX_VALUE}, new Object[]{Long.MAX_VALUE, Long.MAX_VALUE}, new Object[]{Float.valueOf(1.234568E9f), Float.valueOf(1.234568E9f)}, new Object[]{1.234512345678901E14, 1.234512345678901E14}, new Object[]{new BigDecimal("9223372036854775.123"), "9223372036854775.123"}, new Object[]{LocalTime.of(12, 23, 34), "12:23:34"}, new Object[]{LocalDate.of(2020, 9, 9), "2020-09-09"}, new Object[]{LocalDateTime.of(2020, 9, 9, 12, 23, 34, 100000000), "2020-09-09T12:23:34.100"}, new Object[]{OffsetDateTime.of(2020, 9, 9, 12, 23, 34, 200000000, ZoneOffset.UTC), "2020-09-09T12:23:34.200Z"}};
    }

    @Test
    @Parameters(method="values")
    public void when_typeIsObject_then_allValuesAreAllowed(Object value, Object expected) {
        Schema schema = (Schema)SchemaBuilder.record((String)"name").fields().name("object").type(KvMetadataAvroResolver.Schemas.OBJECT_SCHEMA).withDefault(null).endRecord();
        AvroUpsertTarget target = new AvroUpsertTarget(schema);
        UpsertInjector injector = target.createInjector("object", QueryDataType.OBJECT);
        target.init();
        injector.set(value);
        Object record = target.conclude();
        Assertions.assertThat((Object)record).isEqualTo((Object)new GenericRecordBuilder(schema).set("object", expected).build());
    }
}

