/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.index;

import com.hazelcast.config.IndexType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.jet.sql.impl.index.IndexFilterTestSupport;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;

public abstract class IndexFilterIteratorTestSupport
extends IndexFilterTestSupport {
    protected static final String MAP_NAME = "map";
    protected static final String INDEX_NAME = "index";
    protected final TestHazelcastInstanceFactory factory = new TestHazelcastInstanceFactory(1);

    @After
    public void after() {
        this.factory.shutdownAll();
    }

    protected static InternalIndex getIndex(HazelcastInstance instance) {
        MapService mapService = (MapService)IndexFilterIteratorTestSupport.nodeEngine(instance).getService("hz:impl:mapService");
        MapContainer mapContainer = mapService.getMapServiceContext().getMapContainer(MAP_NAME);
        return mapContainer.getGlobalIndexRegistry().getIndex(INDEX_NAME);
    }

    protected static <T> void checkIterator(IndexType indexType, boolean expectedDescending, Iterator<QueryableEntry> iterator, T ... expectedKeys) {
        Set expected;
        if (expectedKeys != null) {
            expected = new HashSet<T>(Arrays.asList(expectedKeys));
            Assert.assertEquals((String)"Key passed to this method must be unique!", (long)expected.size(), (long)expectedKeys.length);
        } else {
            expected = Collections.emptySet();
        }
        HashSet<Object> actual = new HashSet<Object>();
        Object prevValue = null;
        while (iterator.hasNext()) {
            QueryableEntry entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof Data) {
                key = IndexFilterIteratorTestSupport.serializationService().toObject(key);
            }
            if (value instanceof Data) {
                value = IndexFilterIteratorTestSupport.serializationService().toObject(value);
            }
            if (indexType == IndexType.SORTED && prevValue != null) {
                int cmp = ((Value)prevValue).compareTo((Value)value, expectedDescending);
                Assert.assertTrue((String)("Wrong collation, prevValue " + String.valueOf(prevValue) + ", value " + String.valueOf(value) + ", expectedDescending " + expectedDescending), (cmp <= 0 ? 1 : 0) != 0);
            }
            prevValue = value;
            Assert.assertTrue((String)("Duplicate key: " + String.valueOf(key)), (boolean)actual.add(key));
        }
        Assert.assertEquals((String)("Expected: " + String.valueOf(expected) + ", actual: " + String.valueOf(actual)), (long)expected.size(), (long)actual.size());
        Assert.assertTrue((String)("Expected: " + String.valueOf(expected) + ", actual: " + String.valueOf(actual)), (boolean)expected.containsAll(actual));
    }

    public static class Value
    implements Serializable {
        public Integer value1;
        public Integer value2;

        public Value(Integer value) {
            this(value, value);
        }

        public Value(Integer value1, Integer value2) {
            this.value1 = value1;
            this.value2 = value2;
        }

        public int compareTo(Value o, boolean descending) {
            int cmp1;
            if (this.value1 == null) {
                return o.value1 == null ? 0 : (descending ? 1 : -1);
            }
            if (o.value1 == null) {
                return descending ? -1 : 1;
            }
            int n = cmp1 = descending ? Integer.compare(o.value1, this.value1) : Integer.compare(this.value1, o.value1);
            if (cmp1 == 0) {
                if (this.value2 == null) {
                    return o.value2 == null ? 0 : (descending ? 1 : -1);
                }
                if (o.value2 == null) {
                    return descending ? -1 : 1;
                }
                return descending ? Integer.compare(o.value2, this.value2) : Integer.compare(this.value2, o.value2);
            }
            return cmp1;
        }

        public String toString() {
            return "[" + this.value1 + ", " + this.value2 + "]";
        }
    }
}

