/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.IsFalsePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotFalsePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotTruePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsTruePredicate;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IsTrueFalsePredicateIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        Class<? extends ExpressionValue> clazz = ExpressionValue.createClass(ExpressionTypes.BOOLEAN);
        int keyTrue = 0;
        int keyFalse = 1;
        int keyNull = 2;
        HashMap<Integer, Object> entries = new HashMap<Integer, Object>();
        entries.put(keyTrue, ExpressionValue.create(clazz, keyTrue, true));
        entries.put(keyFalse, ExpressionValue.create(clazz, keyFalse, false));
        entries.put(keyNull, ExpressionValue.create(clazz, keyNull, null));
        this.putAll(entries);
        this.checkColumn("IS TRUE", IsTrueFalsePredicateIntegrationTest.set(keyTrue));
        this.checkColumn("IS FALSE", IsTrueFalsePredicateIntegrationTest.set(keyFalse));
        this.checkColumn("IS NOT TRUE", IsTrueFalsePredicateIntegrationTest.set(keyFalse, keyNull));
        this.checkColumn("IS NOT FALSE", IsTrueFalsePredicateIntegrationTest.set(keyTrue, keyNull));
        this.checkUnsupportedColumn(ExpressionTypes.STRING, SqlColumnType.VARCHAR);
        this.checkUnsupportedColumn(ExpressionTypes.BYTE, SqlColumnType.TINYINT);
        this.checkUnsupportedColumn(ExpressionTypes.SHORT, SqlColumnType.SMALLINT);
        this.checkUnsupportedColumn(ExpressionTypes.INTEGER, SqlColumnType.INTEGER);
        this.checkUnsupportedColumn(ExpressionTypes.LONG, SqlColumnType.BIGINT);
        this.checkUnsupportedColumn(ExpressionTypes.BIG_INTEGER, SqlColumnType.DECIMAL);
        this.checkUnsupportedColumn(ExpressionTypes.BIG_DECIMAL, SqlColumnType.DECIMAL);
        this.checkUnsupportedColumn(ExpressionTypes.FLOAT, SqlColumnType.REAL);
        this.checkUnsupportedColumn(ExpressionTypes.DOUBLE, SqlColumnType.DOUBLE);
        this.checkUnsupportedColumn(ExpressionTypes.LOCAL_DATE, SqlColumnType.DATE);
        this.checkUnsupportedColumn(ExpressionTypes.LOCAL_TIME, SqlColumnType.TIME);
        this.checkUnsupportedColumn(ExpressionTypes.LOCAL_DATE_TIME, SqlColumnType.TIMESTAMP);
        this.checkUnsupportedColumn(ExpressionTypes.OFFSET_DATE_TIME, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        this.checkUnsupportedColumn(ExpressionTypes.OBJECT, SqlColumnType.OBJECT);
    }

    private void checkColumn(String function, Set<Integer> expectedKeys) {
        String expression = "field1 " + function;
        String sql = "SELECT key, " + expression + " FROM map WHERE " + expression;
        List<SqlRow> rows = IsTrueFalsePredicateIntegrationTest.execute(sql, new Object[0]);
        Assert.assertEquals((long)expectedKeys.size(), (long)rows.size());
        for (SqlRow row : rows) {
            Assert.assertEquals((Object)SqlColumnType.BOOLEAN, (Object)row.getMetadata().getColumn(1).getType());
            int key = (Integer)row.getObject(0);
            boolean value = (Boolean)row.getObject(1);
            Assert.assertTrue((String)("Key is not returned: " + key), (boolean)expectedKeys.contains(key));
            Assert.assertTrue((boolean)value);
        }
    }

    private void checkUnsupportedColumn(ExpressionType<?> type, SqlColumnType expectedType) {
        this.checkUnsupportedColumn(type, "IS TRUE", expectedType);
        this.checkUnsupportedColumn(type, "IS FALSE", expectedType);
        this.checkUnsupportedColumn(type, "IS NOT FALSE", expectedType);
        this.checkUnsupportedColumn(type, "IS NOT TRUE", expectedType);
    }

    private void checkUnsupportedColumn(ExpressionType<?> type, String function, SqlColumnType expectedType) {
        String expectedErrorMessage = IsTrueFalsePredicateIntegrationTest.signatureErrorOperator(function, expectedType);
        int key = 0;
        this.put(key, ExpressionValue.create(ExpressionValue.createClass(type), key, type.valueFrom()));
        this.checkFailure0("SELECT key FROM map WHERE field1 " + function, 1008, expectedErrorMessage, new Object[0]);
        this.checkFailure0("SELECT field1 " + function + " FROM map", 1008, expectedErrorMessage, new Object[0]);
    }

    @Test
    public void testLiteral() {
        this.put(ExpressionValue.create(ExpressionValue.createClass(ExpressionTypes.INTEGER), 0, 1));
        this.checkLiteral("TRUE", "IS TRUE", true);
        this.checkLiteral("true", "IS TRUE", true);
        this.checkLiteral("TRUE", "IS FALSE", false);
        this.checkLiteral("true", "IS FALSE", false);
        this.checkLiteral("TRUE", "IS NOT TRUE", false);
        this.checkLiteral("true", "IS NOT TRUE", false);
        this.checkLiteral("TRUE", "IS NOT FALSE", true);
        this.checkLiteral("true", "IS NOT FALSE", true);
        this.checkLiteral("FALSE", "IS TRUE", false);
        this.checkLiteral("false", "IS TRUE", false);
        this.checkLiteral("FALSE", "IS FALSE", true);
        this.checkLiteral("false", "IS FALSE", true);
        this.checkLiteral("FALSE", "IS NOT TRUE", true);
        this.checkLiteral("false", "IS NOT TRUE", true);
        this.checkLiteral("FALSE", "IS NOT FALSE", false);
        this.checkLiteral("false", "IS NOT FALSE", false);
        this.checkLiteral("NULL", "IS TRUE", false);
        this.checkLiteral("null", "IS TRUE", false);
        this.checkLiteral("NULL", "IS FALSE", false);
        this.checkLiteral("null", "IS FALSE", false);
        this.checkLiteral("NULL", "IS NOT TRUE", true);
        this.checkLiteral("null", "IS NOT TRUE", true);
        this.checkLiteral("NULL", "IS NOT FALSE", true);
        this.checkLiteral("null", "IS NOT FALSE", true);
        this.checkLiteralFailure("1", SqlColumnType.TINYINT);
        this.checkLiteralFailure("1.1", SqlColumnType.DECIMAL);
        this.checkLiteralFailure("1e1", SqlColumnType.DOUBLE);
        this.checkLiteralFailure("'true'", SqlColumnType.VARCHAR);
        this.checkLiteralFailure("'false'", SqlColumnType.VARCHAR);
        this.checkLiteralFailure("'null'", SqlColumnType.VARCHAR);
        this.checkLiteralFailure("'string'", SqlColumnType.VARCHAR);
    }

    private void checkLiteral(String literal, String function, boolean expectedResult) {
        String expression = literal + " " + function;
        String sql = "SELECT " + expression + " FROM map WHERE " + expression;
        List<SqlRow> rows = IsTrueFalsePredicateIntegrationTest.execute(sql, new Object[0]);
        if (expectedResult) {
            Assert.assertEquals((long)1L, (long)rows.size());
            SqlRow row = rows.get(0);
            Assert.assertEquals((Object)SqlColumnType.BOOLEAN, (Object)row.getMetadata().getColumn(0).getType());
            Assert.assertTrue((boolean)((Boolean)row.getObject(0)));
        } else {
            Assert.assertEquals((long)0L, (long)rows.size());
        }
    }

    private void checkLiteralFailure(String literal, SqlColumnType expectedType) {
        this.checkLiteralFailure(literal, "IS TRUE", expectedType);
        this.checkLiteralFailure(literal, "IS FALSE", expectedType);
        this.checkLiteralFailure(literal, "IS NOT TRUE", expectedType);
        this.checkLiteralFailure(literal, "IS NOT FALSE", expectedType);
    }

    private void checkLiteralFailure(String literal, String function, SqlColumnType expectedType) {
        String expression = literal + " " + function;
        String sql = "SELECT " + expression + " FROM map WHERE " + expression;
        this.checkFailure0(sql, 1008, IsTrueFalsePredicateIntegrationTest.signatureErrorOperator(function, expectedType), new Object[0]);
    }

    @Test
    public void testParameter() {
        int key = 0;
        this.put(key, ExpressionValue.create(ExpressionValue.createClass(ExpressionTypes.INTEGER), 0, 1));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS TRUE", true));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS TRUE", false));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS TRUE", new Object[]{null}));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS FALSE", true));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS FALSE", false));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS FALSE", new Object[]{null}));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS NOT TRUE", true));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS NOT TRUE", false));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS NOT TRUE", new Object[]{null}));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS NOT FALSE", true));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(new Integer[0]), this.keys("SELECT key FROM map WHERE ? IS NOT FALSE", false));
        Assert.assertEquals(IsTrueFalsePredicateIntegrationTest.set(key), this.keys("SELECT key FROM map WHERE ? IS NOT FALSE", new Object[]{null}));
        this.checkUnsupportedParameter("true", SqlColumnType.VARCHAR);
        this.checkUnsupportedParameter((byte)1, SqlColumnType.TINYINT);
        this.checkUnsupportedParameter((short)1, SqlColumnType.SMALLINT);
        this.checkUnsupportedParameter(1, SqlColumnType.INTEGER);
        this.checkUnsupportedParameter(1L, SqlColumnType.BIGINT);
        this.checkUnsupportedParameter(BigInteger.ONE, SqlColumnType.DECIMAL);
        this.checkUnsupportedParameter(BigDecimal.ONE, SqlColumnType.DECIMAL);
        this.checkUnsupportedParameter(Float.valueOf(1.0f), SqlColumnType.REAL);
        this.checkUnsupportedParameter(1.0, SqlColumnType.DOUBLE);
        this.checkUnsupportedParameter(LOCAL_DATE_VAL, SqlColumnType.DATE);
        this.checkUnsupportedParameter(LOCAL_TIME_VAL, SqlColumnType.TIME);
        this.checkUnsupportedParameter(LOCAL_DATE_TIME_VAL, SqlColumnType.TIMESTAMP);
        this.checkUnsupportedParameter(OFFSET_DATE_TIME_VAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        this.checkUnsupportedParameter(OBJECT_VAL, SqlColumnType.OBJECT);
    }

    private void checkUnsupportedParameter(Object param, SqlColumnType paramType) {
        this.checkUnsupportedParameter("IS TRUE", param, paramType);
        this.checkUnsupportedParameter("IS FALSE", param, paramType);
        this.checkUnsupportedParameter("IS NOT TRUE", param, paramType);
        this.checkUnsupportedParameter("IS NOT FALSE", param, paramType);
    }

    private void checkUnsupportedParameter(String function, Object param, SqlColumnType paramType) {
        String sql = "SELECT * FROM map WHERE ? " + function;
        String expectedErrorMessage = IsTrueFalsePredicateIntegrationTest.parameterError(0, SqlColumnType.BOOLEAN, paramType);
        this.checkFailure0(sql, 2000, expectedErrorMessage, param);
    }

    private Set<Integer> keys(String sql, Object ... params) {
        List<SqlRow> rows = IsTrueFalsePredicateIntegrationTest.execute(sql, params);
        if (rows.isEmpty()) {
            return Collections.emptySet();
        }
        Assert.assertEquals((long)1L, (long)rows.get(0).getMetadata().getColumnCount());
        HashSet<Integer> keys = new HashSet<Integer>();
        for (SqlRow row : rows) {
            int key = (Integer)row.getObject(0);
            boolean added = keys.add(key);
            Assert.assertTrue((String)("Key is not unique: " + key), (boolean)added);
        }
        return keys;
    }

    private static Set<Integer> set(Integer ... values) {
        HashSet<Integer> res = new HashSet<Integer>();
        if (values != null) {
            res.addAll(Arrays.asList(values));
        }
        return res;
    }

    @Test
    public void testEquality_isTrue() {
        ColumnExpression column1 = ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN);
        ColumnExpression column2 = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.BOOLEAN);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsTruePredicate.create((Expression)column1), IsTruePredicate.create((Expression)column1), true);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsTruePredicate.create((Expression)column1), IsTruePredicate.create((Expression)column2), false);
    }

    @Test
    public void testSerialization_isTrue() {
        IsTruePredicate original = IsTruePredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN));
        IsTruePredicate restored = (IsTruePredicate)IsTrueFalsePredicateIntegrationTest.serializeAndCheck(original, 46);
        IsTrueFalsePredicateIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testEquality_isFalse() {
        ColumnExpression column1 = ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN);
        ColumnExpression column2 = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.BOOLEAN);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsFalsePredicate.create((Expression)column1), IsFalsePredicate.create((Expression)column1), true);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsFalsePredicate.create((Expression)column1), IsFalsePredicate.create((Expression)column2), false);
    }

    @Test
    public void testSerialization_isFalse() {
        IsFalsePredicate original = IsFalsePredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN));
        IsFalsePredicate restored = (IsFalsePredicate)IsTrueFalsePredicateIntegrationTest.serializeAndCheck(original, 48);
        IsTrueFalsePredicateIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testEquality_isNotTrue() {
        ColumnExpression column1 = ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN);
        ColumnExpression column2 = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.BOOLEAN);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsNotTruePredicate.create((Expression)column1), IsNotTruePredicate.create((Expression)column1), true);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsNotTruePredicate.create((Expression)column1), IsNotTruePredicate.create((Expression)column2), false);
    }

    @Test
    public void testSerialization_isNotTrue() {
        IsNotTruePredicate original = IsNotTruePredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN));
        IsNotTruePredicate restored = (IsNotTruePredicate)IsTrueFalsePredicateIntegrationTest.serializeAndCheck(original, 47);
        IsTrueFalsePredicateIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    public void testEquality_isNotFalse() {
        ColumnExpression column1 = ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN);
        ColumnExpression column2 = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.BOOLEAN);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsNotFalsePredicate.create((Expression)column1), IsNotFalsePredicate.create((Expression)column1), true);
        IsTrueFalsePredicateIntegrationTest.checkEquals(IsNotFalsePredicate.create((Expression)column1), IsNotFalsePredicate.create((Expression)column2), false);
    }

    @Test
    public void testSerialization_isNotFalse() {
        IsNotFalsePredicate original = IsNotFalsePredicate.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.BOOLEAN));
        IsNotFalsePredicate restored = (IsNotFalsePredicate)IsTrueFalsePredicateIntegrationTest.serializeAndCheck(original, 49);
        IsTrueFalsePredicateIntegrationTest.checkEquals(original, restored, true);
    }
}

