/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.misc;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.CaseExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={QuickTest.class, ParallelJVMTest.class})
@RunWith(value=HazelcastSerialClassRunner.class)
public class CaseOperatorIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void test_literals() {
        this.put(1);
        this.checkValue0("select case when true then null else null end from map", SqlColumnType.NULL, null, new Object[0]);
        this.checkValue0("select case null when null then null else null end from map", SqlColumnType.NULL, null, new Object[0]);
        this.checkFailure0("select case when 1 then 1 else 2 end from map", 1008, "Expected a boolean type", new Object[0]);
        this.checkValue0("select case when 1 = 1 then 1 else null end from map", SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0("select case when 1 = 1 then null else 1 end from map", SqlColumnType.TINYINT, null, new Object[0]);
        this.checkValue0("select case 1 when 1 then 100 else 2 end from map", SqlColumnType.TINYINT, (byte)100, new Object[0]);
        this.checkFailure0("select case 'a' when 1 then 100 else 2 end from map", 1008, "Cannot apply '=' operator to [VARCHAR, TINYINT]", new Object[0]);
        this.checkValue0("select case when 1 <> 1 then null else 10 end from map", SqlColumnType.TINYINT, (byte)10, new Object[0]);
    }

    @Test
    public void nested() {
        this.put(1);
        this.checkValue0("select case 1 when        case when 2 = 2 then 1 end then 100 else 2 end from map", SqlColumnType.TINYINT, (byte)100, new Object[0]);
        this.checkValue0("select case 1 when 1 then        case when 2 = 2 then 100 end else 2 end from map", SqlColumnType.TINYINT, (byte)100, new Object[0]);
        this.checkValue0("select case 1 when 100 then 1 else        case when 2 = 2 then 100 end end from map", SqlColumnType.TINYINT, (byte)100, new Object[0]);
        this.checkValue0("select t.* from (select case 1 when 1 then 100 end from map) as t", SqlColumnType.TINYINT, (byte)100, new Object[0]);
        this.checkValue0("select this from map where 100 = case this when 1 then 100 end", SqlColumnType.INTEGER, 1, new Object[0]);
    }

    @Test
    public void testOnlyElse() {
        this.put(1);
        String sql = "select case else 2 end from map";
        this.checkFailure0(sql, 1008, "Encountered \"else\" at line 1, column 13." + System.lineSeparator() + "Was expecting one of:", new Object[0]);
    }

    @Test
    public void useMapValue() {
        this.put(1);
        this.checkValue0("select case when this = 1 then 10 end from map", SqlColumnType.TINYINT, (byte)10, new Object[0]);
    }

    @Test
    public void multipleConditions() {
        this.put(1);
        String sql = "select case when this > 1 then 10 when this = 1 then 100 end from map";
        this.checkValue0(sql, SqlColumnType.TINYINT, (byte)100, new Object[0]);
    }

    @Test
    public void when_multipleWhenClausesMatch_then_leftmostMatchUsed() {
        this.put(1);
        this.checkValue0("select case when this > 0 then 1 when this < 5 then 2 else null end from map", SqlColumnType.TINYINT, (byte)1, new Object[0]);
        this.checkValue0("select case when this < 0 then 1 when this < 2 then 2 when this < 5 then 5 end from map", SqlColumnType.TINYINT, (byte)2, new Object[0]);
    }

    @Test
    public void when_noMatchAndMissingElseClause_then_null() {
        this.put(1);
        String sql = "select case when this > 1 then 10 end from map";
        this.checkValue0(sql, SqlColumnType.TINYINT, null, new Object[0]);
    }

    @Test
    public void test_mixedReturnTypes_workingCases() {
        this.put(1);
        this.checkValue0("select case this when 1 then 127 when 2 then 32767 when 3 then 2147483647 else 9223372036854775807 end from map", SqlColumnType.BIGINT, 127L, new Object[0]);
        LocalDateTime dateTime = LocalDateTime.of(2021, 1, 1, 10, 0, 0);
        this.checkValue0("select case this when 1 then CAST('2021-01-01T10:00' AS TIMESTAMP) when 2 then CAST('2021-01-01' AS DATE) else CAST('2021-01-01T10:00+00:00' as TIMESTAMP WITH TIME ZONE) end from map", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.of(dateTime, ZoneId.systemDefault().getRules().getOffset(dateTime)), new Object[0]);
    }

    @Test
    public void test_mixedReturnTypes_failingCases() {
        this.put(1);
        this.checkFailure0("select case this when 2 then 100 when 1 then 'a' end from map", 1008, "Cannot infer return type for CASE among [TINYINT, VARCHAR, NULL]", new Object[0]);
        this.checkFailure0("select case 1 when 1 then 1 when 2 then 1000000000 else CAST('2021-01-01' as DATE) end from map", 1008, "Cannot infer return type for CASE among [TINYINT, INTEGER, DATE]", new Object[0]);
        this.checkFailure0("select case 1 when 1 then true when 2 then false else CAST('2021-01-01' as DATE) end from map", 1008, "Cannot infer return type for CASE among [BOOLEAN, BOOLEAN, DATE]", new Object[0]);
        this.checkFailure0("select case this when 2 then 100 else CAST('2021-01-01' as DATE) end from map", 1008, "Cannot infer return type for CASE among [TINYINT, DATE]", new Object[0]);
        this.checkFailure0("select case this when 2 then CAST('10:00:00' AS TIME) else CAST('2021-01-01' as DATE) end from map", 1008, "Cannot infer return type for CASE among [TIME, DATE]", new Object[0]);
    }

    @Test
    public void test_badConversion() {
        this.put(1);
        this.checkFailure0("select case this when 1 then CAST('foo' as DATE) end from map", 1008, "CAST function cannot convert literal 'foo' to type DATE: Cannot parse VARCHAR value to DATE", new Object[0]);
    }

    @Test
    public void test_dynamicParams() {
        this.put(1);
        this.checkValue0("select ? = this from map", SqlColumnType.BOOLEAN, true, 1);
        this.checkFailure0("select case when ? = ? then 1 end from map", 1008, "Cannot apply '=' operator to [UNKNOWN, UNKNOWN]", new Object[0]);
        this.checkFailure0("select case ? when ? then 100 end from map", 1008, "Cannot apply '=' operator to [UNKNOWN, UNKNOWN]", new Object[0]);
        this.checkValue0("select case when ? then 1 end from map", SqlColumnType.TINYINT, (byte)1, true);
        this.checkValue0("select case when ? IS NOT NULL then 100 end from map", SqlColumnType.TINYINT, (byte)100, 1);
        this.checkValue0("select case ? when this then 100 end from map", SqlColumnType.TINYINT, (byte)100, 1);
        this.checkValue0("select case when ? = this then 100 end from map", SqlColumnType.TINYINT, (byte)100, 1);
        this.checkFailure0("select case this when 1 then ? else ? end from map", 1008, "Cannot infer return type for CASE among [UNKNOWN, UNKNOWN]", new Object[0]);
    }

    @Test
    public void numericWithString() {
        String sql = "select case when 1 = 1 then field1 else field2 end from map";
        this.putBiValue((byte)1, "str", ExpressionTypes.BYTE, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [TINYINT, VARCHAR]", new Object[0]);
        this.putBiValue((short)1, "str", ExpressionTypes.SHORT, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [SMALLINT, VARCHAR]", new Object[0]);
        this.putBiValue(1, "str", ExpressionTypes.INTEGER, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [INTEGER, VARCHAR]", new Object[0]);
        this.putBiValue(1L, "str", ExpressionTypes.LONG, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [BIGINT, VARCHAR]", new Object[0]);
        this.putBiValue(BigDecimal.ONE, "str", ExpressionTypes.BIG_DECIMAL, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [DECIMAL(76, 38), VARCHAR]", new Object[0]);
        this.putBiValue(BigInteger.ONE, "str", ExpressionTypes.BIG_INTEGER, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [DECIMAL(76, 38), VARCHAR]", new Object[0]);
        this.putBiValue(1.0, "str", ExpressionTypes.DOUBLE, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [DOUBLE, VARCHAR]", new Object[0]);
        this.putBiValue(Float.valueOf(1.0f), "str", ExpressionTypes.FLOAT, ExpressionTypes.STRING);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [REAL, VARCHAR]", new Object[0]);
    }

    @Test
    public void parameterWithString() {
        String sql = "select case when 1 = 1 then ? else this end from map";
        this.put("str");
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but TINYINT was found", (byte)1);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but SMALLINT was found", (short)1);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but INTEGER was found", 1);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but BIGINT was found", 1L);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but DECIMAL was found", BigDecimal.ONE);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but DECIMAL was found", BigInteger.ONE);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but DOUBLE was found", 1.0);
        this.checkFailure0(sql, 2000, "Parameter at position 0 must be of VARCHAR type, but REAL was found", Float.valueOf(1.0f));
    }

    @Test
    public void dateTimeLiterals() {
        String sql = "select case        when true            then this             else '%s'        end from map";
        LocalDate date = LocalDate.now();
        this.put(date);
        this.checkValue0(String.format(sql, date.minusDays(1L)), SqlColumnType.DATE, date, new Object[0]);
        LocalTime time = LocalTime.now();
        this.put(time);
        this.checkValue0(String.format(sql, time.minusHours(1L)), SqlColumnType.TIME, time, new Object[0]);
        LocalDateTime dateTime = LocalDateTime.now();
        this.put(dateTime);
        this.checkValue0(String.format(sql, dateTime.minusHours(1L)), SqlColumnType.TIMESTAMP, dateTime, new Object[0]);
    }

    @Test
    public void date_time_typeConversion() {
        String sql = "select case when 1 = 1 then field1 else field2 end from map";
        this.putBiValue(LocalDate.of(2020, 12, 30), LocalTime.of(14, 2, 0), ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_TIME);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [DATE, TIME]", new Object[0]);
        this.putBiValue(LocalTime.of(14, 2, 0), LocalDate.of(2020, 12, 30), ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_DATE);
        this.checkFailure0(sql, 1008, "Cannot infer return type for CASE among [TIME, DATE]", new Object[0]);
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), LocalTime.of(14, 2, 0), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.LOCAL_TIME);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP, LocalDateTime.of(2020, 12, 30, 14, 2, 0), new Object[0]);
        this.putBiValue(LocalTime.of(14, 2, 0), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_DATE_TIME);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP, LocalDateTime.of(LocalDate.now(), LocalTime.of(14, 2, 0)), new Object[0]);
        this.putBiValue(LocalDate.of(2020, 12, 30), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_DATE_TIME);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP, LocalDate.of(2020, 12, 30).atStartOfDay(), new Object[0]);
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), LocalDate.of(2020, 12, 30), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.LOCAL_DATE);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP, LocalDateTime.of(2020, 12, 30, 14, 2, 0), new Object[0]);
        this.putBiValue(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), LocalTime.of(14, 2, 0), ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.LOCAL_TIME);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), new Object[0]);
        this.putBiValue(LocalTime.of(14, 2, 0), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), ExpressionTypes.LOCAL_TIME, ExpressionTypes.OFFSET_DATE_TIME);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, ZonedDateTime.of(LocalDateTime.of(LocalDate.now(), LocalTime.of(14, 2, 0)), ZoneId.systemDefault()).toOffsetDateTime(), new Object[0]);
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME);
        LocalDateTime dateTime = LocalDateTime.of(2020, 12, 30, 14, 2, 0);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.of(dateTime, ZoneId.systemDefault().getRules().getOffset(dateTime)), new Object[0]);
        this.putBiValue(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.LOCAL_DATE_TIME);
        this.checkValue0(sql, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), new Object[0]);
    }

    @Test
    public void numericWithObject() {
        String sql = "select case when 1 = 1 then field1 else field2 end from map";
        SerializableDummy field2 = new SerializableDummy();
        this.putBiValue((byte)1, field2, ExpressionTypes.BYTE, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, (byte)1, new Object[0]);
        this.putBiValue((short)1, field2, ExpressionTypes.SHORT, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, (short)1, new Object[0]);
        this.putBiValue(1, field2, ExpressionTypes.INTEGER, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, 1, new Object[0]);
        this.putBiValue(1L, field2, ExpressionTypes.LONG, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, 1L, new Object[0]);
        this.putBiValue(BigDecimal.ONE, field2, ExpressionTypes.BIG_DECIMAL, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, BigDecimal.ONE, new Object[0]);
        this.putBiValue(BigInteger.ONE, field2, ExpressionTypes.BIG_INTEGER, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, BigDecimal.ONE, new Object[0]);
        this.putBiValue(1.0, field2, ExpressionTypes.DOUBLE, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, 1.0, new Object[0]);
        this.putBiValue(Float.valueOf(1.0f), field2, ExpressionTypes.FLOAT, ExpressionTypes.OBJECT);
        this.checkValue0(sql, SqlColumnType.OBJECT, Float.valueOf(1.0f), new Object[0]);
    }

    private void putBiValue(Object field1, Object field2, ExpressionType<?> type1, ExpressionType<?> type2) {
        Object value = ExpressionBiValue.createBiValue(ExpressionBiValue.createBiClass(type1, type2), field1, field2);
        this.put(value);
    }

    @Test
    public void testEquality() {
        CaseOperatorIntegrationTest.checkEquals(this.when1eq1_then1_else10(), this.when1eq1_then1_else10(), true);
        CaseOperatorIntegrationTest.checkEquals(this.when1eq1_then1_else10(), this.when1eq10_then1_else10(), false);
        CaseOperatorIntegrationTest.checkEquals(this.when1eq1_then1_else10(), this.when1eq1_then_someText_else_anotherText(), false);
    }

    @Test
    public void testSerialization() {
        CaseExpression<?> original = this.when1eq1_then1_else10();
        CaseExpression restored = (CaseExpression)CaseOperatorIntegrationTest.serializeAndCheck(original, 70);
        CaseOperatorIntegrationTest.checkEquals(original, restored, true);
    }

    private CaseExpression<?> when1eq1_then_someText_else_anotherText() {
        return CaseExpression.create((Expression[])new Expression[]{ComparisonPredicate.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.EQUALS), ConstantExpression.create((Object)"someText", (QueryDataType)QueryDataType.VARCHAR), ConstantExpression.create((Object)"anotherText", (QueryDataType)QueryDataType.VARCHAR)});
    }

    private CaseExpression<?> when1eq1_then1_else10() {
        return CaseExpression.create((Expression[])new Expression[]{ComparisonPredicate.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.EQUALS), ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)20, (QueryDataType)QueryDataType.INT)});
    }

    private CaseExpression<?> when1eq10_then1_else10() {
        return CaseExpression.create((Expression[])new Expression[]{ComparisonPredicate.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT), (ComparisonMode)ComparisonMode.EQUALS), ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)20, (QueryDataType)QueryDataType.INT)});
    }

    private static class SerializableDummy
    implements Serializable {
        private SerializableDummy() {
        }
    }
}

