/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.AbsFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class AbsFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        this.checkColumn((byte)0, SqlColumnType.SMALLINT, (short)0);
        this.checkColumn((byte)1, SqlColumnType.SMALLINT, (short)1);
        this.checkColumn((byte)-1, SqlColumnType.SMALLINT, (short)1);
        this.checkColumn((byte)127, SqlColumnType.SMALLINT, (short)127);
        this.checkColumn((byte)-128, SqlColumnType.SMALLINT, (short)128);
        this.checkColumn((short)0, SqlColumnType.INTEGER, 0);
        this.checkColumn((short)1, SqlColumnType.INTEGER, 1);
        this.checkColumn((short)-1, SqlColumnType.INTEGER, 1);
        this.checkColumn((short)Short.MAX_VALUE, SqlColumnType.INTEGER, Short.MAX_VALUE);
        this.checkColumn((short)Short.MIN_VALUE, SqlColumnType.INTEGER, 32768);
        this.checkColumn(0, SqlColumnType.BIGINT, 0L);
        this.checkColumn(1, SqlColumnType.BIGINT, 1L);
        this.checkColumn(-1, SqlColumnType.BIGINT, 1L);
        this.checkColumn(Integer.MAX_VALUE, SqlColumnType.BIGINT, Integer.MAX_VALUE);
        this.checkColumn(Integer.MIN_VALUE, SqlColumnType.BIGINT, 0x80000000L);
        this.checkColumn(0L, SqlColumnType.BIGINT, 0L);
        this.checkColumn(1L, SqlColumnType.BIGINT, 1L);
        this.checkColumn(-1L, SqlColumnType.BIGINT, 1L);
        this.checkColumn(Long.MAX_VALUE, SqlColumnType.BIGINT, Long.MAX_VALUE);
        this.checkColumnFailure(Long.MIN_VALUE, 2000, "BIGINT overflow in ABS function (consider adding an explicit CAST to DECIMAL)");
        this.checkColumn(BigInteger.ZERO, SqlColumnType.DECIMAL, BigDecimal.ZERO);
        this.checkColumn(BigInteger.ONE, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(BigInteger.ONE.negate(), SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(BigDecimal.ZERO, SqlColumnType.DECIMAL, BigDecimal.ZERO);
        this.checkColumn(BigDecimal.ONE, SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(BigDecimal.ONE.negate(), SqlColumnType.DECIMAL, BigDecimal.ONE);
        this.checkColumn(Float.valueOf(0.0f), SqlColumnType.REAL, Float.valueOf(0.0f));
        this.checkColumn(Float.valueOf(-0.0f), SqlColumnType.REAL, Float.valueOf(0.0f));
        this.checkColumn(Float.valueOf(1.1f), SqlColumnType.REAL, Float.valueOf(1.1f));
        this.checkColumn(Float.valueOf(-1.1f), SqlColumnType.REAL, Float.valueOf(1.1f));
        this.checkColumn(Float.valueOf(Float.MAX_VALUE), SqlColumnType.REAL, Float.valueOf(Float.MAX_VALUE));
        this.checkColumn(Float.valueOf(Float.POSITIVE_INFINITY), SqlColumnType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.checkColumn(Float.valueOf(Float.NEGATIVE_INFINITY), SqlColumnType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.checkColumn(Float.valueOf(Float.NaN), SqlColumnType.REAL, Float.valueOf(Float.NaN));
        this.checkColumn(0.0, SqlColumnType.DOUBLE, 0.0);
        this.checkColumn(-0.0, SqlColumnType.DOUBLE, 0.0);
        this.checkColumn(1.1, SqlColumnType.DOUBLE, 1.1);
        this.checkColumn(-1.1, SqlColumnType.DOUBLE, 1.1);
        this.checkColumn(Double.MAX_VALUE, SqlColumnType.DOUBLE, Double.MAX_VALUE);
        this.checkColumn(Double.POSITIVE_INFINITY, SqlColumnType.DOUBLE, Double.POSITIVE_INFINITY);
        this.checkColumn(Double.NEGATIVE_INFINITY, SqlColumnType.DOUBLE, Double.POSITIVE_INFINITY);
        this.checkColumn(Double.NaN, SqlColumnType.DOUBLE, Double.NaN);
        this.checkColumnFailure("0", 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(true, 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN));
        this.checkColumnFailure(LOCAL_DATE_VAL, 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.DATE));
        this.checkColumnFailure(LOCAL_TIME_VAL, 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.TIME));
        this.checkColumnFailure(LOCAL_DATE_TIME_VAL, 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP));
        this.checkColumnFailure(OFFSET_DATE_TIME_VAL, 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE));
        this.checkColumnFailure(OBJECT_VAL, 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.OBJECT));
    }

    private void checkColumn(Object value, SqlColumnType expectedType, Object expectedResult) {
        this.put(value);
        this.check("this", expectedType, expectedResult, new Object[0]);
    }

    private void checkColumnFailure(Object value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        this.checkFailure("this", expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        long zero = 0L;
        long one = 1L;
        this.checkParameter((byte)0, zero);
        this.checkParameter((byte)1, one);
        this.checkParameter((byte)-1, one);
        this.checkParameter((byte)127, 127L);
        this.checkParameter((byte)-128, 128L);
        this.checkParameter((short)0, zero);
        this.checkParameter((short)1, one);
        this.checkParameter((short)-1, one);
        this.checkParameter((short)Short.MAX_VALUE, 32767L);
        this.checkParameter((short)Short.MIN_VALUE, 32768L);
        this.checkParameter(0, zero);
        this.checkParameter(1, one);
        this.checkParameter(-1, one);
        this.checkParameter(Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.checkParameter(Integer.MIN_VALUE, 0x80000000L);
        this.checkParameter(0L, zero);
        this.checkParameter(1L, one);
        this.checkParameter(-1L, one);
        this.checkParameter(Long.MAX_VALUE, Long.MAX_VALUE);
        this.checkFailure("?", 2000, "BIGINT overflow in ABS function (consider adding an explicit CAST to DECIMAL)", Long.MIN_VALUE);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigInteger.ZERO);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigDecimal.ZERO);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(0.0f));
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 0.0);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure("?", 2000, AbsFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private void checkParameter(Object parameterValue, Object expectedValue) {
        this.check("?", SqlColumnType.BIGINT, expectedValue, parameterValue);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkLiteral(1, SqlColumnType.TINYINT, (byte)1);
        this.checkLiteral(0, SqlColumnType.TINYINT, (byte)0);
        this.checkLiteral(-1, SqlColumnType.TINYINT, (byte)1);
        this.checkLiteral(126, SqlColumnType.SMALLINT, (short)126);
        this.checkLiteral((byte)127, SqlColumnType.SMALLINT, (short)127);
        this.checkLiteral((byte)-128, SqlColumnType.SMALLINT, (short)128);
        this.checkLiteral(32766, SqlColumnType.INTEGER, 32766);
        this.checkLiteral((short)Short.MAX_VALUE, SqlColumnType.INTEGER, Short.MAX_VALUE);
        this.checkLiteral((short)Short.MIN_VALUE, SqlColumnType.INTEGER, 32768);
        this.checkLiteral(0x7FFFFFFE, SqlColumnType.BIGINT, 0x7FFFFFFEL);
        this.checkLiteral(Integer.MAX_VALUE, SqlColumnType.BIGINT, Integer.MAX_VALUE);
        this.checkLiteral(Integer.MIN_VALUE, SqlColumnType.BIGINT, 0x80000000L);
        this.checkLiteral(0x7FFFFFFFFFFFFFFEL, SqlColumnType.BIGINT, 0x7FFFFFFFFFFFFFFEL);
        this.checkLiteral(Long.MAX_VALUE, SqlColumnType.BIGINT, Long.MAX_VALUE);
        this.check("null", SqlColumnType.BIGINT, null, new Object[0]);
        this.checkLiteral("1.1", SqlColumnType.DECIMAL, new BigDecimal("1.1"));
        this.checkLiteral("0.0", SqlColumnType.DECIMAL, new BigDecimal("0.0"));
        this.checkLiteral("-1.1", SqlColumnType.DECIMAL, new BigDecimal("1.1"));
        this.checkLiteral("0.0E0", SqlColumnType.DOUBLE, 0.0);
        this.checkLiteral("-0.0E0", SqlColumnType.DOUBLE, 0.0);
        this.checkLiteral("1.1E0", SqlColumnType.DOUBLE, 1.1);
        this.checkLiteral("-1.1E0", SqlColumnType.DOUBLE, 1.1);
        this.checkFailure(Long.MIN_VALUE, 2000, "BIGINT overflow in ABS function (consider adding an explicit CAST to DECIMAL)", new Object[0]);
        this.checkFailure("'foo'", 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure("true", 1008, AbsFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
    }

    private static String signatureError(SqlColumnType type) {
        return AbsFunctionIntegrationTest.signatureErrorFunction("ABS", type);
    }

    private void checkLiteral(Object literal, SqlColumnType expectedType, Object expectedValue) {
        this.check(literal.toString(), expectedType, expectedValue, new Object[0]);
    }

    private void check(Object operand, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        String sql = "SELECT ABS(" + String.valueOf(operand) + ") FROM map";
        this.checkValue0(sql, expectedType, expectedValue, params);
    }

    private void checkFailure(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = "SELECT ABS(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    @Test
    public void testEquals() {
        AbsFunction function = AbsFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT);
        AbsFunctionIntegrationTest.checkEquals(function, AbsFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), true);
        AbsFunctionIntegrationTest.checkEquals(function, AbsFunction.create((Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        AbsFunctionIntegrationTest.checkEquals(function, AbsFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.VARCHAR), false);
    }

    @Test
    public void testSerialization() {
        AbsFunction original = AbsFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT);
        AbsFunction restored = (AbsFunction)AbsFunctionIntegrationTest.serializeAndCheck(original, 51);
        AbsFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

