/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.partition.Partition;
import com.hazelcast.partition.PartitionService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;

abstract class SqlIndexTestSupport
extends OptimizerTestSupport {
    SqlIndexTestSupport() {
    }

    protected static String toLiteral(ExpressionType type, Object value) {
        if (type == ExpressionTypes.BOOLEAN) {
            return Boolean.toString((Boolean)value);
        }
        if (type == ExpressionTypes.BYTE) {
            return Byte.toString((Byte)value);
        }
        if (type == ExpressionTypes.SHORT) {
            return Short.toString((Short)value);
        }
        if (type == ExpressionTypes.INTEGER) {
            return Integer.toString((Integer)value);
        }
        if (type == ExpressionTypes.LONG) {
            return Long.toString((Long)value);
        }
        if (type == ExpressionTypes.BIG_DECIMAL) {
            return value.toString();
        }
        if (type == ExpressionTypes.BIG_INTEGER) {
            return value.toString();
        }
        if (type == ExpressionTypes.FLOAT) {
            return Float.toString(((Float)value).floatValue());
        }
        if (type == ExpressionTypes.DOUBLE) {
            return Double.toString((Double)value);
        }
        if (type == ExpressionTypes.STRING) {
            return "'" + String.valueOf(value) + "'";
        }
        if (type == ExpressionTypes.CHARACTER) {
            return "'" + String.valueOf(value) + "'";
        }
        throw new UnsupportedOperationException("Unsupported type: " + String.valueOf(type));
    }

    protected static List<ExpressionType<?>> quickTestTypes() {
        return Arrays.asList(ExpressionTypes.INTEGER, ExpressionTypes.STRING);
    }

    protected static List<ExpressionType<?>> slowTestTypes() {
        return Arrays.asList(ExpressionTypes.BOOLEAN, ExpressionTypes.BYTE, ExpressionTypes.SHORT, ExpressionTypes.LONG, ExpressionTypes.BIG_DECIMAL, ExpressionTypes.BIG_INTEGER, ExpressionTypes.FLOAT, ExpressionTypes.DOUBLE, ExpressionTypes.CHARACTER);
    }

    protected static List<ExpressionType<?>> allTypes() {
        return Arrays.asList(ExpressionTypes.BOOLEAN, ExpressionTypes.BYTE, ExpressionTypes.SHORT, ExpressionTypes.INTEGER, ExpressionTypes.LONG, ExpressionTypes.BIG_DECIMAL, ExpressionTypes.BIG_INTEGER, ExpressionTypes.FLOAT, ExpressionTypes.DOUBLE, ExpressionTypes.STRING, ExpressionTypes.CHARACTER);
    }

    protected static <K> K getLocalKey(HazelcastInstance member, IntFunction<K> keyProducer) {
        return SqlIndexTestSupport.getLocalKeys(member, 1, keyProducer).get(0);
    }

    protected static <K> List<K> getLocalKeys(HazelcastInstance member, int count, IntFunction<K> keyProducer) {
        return new ArrayList<K>(SqlIndexTestSupport.getLocalEntries(member, count, keyProducer, keyProducer).keySet());
    }

    protected static <K, V> Map<K, V> getLocalEntries(HazelcastInstance member, int count, IntFunction<K> keyProducer, IntFunction<V> valueProducer) {
        if (count == 0) {
            return Collections.emptyMap();
        }
        PartitionService partitionService = member.getPartitionService();
        LinkedHashMap<K, V> res = new LinkedHashMap<K, V>();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            V value;
            Partition partition;
            K key = keyProducer.apply(i);
            if (key == null || !(partition = partitionService.getPartition(key)).getOwner().localMember() || (value = valueProducer.apply(i)) == null) continue;
            res.put(key, value);
            if (res.size() == count) break;
        }
        if (res.size() < count) {
            throw new RuntimeException("Failed to get the necessary number of keys: " + res.size());
        }
        return res;
    }
}

