/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.IndexType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.map.index.SqlIndexTestSupport;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlIndexResolutionTest
extends SqlIndexTestSupport {
    private NodeEngine nodeEngine;
    private TableResolver resolver;
    private String mapName;
    private String indexName;
    private IMap<Integer, ? super ExpressionBiValue> map;
    private Class<? extends ExpressionBiValue> valueClass;
    private ExpressionBiValue value;
    @Parameterized.Parameter
    public IndexType indexType;
    @Parameterized.Parameter(value=1)
    public boolean composite;
    @Parameterized.Parameter(value=2)
    public ExpressionType<?> type1;
    @Parameterized.Parameter(value=3)
    public ExpressionType<?> type2;

    @Parameterized.Parameters(name="indexType:{0}, composite:{1}, type1:{2}, type2:{3}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        for (IndexType indexType : Arrays.asList(IndexType.SORTED, IndexType.HASH)) {
            for (boolean composite : Arrays.asList(true, false)) {
                for (ExpressionType<?> t1 : SqlIndexResolutionTest.quickTestTypes()) {
                    for (ExpressionType<?> t2 : SqlIndexResolutionTest.quickTestTypes()) {
                        res.add(new Object[]{indexType, composite, t1, t2});
                    }
                }
            }
        }
        return res;
    }

    @BeforeClass
    public static void beforeClass() {
        SqlIndexResolutionTest.initialize((int)3, null);
    }

    @Before
    public void before() throws Exception {
        String[] stringArray;
        this.nodeEngine = Util.getNodeEngine((HazelcastInstance)SqlIndexResolutionTest.instance());
        this.resolver = new TableResolverImpl(this.nodeEngine, new RelationsStorage(this.nodeEngine), new SqlConnectorCache(this.nodeEngine));
        this.mapName = SqlIndexResolutionTest.randomName();
        this.indexName = SqlIndexResolutionTest.randomName();
        if (this.composite) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "field1";
            stringArray = stringArray2;
            stringArray2[1] = "field2";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "field1";
        }
        String[] indexAttributes = stringArray;
        this.valueClass = ExpressionBiValue.createBiClass(this.type1, this.type2);
        this.value = ExpressionBiValue.createBiValue(this.valueClass, 1, this.type1.valueFrom(), this.composite ? this.type2.valueFrom() : null);
        this.map = SqlIndexResolutionTest.instance().getMap(this.mapName);
        SqlIndexResolutionTest.createMapping(this.mapName, Integer.TYPE, this.value.getClass());
        SqlIndexResolutionTest.createIndex(this.indexName, this.mapName, this.indexType, indexAttributes);
    }

    @Test
    public void testIndexResolution() {
        this.putValues();
        this.checkIndex(this.map, this.composite ? Arrays.asList(this.type1.getFieldConverterType(), this.type2.getFieldConverterType()) : Collections.singletonList(this.type1.getFieldConverterType()));
        this.checkIndexUsage(this.map, true, this.composite);
    }

    private void checkIndex(IMap<?, ?> map, List<QueryDataType> expectedFieldConverterTypes) {
        String mapName = map.getName();
        List tables = this.resolver.getTables().stream().filter(t -> t instanceof PartitionedMapTable).map(t -> (PartitionedMapTable)t).filter(t -> t.getMapName().equals(mapName)).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)tables.size());
        PartitionedMapTable table = (PartitionedMapTable)tables.get(0);
        Assert.assertEquals((long)1L, (long)table.getIndexes().size());
        MapTableIndex index = (MapTableIndex)table.getIndexes().get(0);
        Assert.assertEquals((Object)this.indexName, (Object)index.getName());
        Assert.assertEquals((Object)this.indexType, (Object)index.getType());
        Assert.assertEquals((long)(this.composite ? 2L : 1L), (long)index.getComponentsCount());
        int field1Ordinal = SqlIndexResolutionTest.findFieldOrdinal(table, "field1");
        int field2Ordinal = SqlIndexResolutionTest.findFieldOrdinal(table, "field2");
        Assert.assertTrue((expectedFieldConverterTypes.size() <= 2 ? 1 : 0) != 0);
        Assert.assertEquals(expectedFieldConverterTypes, (Object)index.getFieldConverterTypes());
        if (expectedFieldConverterTypes.isEmpty()) {
            Assert.assertTrue((boolean)index.getFieldOrdinals().isEmpty());
        } else if (expectedFieldConverterTypes.size() == 1) {
            Assert.assertEquals(Collections.singletonList(field1Ordinal), (Object)index.getFieldOrdinals());
        } else {
            Assert.assertEquals(Arrays.asList(field1Ordinal, field2Ordinal), (Object)index.getFieldOrdinals());
        }
    }

    private static int findFieldOrdinal(PartitionedMapTable table, String fieldName) {
        for (int i = 0; i < table.getFieldCount(); ++i) {
            MapTableField field = (MapTableField)table.getField(i);
            if (!field.getName().equals(fieldName)) continue;
            return i;
        }
        Assert.fail((String)("Failed to find the field \"" + fieldName + "\""));
        return -1;
    }

    private void checkIndexUsage(IMap<?, ?> map, boolean firstResolved, boolean secondResolved) {
        String field1Literal = SqlIndexResolutionTest.toLiteral(this.type1, this.type1.valueFrom());
        String field2Literal = SqlIndexResolutionTest.toLiteral(this.type2, this.type2.valueFrom());
        Usage expectedUsage = firstResolved ? (secondResolved ? Usage.BOTH : (this.composite && this.indexType == IndexType.HASH ? Usage.NONE : Usage.ONE)) : Usage.NONE;
        SqlStatement sql = new SqlStatement("SELECT * FROM " + map.getName() + " WHERE field1=" + field1Literal + " AND field2=" + field2Literal);
        this.checkIndexUsage(sql, map.getName(), expectedUsage);
    }

    private void checkIndexUsage(SqlStatement statement, String mapName, Usage expectedIndexUsage) {
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, QueryDataType.OBJECT, QueryDataType.INT);
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("field1", this.type1.getFieldConverterType(), false, new QueryPath("field1", false)), new MapTableField("field2", this.type2.getFieldConverterType(), false, new QueryPath("field2", false)));
        HazelcastTable table = SqlIndexResolutionTest.partitionedTable(mapName, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlIndexResolutionTest.mapContainer(SqlIndexResolutionTest.instance().getMap(mapName)), mapTableFields), 1L);
        OptimizerTestSupport.Result optimizationResult = this.optimizePhysical(statement.getSql(), parameterTypes, table);
        SqlIndexResolutionTest.assertPlan((RelNode)optimizationResult.getLogical(), SqlIndexResolutionTest.plan(SqlIndexResolutionTest.planRow(0, FullScanLogicalRel.class)));
        switch (expectedIndexUsage) {
            case NONE: {
                SqlIndexResolutionTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexResolutionTest.plan(SqlIndexResolutionTest.planRow(0, FullScanPhysicalRel.class)));
                break;
            }
            case ONE: {
                SqlIndexResolutionTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexResolutionTest.plan(SqlIndexResolutionTest.planRow(0, IndexScanMapPhysicalRel.class)));
                Assert.assertNotNull((Object)((IndexScanMapPhysicalRel)optimizationResult.getPhysical()).getRemainderExp());
                break;
            }
            case BOTH: {
                SqlIndexResolutionTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexResolutionTest.plan(SqlIndexResolutionTest.planRow(0, IndexScanMapPhysicalRel.class)));
                Assert.assertNull((Object)((IndexScanMapPhysicalRel)optimizationResult.getPhysical()).getRemainderExp());
            }
        }
    }

    private void putValues() {
        for (int i = 1; i <= 100; ++i) {
            this.map.put((Object)i, (Object)this.value);
        }
    }

    private static enum Usage {
        NONE,
        ONE,
        BOTH;

    }
}

