/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.core.TestUtil;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlPrimitiveTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlPrimitiveTest.initialize((int)1, null);
        sqlService = SqlPrimitiveTest.instance().getSql();
    }

    @Test
    public void test_sinkSelect() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        String from = SqlPrimitiveTest.randomName();
        TestBatchSqlConnector.create(sqlService, from, 4);
        SqlPrimitiveTest.assertMapEventually(name, "SINK INTO " + name + " SELECT v, 'value-' || v FROM " + from, TestUtil.createMap((Object[])new Object[]{0, "value-0", 1, "value-1", 2, "value-2", 3, "value-3"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name + " WHERE __key > 0 AND __key < 3", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
    }

    @Test
    public void test_sinkValues() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        SqlPrimitiveTest.assertMapEventually(name, "SINK INTO " + name + " (this, __key) VALUES ('2', 1)", TestUtil.createMap((Object[])new Object[]{1, "2"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, "2")));
    }

    @Test
    public void test_sinkWithProject() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        SqlPrimitiveTest.assertMapEventually(name, "SINK INTO " + name + " (this, __key) VALUES ('2', CAST(0 + 1 AS INT))", TestUtil.createMap((Object[])new Object[]{1, "2"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, "2")));
    }

    @Test
    public void test_sinkWithDynamicParameters() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        SqlPrimitiveTest.assertMapEventually(name, "SINK INTO " + name + " (this, __key) VALUES (?, CAST(0 + ? AS INT))", Arrays.asList("2", 1), TestUtil.createMap((Object[])new Object[]{1, "2"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, "2")));
    }

    @Test
    public void test_selectWithDynamicParameters() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        sqlService.execute("SINK INTO " + name + " VALUES (1, '1'), (2, '2')", new Object[0]);
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT __key + ?, ABS(__key + ?), this FROM " + name + " WHERE __key + ? >= ?", Arrays.asList(2, -10, 2, 4), Collections.singletonList(new SqlTestSupport.Row(4L, 8L, "2")));
    }

    @Test
    public void test_renameKey() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map (id INT EXTERNAL NAME __key, this VARCHAR) TYPE IMap OPTIONS ('keyFormat'='int', 'valueFormat'='varchar')", new Object[0])).hasMessageContaining("Cannot rename field: '__key'");
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map (__key INT EXTERNAL NAME renamed, this VARCHAR) TYPE IMap OPTIONS ('keyFormat'='int', 'valueFormat'='varchar')", new Object[0])).hasMessageContaining("Cannot rename field: '__key'");
    }

    @Test
    public void test_renameThis() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map (__key INT, name VARCHAR EXTERNAL NAME this) TYPE IMap OPTIONS ('keyFormat'='int', 'valueFormat'='varchar')", new Object[0])).hasMessageContaining("Cannot rename field: 'this'");
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map (__key INT, this VARCHAR EXTERNAL NAME renamed) TYPE IMap OPTIONS ('keyFormat'='int', 'valueFormat'='varchar')", new Object[0])).hasMessageContaining("Cannot rename field: 'this'");
    }

    @Test
    public void test_objectAndMappingNameDifferent() {
        String mapName = SqlPrimitiveTest.randomName();
        String tableName = SqlPrimitiveTest.randomName();
        sqlService.execute("CREATE MAPPING " + tableName + " EXTERNAL NAME " + mapName + " TYPE IMap OPTIONS ('keyFormat'='java', 'keyJavaClass'='" + String.class.getName() + "', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0]);
        IMap map = SqlPrimitiveTest.instance().getMap(mapName);
        map.put((Object)"k1", (Object)"v1");
        map.put((Object)"k2", (Object)"v2");
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + tableName, Arrays.asList(new SqlTestSupport.Row("k1", "v1"), new SqlTestSupport.Row("k2", "v2")));
    }

    @Test
    public void test_explicitKeyAndThis() {
        String mapName = SqlPrimitiveTest.randomName();
        sqlService.execute("CREATE MAPPING " + mapName + "(__key INT,this VARCHAR) TYPE IMap OPTIONS ( 'keyFormat'='java', 'keyJavaClass'='" + Integer.class.getName() + "', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0]);
        sqlService.execute("SINK INTO " + mapName + " VALUES(42, 'foo')", new Object[0]);
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + mapName, Collections.singletonList(new SqlTestSupport.Row(42, "foo")));
    }

    @Test
    public void test_explicitKeyAndThisWithExternalNames() {
        String mapName = SqlPrimitiveTest.randomName();
        sqlService.execute("CREATE MAPPING " + mapName + "(__key INT EXTERNAL NAME __key, this VARCHAR EXTERNAL NAME this) TYPE IMap OPTIONS ( 'keyFormat'='java', 'keyJavaClass'='" + Integer.class.getName() + "', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0]);
        sqlService.execute("SINK INTO " + mapName + " VALUES(42, 'foo')", new Object[0]);
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + mapName, Collections.singletonList(new SqlTestSupport.Row(42, "foo")));
    }

    @Test
    public void test_noKeyFormat() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map TYPE IMap OPTIONS ('valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0])).hasMessage("Missing 'keyFormat' option");
    }

    @Test
    public void test_noValueFormat() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map TYPE IMap OPTIONS ('keyFormat'='java', 'keyJavaClass'='" + Integer.class.getName() + "')", new Object[0])).hasMessage("Missing 'valueFormat' option");
    }

    @Test
    public void when_keyColumnIsNotDeclared_then_itIsHidden() {
        String name = SqlPrimitiveTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + "(this VARCHAR) TYPE IMap OPTIONS ( 'keyFormat'='int', 'valueFormat'='varchar')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + name + " VALUES(1, 'Alice')", new Object[0])).hasMessageContaining("Number of INSERT target columns (1) does not equal number of source items (2)");
        SqlPrimitiveTest.assertMapEventually(name, "SINK INTO " + name + "(__key, this) VALUES (2, 'Bob')", TestUtil.createMap((Object[])new Object[]{2, "Bob"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row("Bob")));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, Collections.singletonList(new SqlTestSupport.Row(2, "Bob")));
    }

    @Test
    public void when_valueColumnIsNotDeclared_then_itIsHidden() {
        String name = SqlPrimitiveTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + "(__key INT EXTERNAL NAME __key) TYPE IMap OPTIONS ( 'keyFormat'='int', 'valueFormat'='varchar')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + name + " VALUES(1, 'Alice')", new Object[0])).hasMessageContaining("Number of INSERT target columns (1) does not equal number of source items (2)");
        SqlPrimitiveTest.assertMapEventually(name, "SINK INTO " + name + "(__key, this) VALUES (2, 'Bob')", TestUtil.createMap((Object[])new Object[]{2, "Bob"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(2)));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, Collections.singletonList(new SqlTestSupport.Row(2, "Bob")));
    }

    @Test
    public void when_insert() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        SqlPrimitiveTest.assertMapEventually(name, "INSERT INTO " + name + " (this, __key) VALUES ('1', 1)", TestUtil.createMap((Object[])new Object[]{1, "1"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, "1")));
    }

    @Test
    public void when_insertMultipleEntries() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        SqlPrimitiveTest.assertMapEventually(name, "INSERT INTO " + name + " (this, __key) VALUES ('1', 1), ('2', 2)", TestUtil.createMap((Object[])new Object[]{1, "1", 2, "2"}));
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + name, Arrays.asList(new SqlTestSupport.Row(1, "1"), new SqlTestSupport.Row(2, "2")));
    }

    @Test
    public void when_insertNoEntries() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        sqlService.execute("INSERT INTO " + name + " SELECT * FROM (VALUES (1, '1')) AS t(a, b) WHERE a = 0", new Object[0]);
        Assertions.assertThat((Collection)SqlPrimitiveTest.instance().getMap(name).entrySet()).isEmpty();
    }

    @Test
    public void when_insertAndKeyAlreadyExists_then_fail() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        sqlService.execute("INSERT INTO " + name + " VALUES (1, '1')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("INSERT INTO " + name + " VALUES (1, '2')", new Object[0])).hasMessageContaining("Duplicate key");
    }

    @Test
    public void when_insertMultipleEntriesAndKeyAlreadyExists_then_fail() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        sqlService.execute("INSERT INTO " + name + " VALUES (1, '1')", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("INSERT INTO " + name + " VALUES (1, '2'), (2, '2')", new Object[0])).hasMessageContaining("Duplicate key");
    }

    @Test
    public void when_insertDuplicateKey_then_fail() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.createMapping(name, Integer.class, String.class);
        Assertions.assertThatThrownBy(() -> sqlService.execute("INSERT INTO " + name + " VALUES (1, '1'), (1, '2')", new Object[0])).hasMessageContaining("Duplicate key");
    }

    @Test
    public void when_typeMismatch_then_fail() {
        String name = SqlPrimitiveTest.randomName();
        SqlPrimitiveTest.instance().getMap(name).put((Object)0, (Object)0);
        SqlPrimitiveTest.createMapping(name, String.class, String.class);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT __key FROM " + name, new Object[0]).iterator().forEachRemaining(row -> {})).hasMessageContaining("Failed to extract map entry key because of type mismatch [expectedClass=java.lang.String, actualClass=java.lang.Integer]");
    }

    @Test
    public void test_multipleFieldsForPrimitive_key() {
        this.test_multipleFieldsForPrimitive("__key");
    }

    @Test
    public void test_multipleFieldsForPrimitive_value() {
        this.test_multipleFieldsForPrimitive("this");
    }

    private void test_multipleFieldsForPrimitive(String fieldName) {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map (" + fieldName + " INT, field INT EXTERNAL NAME \"" + fieldName + ".field\") TYPE IMap OPTIONS ('valueFormat'='java', 'valueJavaClass'='" + Integer.class.getName() + "', 'keyFormat'='java', 'keyJavaClass'='" + Integer.class.getName() + "')", new Object[0])).hasMessage("The field '" + fieldName + "' is of type INTEGER, you can't map '" + fieldName + ".field' too");
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_varchar() {
        this.test_simplePrimitiveTypeSyntax("varchar", "foo");
        this.test_simplePrimitiveTypeSyntax("character varying", "foo");
        this.test_simplePrimitiveTypeSyntax("char varying", "foo");
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_boolean() {
        this.test_simplePrimitiveTypeSyntax("boolean", true);
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_tinyint() {
        this.test_simplePrimitiveTypeSyntax("tinyint", (byte)42);
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_smallint() {
        this.test_simplePrimitiveTypeSyntax("smallint", (short)42);
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_int() {
        this.test_simplePrimitiveTypeSyntax("int", 42);
        this.test_simplePrimitiveTypeSyntax("integer", 42);
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_bigint() {
        this.test_simplePrimitiveTypeSyntax("bigint", 42L);
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_decimal() {
        this.test_simplePrimitiveTypeSyntax("decimal", BigDecimal.valueOf(42L));
        this.test_simplePrimitiveTypeSyntax("dec", BigDecimal.valueOf(42L));
        this.test_simplePrimitiveTypeSyntax("numeric", BigDecimal.valueOf(42L));
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_real() {
        this.test_simplePrimitiveTypeSyntax("real", Float.valueOf(42.0f));
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_double() {
        this.test_simplePrimitiveTypeSyntax("double", 42.0);
        this.test_simplePrimitiveTypeSyntax("double precision", 42.0);
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_time() {
        this.test_simplePrimitiveTypeSyntax("time", LocalTime.of(10, 42));
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_date() {
        this.test_simplePrimitiveTypeSyntax("date", LocalDate.of(1942, 4, 2));
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_timestamp() {
        this.test_simplePrimitiveTypeSyntax("timestamp", LocalDateTime.of(1942, 4, 2, 10, 42));
    }

    @Test
    public void test_simplePrimitiveTypeSyntax_timestampWithTz() {
        this.test_simplePrimitiveTypeSyntax("timestamp with time zone", OffsetDateTime.of(1042, 4, 2, 10, 42, 0, 0, ZoneOffset.ofHours(4)));
    }

    private void test_simplePrimitiveTypeSyntax(String format, Object testValue) {
        String mapName = SqlPrimitiveTest.randomName();
        sqlService.execute("CREATE MAPPING " + mapName + " TYPE IMap OPTIONS ('keyFormat'='" + format + "','valueFormat'='" + format + "')", new Object[0]);
        SqlPrimitiveTest.instance().getMap(mapName).put(testValue, testValue);
        SqlPrimitiveTest.assertRowsAnyOrder("SELECT * FROM " + mapName, Collections.singletonList(new SqlTestSupport.Row(testValue, testValue)));
    }

    @Test
    public void test_selectByKey_nonExistentKey() {
        SqlPrimitiveTest.instance().getSql().execute("CREATE MAPPING m  TYPE IMap  OPTIONS ( 'keyFormat' = 'int', 'valueFormat' = 'int')", new Object[0]);
        SqlPrimitiveTest.assertRowsAnyOrder(SqlPrimitiveTest.instance(), "SELECT * FROM m WHERE __key = 1", Collections.emptyList());
    }
}

