/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.Config;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.test.HazelcastSerialClassRunner;
import java.io.IOException;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class SqlPortableCompoundKeysTest
extends SqlTestSupport {
    @BeforeClass
    public static void setUp() throws Exception {
        Config config = SqlPortableCompoundKeysTest.smallInstanceConfig();
        config.getSerializationConfig().addPortableFactory(1338, (PortableFactory)new MyPortableFactory());
        SqlPortableCompoundKeysTest.initialize((int)1, (Config)config);
    }

    @Test
    public void when_portableObjectHasEmptyDefaultCtor_then_fails() {
        String mapName = SqlPortableCompoundKeysTest.randomName();
        IMap map = SqlPortableCompoundKeysTest.instance().getMap(mapName);
        Assertions.assertThatThrownBy(() -> SqlPortableCompoundKeysTest.instance().getSql().execute("CREATE OR REPLACE MAPPING " + mapName + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1338', 'keyPortableClassId'='1', 'keyPortableClassVersion'='0', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0])).hasMessageContaining("Cannot create mapping for Portable type");
    }

    @Test
    public void when_portableObjectHasNonEmptyDefaultCtor_then_ok() {
        String mapName = SqlPortableCompoundKeysTest.randomName();
        IMap map = SqlPortableCompoundKeysTest.instance().getMap(mapName);
        try (SqlResult result = SqlPortableCompoundKeysTest.instance().getSql().execute("CREATE OR REPLACE MAPPING " + mapName + " TYPE IMap OPTIONS ('keyFormat'='portable', 'keyPortableFactoryId'='1338', 'keyPortableClassId'='2', 'keyPortableClassVersion'='0', 'valueFormat'='java', 'valueJavaClass'='" + String.class.getName() + "')", new Object[0]);){
            Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
        }
        SqlPortableCompoundKeysTest.assertRowsAnyOrder("SELECT __key, this FROM " + mapName, Collections.emptyList());
    }

    public static class MyPortableFactory
    implements PortableFactory {
        public static final int ID = 1338;

        public Portable create(int classId) {
            if (classId == 1) {
                return new PortablePojoEmptyDefaultCtor();
            }
            if (classId == 2) {
                return new PortablePojoDefaultingDefaultCtor();
            }
            return null;
        }
    }

    public static class PortablePojoDefaultingDefaultCtor
    extends PortablePojoEmptyDefaultCtor {
        public static final int ID = 2;

        public PortablePojoDefaultingDefaultCtor() {
            this.f0 = 0;
            this.f1 = 0;
            this.f2 = 0;
        }

        public PortablePojoDefaultingDefaultCtor(Integer f0, Integer f1, Integer f2) {
            super(f0, f1, f2);
        }

        @Override
        public int getClassId() {
            return 2;
        }

        @Override
        public void writePortable(PortableWriter writer) throws IOException {
            super.writePortable(writer);
        }

        @Override
        public void readPortable(PortableReader reader) throws IOException {
            super.readPortable(reader);
        }
    }

    public static class PortablePojoEmptyDefaultCtor
    implements Portable {
        public static final int ID = 1;
        protected Integer f0;
        protected Integer f1;
        protected Integer f2;

        public PortablePojoEmptyDefaultCtor() {
        }

        public PortablePojoEmptyDefaultCtor(Integer f0, Integer f1, Integer f2) {
            this.f0 = f0;
            this.f1 = f1;
            this.f2 = f2;
        }

        public Integer getF0() {
            return this.f0;
        }

        public void setF0(Integer f0) {
            this.f0 = f0;
        }

        public Integer getF1() {
            return this.f1;
        }

        public void setF1(Integer f1) {
            this.f1 = f1;
        }

        public Integer getF2() {
            return this.f2;
        }

        public void setF2(Integer f2) {
            this.f2 = f2;
        }

        public int getFactoryId() {
            return 1338;
        }

        public int getClassId() {
            return 1;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("f0", this.f0.intValue());
            writer.writeInt("f1", this.f1.intValue());
            writer.writeInt("f2", this.f2.intValue());
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.f0 = reader.readInt("f0");
            this.f1 = reader.readInt("f1");
            this.f2 = reader.readInt("f2");
        }
    }
}

