/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.Projector;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.sql.impl.expression.CastExpression;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ProjectorTest {
    @Test
    public void test_project() {
        Projector projector = new Projector(new QueryPath[]{QueryPath.create((String)"this.field")}, new QueryDataType[]{QueryDataType.BIGINT}, (UpsertTarget)new MultiplyingTarget(), Collections.singletonList(CastExpression.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT)), (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class));
        Object value = projector.project(new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{1}));
        Assertions.assertThat((Object)value).isEqualTo((Object)2L);
    }

    @Test
    public void test_supplierSerialization() {
        InternalSerializationService serializationService = new DefaultSerializationServiceBuilder().build();
        Projector.Supplier original = Projector.supplier((QueryPath[])new QueryPath[]{QueryPath.create((String)"this.field")}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT}, (UpsertTargetDescriptor)PrimitiveUpsertTargetDescriptor.INSTANCE, Collections.singletonList(ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT)));
        Projector.Supplier serialized = (Projector.Supplier)serializationService.toObject((Object)serializationService.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }

    private static final class MultiplyingTarget
    implements UpsertTarget {
        private Object value = -1;

        private MultiplyingTarget() {
        }

        public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
            return value -> {
                this.value = value;
            };
        }

        public void init() {
            this.value = null;
        }

        public Object conclude() {
            return (Long)this.value * 2L;
        }
    }
}

