/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.JoinByPrimitiveKeyProcessorSupplier;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JoinByPrimitiveKeyProcessorTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static final Expression<Boolean> TRUE_PREDICATE = ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN);
    private static final Expression<?> PROJECTION = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.VARCHAR);
    private static final Expression<Boolean> FALSE_PREDICATE = ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN);
    private IMap<Object, Object> map;

    @BeforeClass
    public static void beforeClass() {
        JoinByPrimitiveKeyProcessorTest.initialize((int)2, null);
    }

    @Before
    public void before() {
        this.map = JoinByPrimitiveKeyProcessorTest.instance().getMap(MAP_NAME);
    }

    @Test
    public void when_innerJoinLeftKeyIsNull_then_emptyResult() {
        this.runTest(TRUE_PREDICATE, PROJECTION, TRUE_PREDICATE, true, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(new Object[]{null})), Collections.emptyList());
    }

    @Test
    public void when_innerJoinRightValueIsNull_then_emptyResult() {
        this.runTest(TRUE_PREDICATE, PROJECTION, TRUE_PREDICATE, true, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void when_innerJoinFilteredOutByProjector_then_emptyResult() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(FALSE_PREDICATE, PROJECTION, TRUE_PREDICATE, true, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void when_innerJoinProjectedByProjector_then_modified() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(TRUE_PREDICATE, (Expression<?>)ConstantExpression.create((Object)"modified", (QueryDataType)QueryDataType.VARCHAR), TRUE_PREDICATE, true, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1, "modified")));
    }

    @Test
    public void when_innerJoinFilteredOutByCondition_then_absent() {
        this.map.put((Object)1, (Object)"value-1");
        this.runTest(TRUE_PREDICATE, PROJECTION, FALSE_PREDICATE, true, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void when_outerJoinLeftKeyIsNull_then_nulls() {
        this.runTest(TRUE_PREDICATE, PROJECTION, TRUE_PREDICATE, false, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(new Object[]{null})), Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(null, null)));
    }

    @Test
    public void when_outerJoinRightValueIsNull_then_nulls() {
        this.runTest(TRUE_PREDICATE, PROJECTION, TRUE_PREDICATE, false, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1, null)));
    }

    @Test
    public void when_outerJoinFilteredOutByProjector_then_nulls() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(FALSE_PREDICATE, PROJECTION, TRUE_PREDICATE, false, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1, null)));
    }

    @Test
    public void when_outerJoinProjectedByProjector_then_modified() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(TRUE_PREDICATE, (Expression<?>)ConstantExpression.create((Object)"modified", (QueryDataType)QueryDataType.VARCHAR), TRUE_PREDICATE, false, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1, "modified")));
    }

    @Test
    public void when_outerJoinFilteredOutByCondition_then_nulls() {
        this.map.put((Object)1, (Object)"value-1");
        this.runTest(TRUE_PREDICATE, PROJECTION, FALSE_PREDICATE, false, Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1)), Collections.singletonList(JoinByPrimitiveKeyProcessorTest.jetRow(1, null)));
    }

    private void runTest(Expression<Boolean> rowProjectorCondition, Expression<?> rowProjectorProjection, Expression<Boolean> joinCondition, boolean inner, List<JetSqlRow> input, List<JetSqlRow> output) {
        KvRowProjector.Supplier projectorSupplier = KvRowProjector.supplier((QueryPath[])new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT, QueryDataType.VARCHAR}, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, rowProjectorCondition, Collections.singletonList(rowProjectorProjection));
        JoinByPrimitiveKeyProcessorSupplier processor = new JoinByPrimitiveKeyProcessorSupplier(inner, 0, joinCondition, MAP_NAME, projectorSupplier);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)processor)).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).input(input).hazelcastInstance(JoinByPrimitiveKeyProcessorTest.instance()).outputChecker(SqlTestSupport::compareRowLists).disableProgressAssertion().expectOutput(output);
    }
}

