/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.jet.sql.impl.connector.map.JoinByEquiJoinProcessorSupplier;
import com.hazelcast.map.IMap;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JoinByEquiJoinProcessorTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private static final Expression<Boolean> TRUE_PREDICATE = ConstantExpression.create((Object)true, (QueryDataType)QueryDataType.BOOLEAN);
    private static final Expression<?> PROJECTION = ColumnExpression.create((int)1, (QueryDataType)QueryDataType.VARCHAR);
    private static final Expression<Boolean> FALSE_PREDICATE = ConstantExpression.create((Object)false, (QueryDataType)QueryDataType.BOOLEAN);
    private IMap<Object, Object> map;

    @BeforeClass
    public static void beforeClass() {
        JoinByEquiJoinProcessorTest.initialize((int)1, null);
    }

    @Before
    public void before() {
        this.map = JoinByEquiJoinProcessorTest.instance().getMap(MAP_NAME);
    }

    @Test
    public void test_innerJoin() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, PROJECTION, TRUE_PREDICATE, Collections.singletonList(JoinByEquiJoinProcessorTest.jetRow(1)), Collections.singletonList(JoinByEquiJoinProcessorTest.jetRow(1, "value")));
    }

    @Test
    public void when_innerJoinFilteredOutByProjector_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, FALSE_PREDICATE, PROJECTION, TRUE_PREDICATE, Collections.singletonList(JoinByEquiJoinProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void when_innerJoinProjectedByProjector_then_modified() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, (Expression<?>)ConstantExpression.create((Object)"modified", (QueryDataType)QueryDataType.VARCHAR), TRUE_PREDICATE, Collections.singletonList(JoinByEquiJoinProcessorTest.jetRow(1)), Collections.singletonList(JoinByEquiJoinProcessorTest.jetRow(1, "modified")));
    }

    @Test
    public void when_innerJoinFilteredOutByCondition_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.INNER, TRUE_PREDICATE, PROJECTION, FALSE_PREDICATE, Collections.singletonList(JoinByEquiJoinProcessorTest.jetRow(1)), Collections.emptyList());
    }

    @Test
    public void test_outerJoin() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, PROJECTION, TRUE_PREDICATE, Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1), JoinByEquiJoinProcessorTest.jetRow(2)), Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1, "value"), JoinByEquiJoinProcessorTest.jetRow(2, null)));
    }

    @Test
    public void when_outerJoinFilteredOutByProjector_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, FALSE_PREDICATE, PROJECTION, TRUE_PREDICATE, Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1), JoinByEquiJoinProcessorTest.jetRow(2)), Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1, null), JoinByEquiJoinProcessorTest.jetRow(2, null)));
    }

    @Test
    public void when_outerJoinProjectedByProjector_then_modified() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, (Expression<?>)ConstantExpression.create((Object)"modified", (QueryDataType)QueryDataType.VARCHAR), TRUE_PREDICATE, Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1), JoinByEquiJoinProcessorTest.jetRow(2)), Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1, "modified"), JoinByEquiJoinProcessorTest.jetRow(2, null)));
    }

    @Test
    public void when_outerJoinFilteredOutByCondition_then_absent() {
        this.map.put((Object)1, (Object)"value");
        this.runTest(JoinRelType.LEFT, TRUE_PREDICATE, PROJECTION, FALSE_PREDICATE, Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1), JoinByEquiJoinProcessorTest.jetRow(2)), Arrays.asList(JoinByEquiJoinProcessorTest.jetRow(1, null), JoinByEquiJoinProcessorTest.jetRow(2, null)));
    }

    private void runTest(JoinRelType joinType, Expression<Boolean> rowProjectorCondition, Expression<?> rowProjectorProjection, Expression<Boolean> nonEquiCondition, List<JetSqlRow> input, List<JetSqlRow> output) {
        KvRowProjector.Supplier projectorSupplier = KvRowProjector.supplier((QueryPath[])new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT, QueryDataType.VARCHAR}, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, rowProjectorCondition, Collections.singletonList(rowProjectorProjection));
        ProcessorMetaSupplier processor = JoinByEquiJoinProcessorSupplier.supplier((JetJoinInfo)new JetJoinInfo(joinType, new int[]{0}, new int[]{0}, nonEquiCondition, null), (String)MAP_NAME, (KvRowProjector.Supplier)projectorSupplier);
        TestSupport.verifyProcessor((ProcessorMetaSupplier)TestContextSupport.adaptSupplier((ProcessorMetaSupplier)processor)).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).input(input).hazelcastInstance(JoinByEquiJoinProcessorTest.instance()).outputChecker(SqlTestSupport::compareRowLists).disableProgressAssertion().expectOutput(output);
    }
}

