/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvProjector;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Map;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class KvProjectorTest {
    @Test
    public void test_project() {
        KvProjector projector = new KvProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (UpsertTarget)new MultiplyingTarget(), (UpsertTarget)new MultiplyingTarget(), false);
        Map.Entry entry = projector.project(new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{1, 2}));
        Assertions.assertThat(entry.getKey()).isEqualTo((Object)2);
        Assertions.assertThat(entry.getValue()).isEqualTo((Object)4);
    }

    @Test
    public void test_projectAllowNulls() {
        KvProjector projector = new KvProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (UpsertTarget)new NullTarget(), (UpsertTarget)new NullTarget(), false);
        Map.Entry entry = projector.project(new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{1, 2}));
        Assertions.assertThat(entry.getKey()).isNull();
        Assertions.assertThat(entry.getValue()).isNull();
    }

    @Test
    public void test_projectKeyNullNotAllowed() {
        KvProjector projector = new KvProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (UpsertTarget)new NullTarget(), (UpsertTarget)new MultiplyingTarget(), true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projector.project(new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{1, 2}))).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot write NULL to '__key' field");
    }

    @Test
    public void test_projectValueNullNotAllowed() {
        KvProjector projector = new KvProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (UpsertTarget)new MultiplyingTarget(), (UpsertTarget)new NullTarget(), true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> projector.project(new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{1, 2}))).isInstanceOf(QueryException.class)).hasMessageContaining("Cannot write NULL to 'this' field");
    }

    @Test
    public void test_supplierSerialization() {
        InternalSerializationService serializationService = new DefaultSerializationServiceBuilder().build();
        KvProjector.Supplier original = KvProjector.supplier((QueryPath[])new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT, QueryDataType.VARCHAR}, (UpsertTargetDescriptor)PrimitiveUpsertTargetDescriptor.INSTANCE, (UpsertTargetDescriptor)PrimitiveUpsertTargetDescriptor.INSTANCE, (boolean)true);
        KvProjector.Supplier serialized = (KvProjector.Supplier)serializationService.toObject((Object)serializationService.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }

    private static final class MultiplyingTarget
    implements UpsertTarget {
        private Object value = -1;

        private MultiplyingTarget() {
        }

        public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
            return value -> {
                this.value = value;
            };
        }

        public void init() {
            this.value = null;
        }

        public Object conclude() {
            return (Integer)this.value * 2;
        }
    }

    private static final class NullTarget
    implements UpsertTarget {
        private NullTarget() {
        }

        public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
            return value -> {};
        }

        public void init() {
        }

        public Object conclude() {
            return null;
        }
    }
}

