/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.oracle;

import com.hazelcast.jet.sql.impl.connector.jdbc.AllTypesInsertJdbcSqlConnectorTest;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.jdbc.OracleDatabaseProviderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assumptions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NightlyTest.class})
public class OracleAllTypesInsertJdbcSqlConnectorTest
extends AllTypesInsertJdbcSqlConnectorTest {
    @Parameterized.Parameters(name="type:{0}, mappingType:{1}, sqlValue:{2}, javaValue:{3}, jdbcValue:{4}")
    public static Collection<Object[]> parameters() {
        Collection<Object[]> parentParams = AllTypesInsertJdbcSqlConnectorTest.parameters();
        ArrayList<Object[]> list = new ArrayList<Object[]>(parentParams);
        Object[][] additionalData = new Object[][]{{"BINARY_FLOAT", "REAL", "1.5", Float.valueOf(1.5f), Float.valueOf(1.5f)}, {"BINARY_DOUBLE", "DOUBLE", "1.8", 1.8, 1.8}};
        list.addAll(Arrays.asList(additionalData));
        return list;
    }

    @BeforeClass
    public static void beforeClass() {
        OracleAllTypesInsertJdbcSqlConnectorTest.initialize(OracleDatabaseProviderFactory.createTestDatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).describedAs("TINYINT not supported on Oracle", new Object[0])).isNotEqualTo((Object)"TINYINT");
        ((AbstractBooleanAssert)Assumptions.assumeThat((OracleDatabaseProviderFactory.isOracleFreeVersion() || !this.type.equals("BOOLEAN") ? 1 : 0) != 0).describedAs("BOOLEAN not supported on Oracle", new Object[0])).isTrue();
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).describedAs("BIGINT not supported on Oracle", new Object[0])).isNotEqualTo((Object)"BIGINT");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).describedAs("TIME not supported on Oracle", new Object[0])).isNotEqualTo((Object)"TIME");
        if (this.type.equals("DOUBLE")) {
            this.type = "DOUBLE PRECISION";
        }
    }
}

