/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mysql;

import com.hazelcast.jet.TestedVersions;
import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.jdbc.MySQLDatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import eu.rekawek.toxiproxy.Proxy;
import eu.rekawek.toxiproxy.ToxiproxyClient;
import eu.rekawek.toxiproxy.model.ToxicDirection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Category(value={NightlyTest.class})
public class MySqlDownTest
extends JdbcSqlTestSupport {
    @Rule
    public Network network = Network.newNetwork();
    @Rule
    public ToxiproxyContainer toxiproxy = (ToxiproxyContainer)new ToxiproxyContainer(TestedVersions.TOXIPROXY_IMAGE).withNetwork(this.network);
    private MySQLDatabaseProvider mySQLDatabaseProvider;
    private final String networkAlias = "mysql";

    @Before
    public void setUp() throws Exception {
        this.mySQLDatabaseProvider = new MySQLDatabaseProvider();
        this.mySQLDatabaseProvider.setNetwork(this.network, "mysql");
        MySqlDownTest.initialize((TestDatabaseProvider)this.mySQLDatabaseProvider);
    }

    @After
    public void tearDownProxy() {
        if (this.mySQLDatabaseProvider != null) {
            this.mySQLDatabaseProvider.shutdown();
            this.mySQLDatabaseProvider = null;
        }
    }

    @Test
    public void showDataConnectionsShouldReturnQuickly() throws Exception {
        MySqlDownTest.createTable("my_table");
        ToxiproxyClient toxiproxyClient = new ToxiproxyClient(this.toxiproxy.getHost(), this.toxiproxy.getControlPort());
        Proxy proxy = toxiproxyClient.createProxy("mysql", "0.0.0.0:8666", "mysql:3306");
        String host = this.toxiproxy.getHost();
        Integer port = this.toxiproxy.getMappedPort(8666);
        String url = dbConnectionUrl.replaceFirst("localhost:\\d+", host + ":" + port);
        sqlService.executeUpdate("CREATE DATA CONNECTION mysql TYPE Jdbc OPTIONS ('jdbcUrl'= '" + url + "' )", new Object[0]);
        sqlService.executeUpdate("CREATE MAPPING my_table DATA CONNECTION mysql", new Object[0]);
        proxy.toxics().timeout("timeout", ToxicDirection.UPSTREAM, 0L);
        Thread.sleep(1000L);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        SqlResult result = executor.submit(() -> sqlService.execute("SHOW DATA CONNECTIONS", new Object[0])).get(5L, TimeUnit.SECONDS);
        Assertions.assertThat(MySqlDownTest.allRows(result)).containsExactly((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("mysql", "Jdbc", SqlJsonTestSupport.jsonArray("Table")), new SqlTestSupport.Row("testDatabaseRef", "Jdbc", SqlJsonTestSupport.jsonArray("Table"))});
        result = executor.submit(() -> sqlService.execute("SHOW MAPPINGS", new Object[0])).get(5L, TimeUnit.SECONDS);
        Assertions.assertThat(MySqlDownTest.allRows(result)).containsExactly((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("my_table")});
    }
}

