/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SelectJdbcSqlConnectorParallelTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 5;
    private static final int THREAD_COUNT = 4;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        SelectJdbcSqlConnectorParallelTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = SelectJdbcSqlConnectorParallelTest.randomTableName();
        SelectJdbcSqlConnectorParallelTest.createTable(this.tableName);
        SelectJdbcSqlConnectorParallelTest.insertItems(this.tableName, 5);
        SelectJdbcSqlConnectorParallelTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void selectAllFromTableWhereIdColumnParallel() throws Exception {
        int repeatCount = 10000;
        Future[] futures = new Future[4];
        ExecutorService pool = Executors.newFixedThreadPool(4);
        try {
            for (int i = 0; i < 4; ++i) {
                futures[i] = pool.submit(() -> {
                    for (int j = 0; j < repeatCount; ++j) {
                        int key = ThreadLocalRandom.current().nextInt(5);
                        SelectJdbcSqlConnectorParallelTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName + " WHERE id = ?", (List<Object>)Lists.newArrayList((Object[])new Object[]{key}), (Collection<SqlTestSupport.Row>)Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(key, "name-" + key)}));
                    }
                });
            }
        }
        finally {
            pool.shutdown();
            Assertions.assertThat((boolean)pool.awaitTermination(ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS)).isTrue();
        }
        for (Future f : futures) {
            Assertions.assertThat((Future)f).succeedsWithin((long)ASSERT_TRUE_EVENTUALLY_TIMEOUT, TimeUnit.SECONDS);
        }
    }
}

